/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps.engine;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.operation.EntryOperator;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.StaticParams;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.wan.impl.CallerProvenance;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class State {
    private volatile RecordStore recordStore;
    private volatile MapOperation operation;
    private int partitionId = -1;
    private long threadId;
    private long ttl = -1L;
    private long maxIdle = -1L;
    private long version;
    private long now = Clock.currentTimeMillis();
    private Data key;
    private Address callerAddress;
    private Object expect;
    private StaticParams staticParams;
    private UUID txnId;
    private UUID ownerUuid;
    private CallerProvenance callerProvenance;
    private volatile boolean blockReads;
    private volatile boolean stopExecution;
    private volatile boolean recordExistsInMemory;
    private volatile boolean disableWanReplicationEvent;
    private volatile boolean triggerMapLoader;
    private volatile boolean shouldLoad;
    private volatile boolean changeExpiryOnUpdate = true;
    private volatile boolean entryProcessorOffloadable;
    private volatile Object oldValue;
    private volatile BiTuple<Object, Long> loadedOldValueWithTtl;
    private volatile Object newValue;
    private volatile Object result;
    private volatile Collection<Data> keysToLoad = Collections.emptyList();
    private volatile List loadedKeyAndOldValueWithTtlPairs = Collections.emptyList();
    private volatile Collection<Data> keys;
    private volatile List<Record> records;
    private volatile EntryProcessor entryProcessor;
    private volatile EntryOperator operator;
    private volatile List<State> toStore;
    private volatile List<State> toRemove;
    private volatile List backupPairs;
    private volatile Predicate predicate;
    private volatile List<SplitBrainMergeTypes.MapMergeTypes<Object, Object>> mergingEntries;
    private volatile SplitBrainMergePolicy<Object, SplitBrainMergeTypes.MapMergeTypes<Object, Object>, Object> mergePolicy;
    private volatile MapEntries mapEntries;
    private volatile EntryEventType entryEventType;
    private volatile Record record;
    private volatile Queue<InternalIndex> notMarkedIndexes;
    private volatile Set keysFromIndex;
    private volatile Throwable throwable;
    private volatile Consumer backupOpAfterRun;
    private volatile int sizeBefore;
    private volatile int sizeAfter;
    private volatile BitSet nonWanReplicatedIndexes;

    public State(RecordStore recordStore, MapOperation operation) {
        this.init(recordStore, operation);
    }

    public State(State state) {
        this.init(state.getRecordStore(), state.getOperation());
        this.setTtl(state.getTtl()).setMaxIdle(state.getMaxIdle()).setChangeExpiryOnUpdate(state.isChangeExpiryOnUpdate()).setVersion(state.getVersion()).setNow(state.getNow()).setStaticPutParams(state.getStaticParams()).setOwnerUuid(state.getOwnerUuid()).setTxnId(state.getTxnId()).setCallerProvenance(state.getCallerProvenance()).setEntryProcessor(state.getEntryProcessor()).setCallerAddress(state.getCallerAddress()).setPartitionId(state.getPartitionId());
    }

    public void init(RecordStore recordStore, MapOperation operation) {
        this.recordStore = recordStore;
        this.operation = operation;
    }

    public RecordStore getRecordStore() {
        return this.recordStore;
    }

    public MapOperation getOperation() {
        return this.operation;
    }

    public State setVersion(long version) {
        this.version = version;
        return this;
    }

    public State setPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public State setKey(Data key) {
        this.key = key;
        return this;
    }

    public State setNewValue(Object newValue) {
        this.newValue = newValue;
        return this;
    }

    public State setOldValue(Object oldValue) {
        this.oldValue = ((DefaultRecordStore)this.recordStore).copyToHeapWhenNeeded(oldValue);
        return this;
    }

    public BiTuple<Object, Long> getLoadedOldValueWithTtl() {
        return this.loadedOldValueWithTtl;
    }

    public void setLoadedOldValueWithTtl(BiTuple<Object, Long> loadedOldValueWithTtl) {
        this.loadedOldValueWithTtl = loadedOldValueWithTtl;
    }

    public State setRecordExistsInMemory(boolean recordExistsInMemory) {
        this.recordExistsInMemory = recordExistsInMemory;
        return this;
    }

    public State setExpect(Object expect) {
        this.expect = expect;
        return this;
    }

    public State setTxnId(UUID uuid) {
        this.txnId = uuid;
        return this;
    }

    public State setTtl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    public State setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
        return this;
    }

    public State setStaticPutParams(StaticParams staticStaticParams) {
        this.staticParams = staticStaticParams;
        return this;
    }

    public State setCallerAddress(Address callerAddress) {
        this.callerAddress = callerAddress;
        return this;
    }

    public State setCallerProvenance(CallerProvenance callerProvenance) {
        this.callerProvenance = callerProvenance;
        return this;
    }

    public State setEntryProcessor(EntryProcessor entryProcessor) {
        this.entryProcessor = entryProcessor;
        return this;
    }

    public boolean isEntryProcessorOffloadable() {
        return this.entryProcessorOffloadable;
    }

    public State setEntryProcessorOffloadable(boolean entryProcessorOffloadable) {
        this.entryProcessorOffloadable = entryProcessorOffloadable;
        return this;
    }

    public State setThreadId(long threadId) {
        this.threadId = threadId;
        return this;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public EntryProcessor getEntryProcessor() {
        return this.entryProcessor;
    }

    public boolean isRecordExistsInMemory() {
        return this.recordExistsInMemory;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public long getTtl() {
        return this.ttl;
    }

    public long getMaxIdle() {
        return this.maxIdle;
    }

    public long getVersion() {
        return this.version;
    }

    public long getNow() {
        return this.now;
    }

    public State setNow(long now) {
        this.now = now;
        return this;
    }

    public Data getKey() {
        return this.key;
    }

    public Address getCallerAddress() {
        return this.callerAddress;
    }

    public Object getExpect() {
        return this.expect;
    }

    public StaticParams getStaticParams() {
        return this.staticParams;
    }

    public UUID getTxnId() {
        return this.txnId;
    }

    public UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public State setOwnerUuid(UUID ownerUuid) {
        this.ownerUuid = ownerUuid;
        return this;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public CallerProvenance getCallerProvenance() {
        return this.callerProvenance;
    }

    public boolean isStopExecution() {
        return this.stopExecution;
    }

    public void setStopExecution(boolean stopExecution) {
        this.stopExecution = stopExecution;
    }

    public State setResult(Object result) {
        this.result = result;
        return this;
    }

    public Object getResult() {
        return this.result;
    }

    public void setRecord(Record record) {
        this.record = record;
    }

    public Record getRecord() {
        return this.record;
    }

    public State setKeys(Collection<Data> keys) {
        this.keys = keys;
        return this;
    }

    public Collection<Data> getKeys() {
        return this.keys;
    }

    public void setRecords(List<Record> records) {
        this.records = records;
    }

    public Collection<Data> getKeysToLoad() {
        return this.keysToLoad;
    }

    public State setKeysToLoad(Collection<Data> keysToLoad) {
        this.keysToLoad = keysToLoad;
        return this;
    }

    public State setLoadedKeyAndOldValueWithTtlPairs(List loadedKeyAndOldValueWithTtlPairs) {
        this.loadedKeyAndOldValueWithTtlPairs = loadedKeyAndOldValueWithTtlPairs;
        return this;
    }

    public List loadedKeyAndOldValueWithTtlPairs() {
        return this.loadedKeyAndOldValueWithTtlPairs;
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public State setEntryOperator(EntryOperator operator) {
        this.operator = operator;
        return this;
    }

    public EntryOperator getOperator() {
        return this.operator;
    }

    public void setToStore(List<State> toStore) {
        this.toStore = toStore;
    }

    public void setToRemove(List<State> toRemove) {
        this.toRemove = toRemove;
    }

    public List<State> getToStore() {
        return this.toStore;
    }

    public List<State> getToRemove() {
        return this.toRemove;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public State setPredicate(Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    public State setMergingEntries(List<SplitBrainMergeTypes.MapMergeTypes<Object, Object>> mergingEntries) {
        this.mergingEntries = mergingEntries;
        return this;
    }

    public List<SplitBrainMergeTypes.MapMergeTypes<Object, Object>> getMergingEntries() {
        return this.mergingEntries;
    }

    public State setMergePolicy(SplitBrainMergePolicy<Object, SplitBrainMergeTypes.MapMergeTypes<Object, Object>, Object> mergePolicy) {
        this.mergePolicy = mergePolicy;
        return this;
    }

    public SplitBrainMergePolicy<Object, SplitBrainMergeTypes.MapMergeTypes<Object, Object>, Object> getMergePolicy() {
        return this.mergePolicy;
    }

    public State setDisableWanReplicationEvent(boolean disableWanReplicationEvent) {
        this.disableWanReplicationEvent = disableWanReplicationEvent;
        return this;
    }

    public boolean isDisableWanReplicationEvent() {
        return this.disableWanReplicationEvent;
    }

    public State setMapEntries(MapEntries mapEntries) {
        this.mapEntries = mapEntries;
        return this;
    }

    public MapEntries getMapEntries() {
        return this.mapEntries;
    }

    public EntryEventType getEntryEventType() {
        return this.entryEventType;
    }

    public void setEntryEventType(EntryEventType entryEventType) {
        this.entryEventType = entryEventType;
    }

    public void setNotMarkedIndexes(Queue<InternalIndex> notMarkedIndexes) {
        this.notMarkedIndexes = notMarkedIndexes;
    }

    public Queue<InternalIndex> getNotMarkedIndexes() {
        return this.notMarkedIndexes;
    }

    public void setKeysFromIndex(Set keysFromIndex) {
        this.keysFromIndex = keysFromIndex;
    }

    public Set getKeysFromIndex() {
        return this.keysFromIndex;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public State setTriggerMapLoader(boolean triggerMapLoader) {
        this.triggerMapLoader = triggerMapLoader;
        return this;
    }

    public boolean isTriggerMapLoader() {
        return this.triggerMapLoader;
    }

    public State setShouldLoad(boolean shouldLoad) {
        this.shouldLoad = shouldLoad;
        return this;
    }

    public boolean isShouldLoad() {
        return this.shouldLoad;
    }

    public boolean isBlockReads() {
        return this.blockReads;
    }

    public State setBlockReads(boolean blockReads) {
        this.blockReads = blockReads;
        return this;
    }

    public void setBackupPairs(List backupPairs) {
        this.backupPairs = backupPairs;
    }

    public List getBackupPairs() {
        return this.backupPairs;
    }

    public State setChangeExpiryOnUpdate(boolean changeExpiryOnUpdate) {
        this.changeExpiryOnUpdate = changeExpiryOnUpdate;
        return this;
    }

    public boolean isChangeExpiryOnUpdate() {
        return this.changeExpiryOnUpdate;
    }

    public State setBackupOpAfterRun(Consumer backupOpAfterRun) {
        this.backupOpAfterRun = backupOpAfterRun;
        return this;
    }

    @Nullable
    public Consumer getBackupOpAfterRun() {
        return this.backupOpAfterRun;
    }

    public int getSizeBefore() {
        return this.sizeBefore;
    }

    public void setSizeBefore(int sizeBefore) {
        this.sizeBefore = sizeBefore;
    }

    public int getSizeAfter() {
        return this.sizeAfter;
    }

    public void setSizeAfter(int sizeAfter) {
        this.sizeAfter = sizeAfter;
    }

    public void setNonWanReplicatedIndexes(BitSet nonWanReplicationIndexes) {
        this.nonWanReplicatedIndexes = nonWanReplicationIndexes;
    }

    public BitSet getNonWanReplicatedIndexes() {
        return this.nonWanReplicatedIndexes;
    }
}

