/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.enterprise.wan.impl.replication.WanSyncException;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.collection.InflatableSet;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.MerkleTreeNodeEntries;
import com.hazelcast.map.impl.operation.EnterpriseMapDataSerializerHook;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import com.hazelcast.wan.impl.merkletree.MerkleTreeUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class MerkleTreeGetEntriesOperation
extends MapOperation
implements ReadonlyOperation {
    private int[] merkleTreeOrderValuePairs;
    private Collection<MerkleTreeNodeEntries> result;

    public MerkleTreeGetEntriesOperation() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public MerkleTreeGetEntriesOperation(String mapName, int[] merkleTreeOrderValuePairs) {
        super(mapName);
        this.merkleTreeOrderValuePairs = merkleTreeOrderValuePairs;
    }

    @Override
    protected void runInternal() {
        int partitionId = this.getPartitionId();
        if (!this.mapService.getMapServiceContext().getCachedOwnedPartitions().contains(partitionId)) {
            throw new WanSyncException("Partition: " + partitionId + " is migrated to another cluster during sync.");
        }
        EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)this.mapServiceContext.getPartitionContainer(partitionId);
        MerkleTree localMerkleTree = partitionContainer.getMerkleTreeOrNull(this.mapContainer);
        if (localMerkleTree == null || this.merkleTreeOrderValuePairs == null || this.merkleTreeOrderValuePairs.length == 0) {
            this.result = Collections.emptyList();
            return;
        }
        Int2ObjectHashMap entryBuilders = new Int2ObjectHashMap(MapUtil.calculateInitialCapacity(this.merkleTreeOrderValuePairs.length / 2), 0.75);
        for (int i = 0; i < this.merkleTreeOrderValuePairs.length; i += 2) {
            entryBuilders.put(this.merkleTreeOrderValuePairs[i], InflatableSet.newBuilder(1));
        }
        int levelOfRequestedNodes = MerkleTreeUtil.getLevelOfNode(this.merkleTreeOrderValuePairs[0]);
        InternalSerializationService serializationService = (InternalSerializationService)this.getNodeEngine().getSerializationService();
        this.recordStore.iterator().forEachRemaining(entry -> {
            Data keyData = (Data)entry.getKey();
            int keyHash = keyData.hashCode();
            int currentKeyNodeOrder = MerkleTreeUtil.getLeafOrderForHash(keyHash, levelOfRequestedNodes);
            InflatableSet.Builder entriesBuilder = (InflatableSet.Builder)entryBuilders.get(currentKeyNodeOrder);
            if (entriesBuilder != null) {
                Record record = (Record)entry.getValue();
                entriesBuilder.add(EntryViews.createWanEntryView(serializationService.toData((Object)keyData, DataType.HEAP), serializationService.toData(record.getValue(), DataType.HEAP), record, this.recordStore.getExpirySystem().getExpiryMetadata(keyData), serializationService));
            }
        });
        this.result = new ArrayList<MerkleTreeNodeEntries>(this.merkleTreeOrderValuePairs.length / 2);
        for (Map.Entry builderEntry : entryBuilders.entrySet()) {
            this.result.add(new MerkleTreeNodeEntries(builderEntry.getKey(), ((InflatableSet.Builder)builderEntry.getValue()).build()));
        }
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    public int getFactoryId() {
        return EnterpriseMapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.merkleTreeOrderValuePairs = in.readIntArray();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeIntArray(this.merkleTreeOrderValuePairs);
    }
}

