/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.ReadOnly;
import com.hazelcast.internal.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.Timer;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.ExtendedMapEntry;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.LockAwareLazyMapEntry;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.wan.impl.CallerProvenance;
import java.util.Map;

public final class EntryOperator {
    private final boolean shouldClone;
    private final boolean backup;
    private final boolean readOnly;
    private final boolean wanReplicationEnabled;
    private final boolean hasEventRegistration;
    private final int partitionId;
    private final long startTimeNanos = Timer.nanos();
    private final String mapName;
    private final RecordStore recordStore;
    private final InternalSerializationService ss;
    private final MapContainer mapContainer;
    private final MapEventPublisher mapEventPublisher;
    private final LocalMapStatsImpl stats;
    private final IPartitionService partitionService;
    private final Predicate predicate;
    private final MapServiceContext mapServiceContext;
    private final MapOperation mapOperation;
    private final Address callerAddress;
    private final InMemoryFormat inMemoryFormat;
    private EntryProcessor entryProcessor;
    private EntryProcessor backupProcessor;
    private boolean didMatchPredicate;
    private Data dataKey;
    private Object oldValue;
    private Object oldValueClone;
    private EntryEventType eventType;
    private Data result;
    private LockAwareLazyMapEntry entry;

    private EntryOperator(MapOperation mapOperation, Object processor, Predicate predicate, boolean collectWanEvents) {
        this.backup = mapOperation instanceof BackupOperation;
        this.setProcessor(processor);
        this.mapOperation = mapOperation;
        this.predicate = predicate;
        this.recordStore = mapOperation.recordStore;
        this.readOnly = this.entryProcessor instanceof ReadOnly;
        this.mapContainer = this.recordStore.getMapContainer();
        this.inMemoryFormat = this.mapContainer.getMapConfig().getInMemoryFormat();
        this.mapName = this.mapContainer.getName();
        this.wanReplicationEnabled = this.mapContainer.getWanContext().isWanReplicationEnabled();
        this.shouldClone = this.mapContainer.shouldCloneOnEntryProcessing(mapOperation.getPartitionId());
        this.mapServiceContext = this.mapContainer.getMapServiceContext();
        LocalMapStatsProvider localMapStatsProvider = this.mapServiceContext.getLocalMapStatsProvider();
        this.stats = localMapStatsProvider.getLocalMapStatsImpl(this.mapName);
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        this.ss = (InternalSerializationService)nodeEngine.getSerializationService();
        this.partitionService = nodeEngine.getPartitionService();
        EventService eventService = nodeEngine.getEventService();
        this.hasEventRegistration = eventService.hasEventRegistration("hz:impl:mapService", this.mapName);
        this.mapEventPublisher = this.mapServiceContext.getMapEventPublisher();
        this.partitionId = this.recordStore.getPartitionId();
        this.callerAddress = mapOperation.getCallerAddress();
        this.entry = new LockAwareLazyMapEntry();
    }

    public EntryProcessor getEntryProcessor() {
        return this.entryProcessor;
    }

    private void setProcessor(Object processor) {
        if (this.backup) {
            this.backupProcessor = (EntryProcessor)processor;
            this.entryProcessor = null;
        } else {
            this.entryProcessor = (EntryProcessor)processor;
            this.backupProcessor = null;
        }
    }

    public static EntryOperator operator(MapOperation mapOperation) {
        return new EntryOperator(mapOperation, null, null, false);
    }

    public static EntryOperator operator(MapOperation mapOperation, Object processor) {
        return new EntryOperator(mapOperation, processor, null, false);
    }

    public static EntryOperator operator(MapOperation mapOperation, Object processor, Predicate predicate) {
        return new EntryOperator(mapOperation, processor, predicate, false);
    }

    public EntryOperator init(Data dataKey, Object oldValue, Object newValue, Data result, EntryEventType eventType, Boolean locked, boolean changeExpiryOnUpdate, long ttl) {
        this.dataKey = dataKey;
        this.oldValue = oldValue;
        this.oldValueClone = oldValue;
        this.eventType = eventType;
        this.result = result;
        this.didMatchPredicate = true;
        this.entry.init(this.ss, dataKey, newValue != null ? newValue : oldValue, this.mapContainer.getExtractors(), locked, ttl, changeExpiryOnUpdate);
        return this;
    }

    public boolean isDidMatchPredicate() {
        return this.didMatchPredicate;
    }

    public LockAwareLazyMapEntry getEntry() {
        return this.entry;
    }

    public EntryOperator operateOnKey(Data dataKey) {
        this.init(dataKey, null, null, null, null, null, true, -1L);
        if (this.belongsAnotherPartition(dataKey)) {
            return this;
        }
        this.oldValue = this.recordStore.get(dataKey, this.backup, this.callerAddress, false);
        if (this.predicate != null && this.oldValue == null) {
            return this;
        }
        Boolean locked = this.recordStore.isLocked(dataKey);
        this.init(dataKey, this.clonedOrRawOldValue(), null, null, null, locked, true, -1L);
        return this.operateOnKeyValueInternal();
    }

    public boolean checkCanProceed() {
        if (this.belongsAnotherPartition(this.dataKey)) {
            return false;
        }
        return this.predicate == null || this.oldValue != null;
    }

    public EntryOperator operateOnKeyValue(Data dataKey, Object oldValue) {
        this.init(dataKey, oldValue, null, null, null, null, true, -1L);
        return this.operateOnKeyValueInternal();
    }

    public EntryOperator operateOnKeyValueInternal() {
        if (this.outOfPredicateScope(this.entry)) {
            this.didMatchPredicate = false;
            return this;
        }
        this.oldValueClone = !this.readOnly && this.hasEventRegistration && this.inMemoryFormat != InMemoryFormat.OBJECT ? this.mapServiceContext.toData(this.oldValue) : this.oldValue;
        this.process(this.entry);
        this.findModificationType(this.entry);
        if (this.readOnly && this.entryWasModified()) {
            this.throwModificationInReadOnlyException();
        }
        return this;
    }

    private boolean entryWasModified() {
        return this.eventType != null;
    }

    public EntryEventType getEventType() {
        return this.eventType;
    }

    public Object getByPreferringDataNewValue() {
        return this.entry.getByPrioritizingDataValue();
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getOldValueClone() {
        return this.oldValueClone;
    }

    public Data getResult() {
        return this.result;
    }

    public EntryOperator doPostOperateOps() {
        if (!this.didMatchPredicate) {
            return this;
        }
        if (this.eventType == null) {
            this.onTouched();
            return this;
        }
        switch (this.eventType) {
            case UPDATED: {
                this.onTouched();
                this.onAddedOrUpdated();
                break;
            }
            case ADDED: {
                this.onAddedOrUpdated();
                break;
            }
            case REMOVED: {
                this.onRemove();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected event found:" + String.valueOf((Object)this.eventType));
            }
        }
        this.doPostOperateOps0();
        return this;
    }

    public void doPostOperateOps0() {
        if (this.wanReplicationEnabled) {
            this.publishWanReplicationEvent();
        }
        if (!this.backup) {
            if (this.hasEventRegistration) {
                this.publishEntryEvent();
            }
            this.mapOperation.invalidateNearCache(this.dataKey);
        }
        this.mapOperation.evict(this.dataKey);
    }

    private void onAddedOrUpdated() {
        Object newValue = this.extractNewValue();
        if (this.backup) {
            this.recordStore.putBackup(this.dataKey, newValue, this.entry.isChangeExpiryOnUpdate(), this.entry.getNewTtl(), -1L, -1L, CallerProvenance.NOT_WAN);
        } else {
            this.recordStore.setWithUncountedAccess(this.dataKey, newValue, this.entry.isChangeExpiryOnUpdate(), this.entry.getNewTtl(), -1L);
            this.onAddedOrUpdated0(newValue);
        }
    }

    public void onAddedOrUpdated0(Object newValue) {
        if (this.mapOperation.isPostProcessingOrHasInterceptor(this.recordStore)) {
            Object record = this.recordStore.getRecord(this.dataKey);
            newValue = record == null ? null : record.getValue();
            this.entry.setValueByInMemoryFormat(this.inMemoryFormat, newValue);
        }
        this.mapServiceContext.interceptAfterPut(this.mapContainer.getInterceptorRegistry(), newValue);
        this.stats.incrementPutLatencyNanos(Timer.nanosElapsed(this.startTimeNanos));
    }

    public Object extractNewValue() {
        return this.inMemoryFormat == InMemoryFormat.OBJECT ? this.entry.getValue() : this.entry.getByPrioritizingDataValue();
    }

    private void onRemove() {
        if (this.backup) {
            this.recordStore.removeBackup(this.dataKey, CallerProvenance.NOT_WAN);
        } else {
            this.recordStore.delete(this.dataKey, CallerProvenance.NOT_WAN);
            this.onRemove0();
        }
    }

    public void onRemove0() {
        this.mapServiceContext.interceptAfterRemove(this.mapContainer.getInterceptorRegistry(), this.oldValue);
        this.stats.incrementRemoveLatencyNanos(Timer.nanosElapsed(this.startTimeNanos));
    }

    public Object clonedOrRawOldValue() {
        return this.shouldClone ? this.ss.toObject(this.ss.toData(this.oldValue)) : this.oldValue;
    }

    public boolean belongsAnotherPartition(Data key) {
        return this.partitionService.getPartitionId(key) != this.partitionId;
    }

    private boolean outOfPredicateScope(Map.Entry entry) {
        assert (entry instanceof QueryableEntry);
        if (this.predicate == null || this.predicate == Predicates.alwaysTrue()) {
            return false;
        }
        return this.predicate == Predicates.alwaysFalse() || !this.predicate.apply(entry);
    }

    public void findModificationType(LazyMapEntry mapEntry) {
        if (!mapEntry.isModified() || this.oldValue == null && mapEntry.hasNullValue()) {
            this.eventType = null;
            return;
        }
        if (mapEntry.hasNullValue()) {
            this.eventType = EntryEventType.REMOVED;
            return;
        }
        this.eventType = this.oldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
    }

    public void onTouched() {
        Object record = this.recordStore.getRecord(this.dataKey);
        if (record != null) {
            this.recordStore.accessRecord(this.dataKey, (Record)record, Clock.currentTimeMillis());
        }
    }

    public void process(ExtendedMapEntry entry) {
        if (this.backup) {
            this.backupProcessor.process(entry);
            return;
        }
        this.result = this.ss.toData(this.entryProcessor.process(entry));
    }

    private void throwModificationInReadOnlyException() {
        throw new UnsupportedOperationException("Entry Processor " + this.entryProcessor.getClass().getName() + " marked as ReadOnly tried to modify map " + this.mapName + ". This is not supported. Remove the ReadOnly marker from the Entry Processor or do not modify the entry in the process method.");
    }

    private void publishWanReplicationEvent() {
        assert (this.entryWasModified());
        if (this.eventType == EntryEventType.REMOVED) {
            this.mapOperation.publishWanRemove(this.dataKey);
        } else {
            this.mapOperation.publishWanUpdate(this.dataKey, this.entry.getByPrioritizingDataValue());
        }
    }

    private void publishEntryEvent() {
        Object oldValue = this.getOrNullOldValue();
        this.mapEventPublisher.publishEvent(this.callerAddress, this.mapName, this.eventType, ToHeapDataConverter.toHeapData(this.dataKey), oldValue, this.entry.getByPrioritizingDataValue());
    }

    private Object getOrNullOldValue() {
        if (this.inMemoryFormat == InMemoryFormat.OBJECT && this.eventType != EntryEventType.REMOVED) {
            return null;
        }
        return this.oldValueClone;
    }
}

