/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.IterableUtil;
import com.hazelcast.internal.util.StateMachine;
import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.internal.util.concurrent.IdleStrategy;
import com.hazelcast.internal.util.scheduler.CoalescingDelayedTrigger;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.impl.MapKeyLoaderUtil;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.operation.KeyLoadStatusOperation;
import com.hazelcast.map.impl.operation.KeyLoadStatusOperationFactory;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.operation.TriggerLoadIfNeededOperation;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class MapKeyLoader {
    public static final int DEFAULT_LOADED_KEY_LIMIT_PER_NODE = 50000;
    public static final String PROP_LOADED_KEY_LIMITER_PER_NODE = "hazelcast.map.loaded.key.limit.per.node";
    public static final HazelcastProperty LOADED_KEY_LIMITER_PER_NODE = new HazelcastProperty("hazelcast.map.loaded.key.limit.per.node", 50000);
    private static final long LOADING_TRIGGER_DELAY = TimeUnit.SECONDS.toMillis(5L);
    private static final IdleStrategy IDLE_STRATEGY = new BackoffIdleStrategy(0L, 0L, TimeUnit.MILLISECONDS.toNanos(1L), TimeUnit.MILLISECONDS.toNanos(500L));
    private ILogger logger;
    private String mapName;
    private OperationService opService;
    private IPartitionService partitionService;
    private Function<Object, Data> toData;
    private ExecutionService execService;
    private CoalescingDelayedTrigger delayedTrigger;
    private int maxSizePerNode;
    private int maxBatch;
    private int mapNamePartition;
    private int partitionId;
    private boolean hasBackup;
    private LoadFinishedFuture keyLoadFinished = new LoadFinishedFuture(true);
    private MapOperationProvider operationProvider;
    private final StateMachine<Role> role = StateMachine.of(Role.NONE).withTransition(Role.NONE, Role.SENDER, new Role[]{Role.RECEIVER, Role.SENDER_BACKUP}).withTransition(Role.SENDER_BACKUP, Role.SENDER, new Role[0]);
    private final StateMachine<State> state = StateMachine.of(State.NOT_LOADED).withTransition(State.NOT_LOADED, State.LOADING, new State[0]).withTransition(State.LOADING, State.LOADED, new State[]{State.NOT_LOADED}).withTransition(State.LOADED, State.LOADING, new State[0]);
    private final Semaphore nodeWideLoadedKeyLimiter;
    private final ClusterService clusterService;

    public MapKeyLoader(String mapName, OperationService opService, IPartitionService ps, ClusterService clusterService, ExecutionService execService, Function<Object, Data> serialize, Semaphore nodeWideLoadedKeyLimiter) {
        this.mapName = mapName;
        this.opService = opService;
        this.partitionService = ps;
        this.clusterService = clusterService;
        this.toData = serialize;
        this.execService = execService;
        this.logger = Logger.getLogger(MapKeyLoader.class);
        this.nodeWideLoadedKeyLimiter = nodeWideLoadedKeyLimiter;
    }

    public Future startInitialLoad(MapStoreContext mapStoreContext, int partitionId) {
        this.partitionId = partitionId;
        this.mapNamePartition = this.partitionService.getPartitionId(this.toData.apply(this.mapName));
        Role newRole = this.calculateRole();
        this.role.nextOrStay(newRole);
        this.state.next(State.LOADING);
        this.logStateMessage("startInitialLoad");
        switch (newRole) {
            case SENDER: {
                return this.sendKeys(mapStoreContext, false);
            }
            case SENDER_BACKUP: 
            case RECEIVER: {
                return this.triggerLoading();
            }
        }
        return this.keyLoadFinished;
    }

    private Role calculateRole() {
        IPartition partition;
        Address firstReplicaAddress;
        MemberImpl member;
        boolean isPartitionOwner = this.partitionService.isPartitionOwner(this.partitionId);
        boolean isMapNamePartition = this.partitionId == this.mapNamePartition;
        boolean isMapNamePartitionFirstReplica = false;
        if (this.hasBackup && isMapNamePartition && (member = this.clusterService.getMember(firstReplicaAddress = (partition = this.partitionService.getPartition(this.partitionId)).getReplicaAddress(1))) != null) {
            isMapNamePartitionFirstReplica = member.localMember();
        }
        return MapKeyLoaderUtil.assignRole(isPartitionOwner, isMapNamePartition, isMapNamePartitionFirstReplica);
    }

    private Future<?> sendKeys(MapStoreContext mapStoreContext, boolean replaceExistingValues) {
        if (this.keyLoadFinished.isDone()) {
            this.keyLoadFinished = new LoadFinishedFuture();
            Future<Boolean> sent = this.execService.submit("hz:map-loadAllKeys", () -> {
                this.sendKeysInBatches(mapStoreContext, replaceExistingValues);
                return false;
            });
            this.execService.asCompletableFuture(sent).whenCompleteAsync((BiConsumer)this.keyLoadFinished, ConcurrencyUtil.getDefaultAsyncExecutor());
        }
        return this.keyLoadFinished;
    }

    private Future triggerLoading() {
        if (this.keyLoadFinished.isDone()) {
            this.keyLoadFinished = new LoadFinishedFuture();
            this.execService.execute("hz:map-loadAllKeys", () -> {
                TriggerLoadIfNeededOperation op = new TriggerLoadIfNeededOperation(this.mapName);
                this.opService.invokeOnPartition("hz:impl:mapService", op, this.mapNamePartition).whenCompleteAsync(this.loadingFinishedCallback(), ConcurrencyUtil.getDefaultAsyncExecutor());
            });
        }
        return this.keyLoadFinished;
    }

    private BiConsumer<Boolean, Throwable> loadingFinishedCallback() {
        return (loadingFinished, throwable) -> {
            if (throwable == null) {
                if (loadingFinished.booleanValue()) {
                    this.updateLocalKeyLoadStatus(null);
                }
            } else {
                this.updateLocalKeyLoadStatus((Throwable)throwable);
            }
        };
    }

    private void updateLocalKeyLoadStatus(Throwable t) {
        KeyLoadStatusOperation op = new KeyLoadStatusOperation(this.mapName, t);
        if (this.hasBackup && this.role.is(Role.SENDER_BACKUP, new Role[0])) {
            this.opService.createInvocationBuilder("hz:impl:mapService", (Operation)op, this.partitionId).setReplicaIndex(1).invoke();
        } else {
            this.opService.createInvocationBuilder("hz:impl:mapService", (Operation)op, this.partitionId).invoke();
        }
    }

    public Future<?> startLoading(MapStoreContext mapStoreContext, boolean replaceExistingValues) {
        this.role.nextOrStay(Role.SENDER);
        if (this.state.is(State.LOADING, new State[0])) {
            return this.keyLoadFinished;
        }
        this.state.next(State.LOADING);
        return this.sendKeys(mapStoreContext, replaceExistingValues);
    }

    public void trackLoading(boolean lastBatch, Throwable exception) {
        if (lastBatch) {
            this.state.nextOrStay(State.LOADED);
            if (exception != null) {
                this.keyLoadFinished.completeExceptionally(exception);
            } else {
                this.keyLoadFinished.complete(true);
            }
        } else if (this.state.is(State.LOADED, new State[0])) {
            this.state.next(State.LOADING);
        }
    }

    public void triggerLoadingWithDelay() {
        if (this.delayedTrigger == null) {
            Runnable runnable = () -> {
                TriggerLoadIfNeededOperation op = new TriggerLoadIfNeededOperation(this.mapName);
                this.opService.invokeOnPartition("hz:impl:mapService", op, this.mapNamePartition);
            };
            this.delayedTrigger = new CoalescingDelayedTrigger(this.execService, LOADING_TRIGGER_DELAY, LOADING_TRIGGER_DELAY, runnable);
        }
        this.delayedTrigger.executeWithDelay();
    }

    public boolean shouldDoInitialLoad() {
        if (this.role.is(Role.SENDER_BACKUP, new Role[0])) {
            this.role.next(Role.SENDER);
            if (this.state.is(State.LOADING, new State[0])) {
                this.state.next(State.NOT_LOADED);
                this.keyLoadFinished.complete(false);
            }
        }
        return this.state.is(State.NOT_LOADED, new State[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendKeysInBatches(MapStoreContext mapStoreContext, boolean replaceExistingValues) throws Exception {
        this.logStateMessage("sendKeysInBatches");
        int clusterSize = this.partitionService.getMemberPartitionsMap().size();
        Iterator<Object> keys = null;
        Exception loadError = null;
        try {
            Iterable<Object> allKeys = mapStoreContext.loadAllKeys();
            keys = allKeys.iterator();
            Iterator<Data> dataKeys = IterableUtil.map(keys, this.toData);
            int mapMaxSize = clusterSize * this.maxSizePerNode;
            if (mapMaxSize > 0) {
                dataKeys = IterableUtil.limit(dataKeys, mapMaxSize);
            }
            Iterator<Map.Entry<Integer, Data>> partitionsAndKeys = IterableUtil.map(dataKeys, MapKeyLoaderUtil.toPartition(this.partitionService));
            Iterator<Map<Integer, List<Data>>> batches = MapKeyLoaderUtil.toBatches(partitionsAndKeys, this.maxBatch, this.nodeWideLoadedKeyLimiter);
            int callCount = 0;
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            while (batches.hasNext()) {
                Map<Integer, List<Data>> batch = batches.next();
                if (batch.isEmpty()) {
                    IDLE_STRATEGY.idle(++callCount);
                    continue;
                }
                callCount = 0;
                futures.addAll(this.sendBatch(batch, replaceExistingValues, this.nodeWideLoadedKeyLimiter));
            }
            FutureUtil.waitForever(futures);
        }
        catch (Exception caught) {
            loadError = caught;
        }
        finally {
            this.sendKeyLoadCompleted(clusterSize, loadError);
            if (keys instanceof Closeable) {
                Closeable closeable = (Closeable)((Object)keys);
                IOUtil.closeResource(closeable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Future<Object>> sendBatch(Map<Integer, List<Data>> batch, boolean replaceExistingValues, Semaphore nodeWideLoadedKeyLimiter) {
        Set<Map.Entry<Integer, List<Data>>> entries = batch.entrySet();
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(entries.size());
        Iterator<Map.Entry<Integer, List<Data>>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, List<Data>> e = iterator.next();
            int partitionId = e.getKey();
            List<Data> keys = e.getValue();
            int numberOfLoadedKeys = keys.size();
            try {
                MapOperation op = this.operationProvider.createLoadAllOperation(this.mapName, keys, replaceExistingValues);
                InvocationFuture future = this.opService.invokeOnPartition("hz:impl:mapService", op, partitionId);
                futures.add(future);
            }
            finally {
                nodeWideLoadedKeyLimiter.release(numberOfLoadedKeys);
            }
            iterator.remove();
        }
        return futures;
    }

    private void sendKeyLoadCompleted(int clusterSize, Throwable exception) throws Exception {
        ArrayList futures = new ArrayList();
        KeyLoadStatusOperation senderStatus = new KeyLoadStatusOperation(this.mapName, exception);
        InvocationFuture senderFuture = this.opService.createInvocationBuilder("hz:impl:mapService", (Operation)senderStatus, this.mapNamePartition).setReplicaIndex(0).invoke();
        futures.add(senderFuture);
        if (this.hasBackup && clusterSize > 1) {
            KeyLoadStatusOperation senderBackupStatus = new KeyLoadStatusOperation(this.mapName, exception);
            InvocationFuture senderBackupFuture = this.opService.createInvocationBuilder("hz:impl:mapService", (Operation)senderBackupStatus, this.mapNamePartition).setReplicaIndex(1).invoke();
            futures.add(senderBackupFuture);
        }
        FutureUtil.waitForever(futures);
        this.opService.invokeOnAllPartitions("hz:impl:mapService", new KeyLoadStatusOperationFactory(this.mapName, exception));
    }

    public void setMaxBatch(int maxBatch) {
        this.maxBatch = maxBatch;
    }

    public void setMaxSize(int maxSize) {
        this.maxSizePerNode = maxSize;
    }

    public void setHasBackup(boolean hasBackup) {
        this.hasBackup = hasBackup;
    }

    public void setMapOperationProvider(MapOperationProvider operationProvider) {
        this.operationProvider = operationProvider;
    }

    public boolean isKeyLoadFinished() {
        return this.keyLoadFinished.isDone();
    }

    public void promoteToLoadedOnMigration() {
        this.state.next(State.LOADING);
        this.state.next(State.LOADED);
    }

    private void logStateMessage(String methodName) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("%s invoked on partitionId=%s on %s role=%s state=%s, called from:\n%s", methodName, this.partitionId, this.clusterService.getThisAddress(), this.role, this.state, ReflectionUtils.getStackTrace(Thread.currentThread()));
        }
    }

    private static final class LoadFinishedFuture
    extends InternalCompletableFuture<Boolean>
    implements BiConsumer<Boolean, Throwable> {
        private LoadFinishedFuture(Boolean result) {
            this.complete(result);
        }

        private LoadFinishedFuture() {
        }

        @Override
        public Boolean get(long timeout, TimeUnit timeUnit) {
            if (this.isDone()) {
                return (Boolean)this.joinInternal();
            }
            throw new UnsupportedOperationException("Future is not done yet");
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public void accept(Boolean loaded, Throwable throwable) {
            if (throwable == null) {
                if (loaded.booleanValue()) {
                    this.complete(true);
                }
            } else {
                this.completeExceptionally(throwable);
            }
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "{done=" + this.isDone() + "}";
        }
    }

    static enum Role {
        NONE,
        SENDER,
        RECEIVER,
        SENDER_BACKUP;

    }

    static enum State {
        NOT_LOADED,
        LOADING,
        LOADED;

    }
}

