/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.CacheDeserializedValues;
import com.hazelcast.config.Config;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.eviction.EvictionPolicyEvaluatorProvider;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MemoryInfoAccessor;
import com.hazelcast.internal.util.RuntimeMemoryInfoAccessor;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.map.impl.InterceptorRegistry;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.eviction.EvictionChecker;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.eviction.EvictorImpl;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.MapStoreContextFactory;
import com.hazelcast.map.impl.query.QueryEntryFactory;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.wan.MapWanContext;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.query.impl.IndexRegistry;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.spi.eviction.EvictionPolicyComparator;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class MapContainerImpl
implements MapContainer {
    public static final String PROP_QUERY_EXPIRATION_CHECK_ENABLED = "hazelcast.internal.map.query.expiration.check.enabled";
    private static final boolean DEFAULT_QUERY_EXPIRATION_CHECK_ENABLED = true;
    private static final HazelcastProperty QUERY_EXPIRATION_CHECK_ENABLED = new HazelcastProperty("hazelcast.internal.map.query.expiration.check.enabled", true);
    protected final String name;
    protected final String splitBrainProtectionName;
    protected final Extractors extractors;
    protected final MapStoreContext mapStoreContext;
    protected final ObjectNamespace objectNamespace;
    protected final IndexRegistry globalIndexRegistry;
    protected final MapServiceContext mapServiceContext;
    protected final QueryEntryFactory queryEntryFactory;
    protected final EventJournalConfig eventJournalConfig;
    protected final PartitioningStrategy partitioningStrategy;
    protected final InternalSerializationService serializationService;
    protected final Function<Object, Data> toDataFunction = new ObjectToData();
    protected final InterceptorRegistry interceptorRegistry = new InterceptorRegistry();
    protected final ConcurrentMap<Integer, IndexRegistry> partitionedIndexRegistry = new ConcurrentHashMap<Integer, IndexRegistry>();
    protected final AtomicInteger invalidationListenerCount = new AtomicInteger();
    protected final AtomicLong lastInvalidMergePolicyCheckTime = new AtomicLong();
    protected final AtomicBoolean onDestroyCalled = new AtomicBoolean();
    protected volatile MapConfig mapConfig;
    private volatile Evictor evictor;
    private final MapWanContext wanContext;
    private final boolean queryExpirationCheckEnabled;
    private volatile boolean destroyed;

    public MapContainerImpl(String name, Config config, MapServiceContext mapServiceContext) {
        this.name = name;
        this.mapConfig = config.findMapConfig(name);
        this.eventJournalConfig = this.mapConfig.getEventJournalConfig();
        this.mapServiceContext = mapServiceContext;
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        this.partitioningStrategy = this.createPartitioningStrategy();
        this.splitBrainProtectionName = this.mapConfig.getSplitBrainProtectionName();
        this.serializationService = (InternalSerializationService)nodeEngine.getSerializationService();
        this.objectNamespace = MapService.getObjectNamespace(name);
        this.extractors = Extractors.newBuilder(this.serializationService).setAttributeConfigs(this.mapConfig.getAttributeConfigs()).setClassLoader(NamespaceUtil.getClassLoaderForNamespace(nodeEngine, this.mapConfig.getUserCodeNamespace())).build();
        this.queryEntryFactory = new QueryEntryFactory(this.mapConfig.getCacheDeserializedValues(), this.serializationService, this.extractors);
        HazelcastProperties properties = nodeEngine.getProperties();
        this.queryExpirationCheckEnabled = properties.getBoolean(QUERY_EXPIRATION_CHECK_ENABLED);
        this.globalIndexRegistry = this.shouldUseGlobalIndex() ? this.createIndexRegistry(true, -1) : null;
        this.mapStoreContext = MapStoreContextFactory.createMapStoreContext(this);
        this.wanContext = new MapWanContext(this);
    }

    @Override
    public void init() {
        this.initEvictor();
        this.mapStoreContext.start();
        this.wanContext.start();
    }

    @Override
    public IndexRegistry createIndexRegistry(boolean global, int partitionId) {
        int partitionCount = this.mapServiceContext.getNodeEngine().getPartitionService().getPartitionCount();
        Node node = this.mapServiceContext.getNodeEngine().getNode();
        return IndexRegistry.newBuilder(node, this.getName(), this.serializationService, this.mapServiceContext.getIndexCopyBehavior(), this.mapConfig.getInMemoryFormat()).global(global).extractors(this.extractors).statsEnabled(this.mapConfig.isStatisticsEnabled()).indexProvider(this.mapServiceContext.getIndexProvider(this.mapConfig)).usesCachedQueryableEntries(this.mapConfig.getCacheDeserializedValues() != CacheDeserializedValues.NEVER).partitionCount(partitionCount).partitionId(partitionId).resultFilterFactory(this.queryExpirationCheckEnabled ? new IndexResultFilterFactory() : null).build();
    }

    private IndexRegistry getOrCreatePartitionedIndexRegistry(int partitionId) {
        if (this.shouldUseGlobalIndex()) {
            throw new IllegalStateException("Can't use a partitioned-index in the context of a global-index.");
        }
        return this.partitionedIndexRegistry.computeIfAbsent(partitionId, integer -> this.createIndexRegistry(false, partitionId));
    }

    @Override
    public AtomicLong getLastInvalidMergePolicyCheckTime() {
        return this.lastInvalidMergePolicyCheckTime;
    }

    private boolean hasNotExpired(QueryableEntry queryableEntry, long now) {
        RecordStore recordStore;
        Data keyData = queryableEntry.getKeyData();
        IPartitionService partitionService = this.mapServiceContext.getNodeEngine().getPartitionService();
        int partitionId = partitionService.getPartitionId(keyData);
        if (!this.getOrCreateIndexRegistry(partitionId).isGlobal()) {
            ThreadUtil.assertRunningOnPartitionThread();
        }
        return (recordStore = this.mapServiceContext.getExistingRecordStore(partitionId, this.name)) != null && !recordStore.isExpired(keyData, now, false);
    }

    @Override
    public final void initEvictor() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        EvictionPolicyComparator evictionPolicyComparator = EvictionPolicyEvaluatorProvider.getEvictionPolicyComparator(this.mapConfig.getEvictionConfig(), nodeEngine.getConfigClassLoader());
        this.evictor = evictionPolicyComparator != null ? this.newEvictor(evictionPolicyComparator, nodeEngine.getProperties().getInteger(ClusterProperty.MAP_EVICTION_BATCH_SIZE), nodeEngine.getPartitionService()) : Evictor.NULL_EVICTOR;
    }

    protected Evictor newEvictor(EvictionPolicyComparator evictionPolicyComparator, int evictionBatchSize, IPartitionService partitionService) {
        EvictionChecker evictionChecker = new EvictionChecker(MapContainerImpl.getMemoryInfoAccessor(), this.mapServiceContext);
        return new EvictorImpl(evictionPolicyComparator, evictionChecker, evictionBatchSize, partitionService);
    }

    @Override
    public boolean shouldUseGlobalIndex() {
        return this.mapConfig.getInMemoryFormat() != InMemoryFormat.NATIVE || !this.mapConfig.getTieredStoreConfig().isEnabled() && this.mapServiceContext.globalIndexEnabled() || this.mapServiceContext.isForciblyEnabledGlobalIndex();
    }

    protected static MemoryInfoAccessor getMemoryInfoAccessor() {
        MemoryInfoAccessor pluggedMemoryInfoAccessor = MapContainerImpl.getPluggedMemoryInfoAccessor();
        return pluggedMemoryInfoAccessor != null ? pluggedMemoryInfoAccessor : new RuntimeMemoryInfoAccessor();
    }

    private static MemoryInfoAccessor getPluggedMemoryInfoAccessor() {
        String memoryInfoAccessorImpl = System.getProperty("hazelcast.memory.info.accessor.impl");
        if (memoryInfoAccessorImpl == null) {
            return null;
        }
        try {
            return (MemoryInfoAccessor)ClassLoaderUtil.newInstance(null, memoryInfoAccessorImpl);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private PartitioningStrategy createPartitioningStrategy() {
        return this.mapServiceContext.getPartitioningStrategy(this.mapConfig.getName(), this.mapConfig.getPartitioningStrategyConfig(), this.mapConfig.getPartitioningAttributeConfigs());
    }

    @Override
    public IndexRegistry getOrCreateIndexRegistry(int partitionId) {
        if (this.globalIndexRegistry != null) {
            return this.globalIndexRegistry;
        }
        return this.getOrCreatePartitionedIndexRegistry(partitionId);
    }

    @Override
    public IndexRegistry getGlobalIndexRegistry() {
        return this.globalIndexRegistry;
    }

    @Override
    @Nullable
    public IndexRegistry getOrNullPartitionedIndexRegistry(int partitionId) {
        return (IndexRegistry)this.partitionedIndexRegistry.get(partitionId);
    }

    @Override
    public ConcurrentMap<Integer, IndexRegistry> getPartitionedIndexRegistry() {
        return this.partitionedIndexRegistry;
    }

    @Override
    public boolean isEmptyIndexRegistry() {
        if (this.globalIndexRegistry != null) {
            return this.globalIndexRegistry.getIndexes().length == 0;
        }
        return this.partitionedIndexRegistry.isEmpty();
    }

    @Override
    public MapWanContext getWanContext() {
        return this.wanContext;
    }

    @Override
    public int getTotalBackupCount() {
        return this.getBackupCount() + this.getAsyncBackupCount();
    }

    @Override
    public int getBackupCount() {
        return this.mapConfig.getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapConfig.getAsyncBackupCount();
    }

    @Override
    public PartitioningStrategy getPartitioningStrategy() {
        return this.partitioningStrategy;
    }

    @Override
    public MapServiceContext getMapServiceContext() {
        return this.mapServiceContext;
    }

    @Override
    public MapStoreContext getMapStoreContext() {
        return this.mapStoreContext;
    }

    @Override
    public MapConfig getMapConfig() {
        return this.mapConfig;
    }

    @Override
    public void setMapConfig(MapConfig mapConfig) {
        this.mapConfig = mapConfig;
    }

    @Override
    public EventJournalConfig getEventJournalConfig() {
        return this.eventJournalConfig;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSplitBrainProtectionName() {
        return this.splitBrainProtectionName;
    }

    @Override
    public Function<Object, Data> toData() {
        return this.toDataFunction;
    }

    @Override
    public QueryableEntry newQueryEntry(Data key, Object value) {
        return this.queryEntryFactory.newEntry(key, value);
    }

    @Override
    public Evictor getEvictor() {
        return this.evictor;
    }

    @Override
    public void setEvictor(Evictor evictor) {
        this.evictor = evictor;
    }

    @Override
    public Extractors getExtractors() {
        return this.extractors;
    }

    @Override
    public boolean hasInvalidationListener() {
        return this.invalidationListenerCount.get() > 0;
    }

    @Override
    public AtomicInteger getInvalidationListenerCounter() {
        return this.invalidationListenerCount;
    }

    @Override
    public void increaseInvalidationListenerCount() {
        this.invalidationListenerCount.incrementAndGet();
    }

    @Override
    public void decreaseInvalidationListenerCount() {
        this.invalidationListenerCount.decrementAndGet();
    }

    @Override
    public InterceptorRegistry getInterceptorRegistry() {
        return this.interceptorRegistry;
    }

    @Override
    public void onBeforeDestroy() {
        this.destroyed = true;
    }

    @Override
    public final void onDestroy() {
        if (!this.onDestroyCalled.compareAndSet(false, true)) {
            return;
        }
        this.onDestroyInternal();
    }

    protected void onDestroyInternal() {
        if (this.shouldUseGlobalIndex()) {
            this.destroyGlobalIndexes();
        }
        this.mapServiceContext.getLocalMapStatsProvider().destroyLocalMapStatsImpl(this.getName());
    }

    protected void destroyGlobalIndexes() {
        this.getGlobalIndexRegistry().destroyIndexes();
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean shouldCloneOnEntryProcessing(int partitionId) {
        return this.getOrCreateIndexRegistry(partitionId).haveAtLeastOneIndex() && InMemoryFormat.OBJECT.equals((Object)this.mapConfig.getInMemoryFormat());
    }

    @Override
    public ObjectNamespace getObjectNamespace() {
        return this.objectNamespace;
    }

    @Override
    public Map<String, IndexConfig> getIndexDefinitions() {
        return this.shouldUseGlobalIndex() ? this.getGlobalIndexDefinitions() : this.getPartitionedIndexDefinitions();
    }

    private Map<String, IndexConfig> getGlobalIndexDefinitions() {
        HashMap<String, IndexConfig> definitions = new HashMap<String, IndexConfig>();
        InternalIndex[] indexes = this.globalIndexRegistry.getIndexes();
        for (int i = 0; i < indexes.length; ++i) {
            definitions.put(indexes[i].getName(), indexes[i].getConfig());
        }
        return definitions;
    }

    private Map<String, IndexConfig> getPartitionedIndexDefinitions() {
        HashMap<String, IndexConfig> definitions = new HashMap<String, IndexConfig>();
        int partitionCount = this.mapServiceContext.getNodeEngine().getPartitionService().getPartitionCount();
        for (int i = 0; i < partitionCount; ++i) {
            IndexRegistry indexRegistry = this.getOrNullPartitionedIndexRegistry(i);
            if (indexRegistry == null) continue;
            InternalIndex[] indexes = indexRegistry.getIndexes();
            for (int j = 0; j < indexes.length; ++j) {
                definitions.put(indexes[j].getName(), indexes[j].getConfig());
            }
        }
        return definitions;
    }

    @Override
    public boolean isUseCachedDeserializedValuesEnabled(int partitionId) {
        switch (this.getMapConfig().getCacheDeserializedValues()) {
            case NEVER: {
                return false;
            }
            case ALWAYS: {
                return true;
            }
        }
        return this.getOrCreateIndexRegistry(partitionId).haveAtLeastOneIndex();
    }

    public boolean isQueryExpirationCheckEnabled() {
        return this.queryExpirationCheckEnabled;
    }

    public String toString() {
        return "MapContainer{name='" + this.name + "', destroyed=" + this.destroyed + "}";
    }

    private class ObjectToData
    implements Function<Object, Data> {
        private ObjectToData() {
        }

        @Override
        public Data apply(Object input) {
            SerializationService ss = MapContainerImpl.this.mapStoreContext.getSerializationService();
            return ss.toData(input, MapContainerImpl.this.partitioningStrategy);
        }
    }

    private class IndexResultFilterFactory
    implements Supplier<Predicate<QueryableEntry>> {
        private IndexResultFilterFactory() {
        }

        @Override
        public Predicate<QueryableEntry> get() {
            return new Predicate<QueryableEntry>(){
                private final long nowInMillis = Clock.currentTimeMillis();

                @Override
                public boolean test(QueryableEntry queryableEntry) {
                    return MapContainerImpl.this.hasNotExpired(queryableEntry, this.nowInMillis);
                }
            };
        }
    }
}

