/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.device.HybridLogFileHandlePool;
import com.hazelcast.internal.tstore.device.HybridLogFileHandlePoolImpl;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.service.TieredStoreService;
import com.hazelcast.internal.tstore.service.TieredStoreUser;
import com.hazelcast.internal.tstore.service.impl.TieredStoreServiceImpl;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.jet.impl.util.ConcurrentMemoizingSupplier;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainerImpl;
import com.hazelcast.map.impl.recordstore.EnterpriseTieredRecordStore;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.wan.impl.merkletree.ArrayMerkleTree;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class EnterprisePartitionContainerImpl
extends PartitionContainerImpl
implements EnterprisePartitionContainer {
    private final ConcurrentMap<MapContainer, MerkleTree> merkleTrees;
    private final ContextMutexFactory merkleTreesMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<MapContainer, MerkleTree> merkleTreeConstructor = mapContainer -> {
        MerkleTreeConfig merkleTreeConfig = this.getMerkleTreeConfig(mapContainer.getName());
        int depth = merkleTreeConfig.getDepth();
        return new ArrayMerkleTree(depth);
    };
    private final ConcurrentMap<MapContainer, HybridLogFileHandlePool> tsHandlePools;
    private final ContextMutexFactory tsHandlePoolsMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<MapContainer, HybridLogFileHandlePool> tsHandlePoolConstructor = mapContainer -> new HybridLogFileHandlePoolImpl(this.getProperties());
    private final ConcurrentMap<MapContainer, Epoch> localEpochs;
    private final ConstructorFunction<MapContainer, Epoch> localEpochConstructor;
    private final ContextMutexFactory localEpochsMutexFactory = new ContextMutexFactory();

    public EnterprisePartitionContainerImpl(MapService mapService, TieredStoreService tieredStoreService, int partitionId) {
        super(mapService, partitionId);
        int expectedMerkleTrees = 0;
        int expectedTSMaps = 0;
        Collection<MapConfig> mapConfigs = mapService.mapServiceContext.getNodeEngine().getConfig().getMapConfigs().values();
        for (MapConfig config : mapConfigs) {
            if (mapService.mapServiceContext.shouldEnableMerkleTree(config, false)) {
                ++expectedMerkleTrees;
            }
            if (!config.getTieredStoreConfig().isEnabled()) continue;
            ++expectedTSMaps;
        }
        this.merkleTrees = MapUtil.createConcurrentHashMap(Math.max(expectedMerkleTrees, 1));
        this.tsHandlePools = MapUtil.createConcurrentHashMap(Math.max(expectedTSMaps, 1));
        this.localEpochs = MapUtil.createConcurrentHashMap(Math.max(expectedTSMaps, 1));
        this.localEpochConstructor = mapContainer -> ((TieredStoreServiceImpl)tieredStoreService).createEpoch();
    }

    private MerkleTreeConfig getMerkleTreeConfig(String mapName) {
        MapServiceContext mapServiceContext = this.getMapService().getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        return nodeEngine.getConfig().findMapConfig(mapName).getMerkleTreeConfig();
    }

    @Override
    public void clearPartitionStateOnMapDestroy(MapContainer mapContainer) {
        Epoch localEpoch;
        this.merkleTrees.remove(mapContainer);
        HybridLogFileHandlePool handlePool = (HybridLogFileHandlePool)this.tsHandlePools.remove(mapContainer);
        if (handlePool != null) {
            handlePool.close();
        }
        if ((localEpoch = (Epoch)this.localEpochs.remove(mapContainer)) != null) {
            localEpoch.close();
        }
    }

    @Override
    public void onNodeShutdownCloseHybridLogHandlePool() {
        this.tsHandlePools.values().forEach(HybridLogFileHandlePool::close);
        this.localEpochs.values().forEach(Epoch::close);
    }

    public ConcurrentMap<MapContainer, Epoch> getLocalEpochs() {
        return this.localEpochs;
    }

    @Override
    public MerkleTree getOrCreateMerkleTree(MapContainer mapContainer) {
        MapConfig mapConfig = mapContainer.getMapConfig();
        if (!this.getMapService().mapServiceContext.shouldEnableMerkleTree(mapConfig, true)) {
            return null;
        }
        return ConcurrencyUtil.getOrPutSynchronized(this.merkleTrees, mapContainer, this.merkleTreesMutexFactory, this.merkleTreeConstructor);
    }

    @Override
    public Epoch getOrCreateLocalEpoch(MapContainer mapContainer) {
        return ConcurrencyUtil.getOrPutSynchronized(this.localEpochs, mapContainer, this.localEpochsMutexFactory, this.localEpochConstructor);
    }

    @Override
    protected void cleanUpMap(String mapName, MapContainer mapContainer) {
        this.merkleTrees.remove(mapContainer);
        this.localEpochs.remove(mapContainer);
    }

    private HybridLog createHybridLog(MapContainer mapContainer) {
        MapServiceContext mapServiceContext = this.getMapService().getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)nodeEngine.getNode().getNodeExtension();
        TieredStoreService tieredStoreService = nodeExtension.getTieredStoreService();
        return tieredStoreService.createHybridLog(TieredStoreUser.IMAP, mapContainer, this.getPartitionId());
    }

    private HazelcastProperties getProperties() {
        return this.getMapService().getMapServiceContext().getNodeEngine().getProperties();
    }

    public ConcurrentMap<MapContainer, HybridLogFileHandlePool> getTsHandlePools() {
        return this.tsHandlePools;
    }

    @Override
    public HybridLogFileHandlePool getOrCreateHandlePool(MapContainer mapContainer) {
        MapConfig mapConfig = mapContainer.getMapConfig();
        if (!mapConfig.getTieredStoreConfig().isEnabled()) {
            return null;
        }
        return ConcurrencyUtil.getOrPutSynchronized(this.tsHandlePools, mapContainer, this.tsHandlePoolsMutexFactory, this.tsHandlePoolConstructor);
    }

    @Override
    public MerkleTree getMerkleTreeOrNull(MapContainer mapContainer) {
        return (MerkleTree)this.merkleTrees.get(mapContainer);
    }

    @Override
    public HybridLog getHybridLogOrNull(MapContainer mapContainer) {
        MapConfig mapConfig = mapContainer.getMapConfig();
        if (!mapConfig.getTieredStoreConfig().isEnabled()) {
            return null;
        }
        EnterpriseTieredRecordStore existingRecordStore = (EnterpriseTieredRecordStore)this.getExistingRecordStore(mapContainer.getName());
        if (existingRecordStore == null) {
            return null;
        }
        if (existingRecordStore.getMapContainer() != mapContainer) {
            return null;
        }
        Supplier<HybridLog> hybridLogSupplier = existingRecordStore.getHybridLogSupplier();
        return hybridLogSupplier.get();
    }

    @Override
    public Supplier<HybridLog> createHybridLogSupplier(MapContainer mapContainer) {
        return new ConcurrentMemoizingSupplier<HybridLog>(() -> this.createHybridLog(mapContainer));
    }
}

