/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.service.TieredStoreService;
import com.hazelcast.internal.tstore.service.impl.TieredStoreServiceImpl;
import com.hazelcast.internal.tstore.service.impl.TieredStoreServiceImplMetrics;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EnterpriseMapContainer;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.MapContainerImpl;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.eviction.HDEvictionChecker;
import com.hazelcast.map.impl.eviction.HDEvictorImpl;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.query.impl.IndexRegistry;
import com.hazelcast.spi.eviction.EvictionPolicyComparator;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.wan.impl.DelegatingWanScheme;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class EnterpriseMapContainerImpl
extends MapContainerImpl
implements EnterpriseMapContainer {
    private final AtomicBoolean implicitMerkleTreeEnableLogged = new AtomicBoolean();
    private final Set<String> tieredStoreIMapRootDirs = Collections.newSetFromMap(new ConcurrentHashMap());
    private HiDensityStorageInfo hdStorageInfo;

    EnterpriseMapContainerImpl(String name, Config config, MapServiceContext mapServiceContext) {
        super(name, config, mapServiceContext);
        this.logMerkleTreeInfoIfEnabled();
    }

    @Override
    public void init() {
        this.hdStorageInfo = new HiDensityStorageInfo(this.name);
        super.init();
        if (this.mapConfig.getTieredStoreConfig().isEnabled()) {
            this.registerThisMapToTStoreMetrics();
        }
    }

    private void registerThisMapToTStoreMetrics() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.mapServiceContext.getNodeEngine();
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)nodeEngine.getNode().getNodeExtension();
        TieredStoreService tieredStoreService = nodeExtension.getTieredStoreService();
        TieredStoreServiceImplMetrics metrics = ((TieredStoreServiceImpl)tieredStoreService).getMetrics();
        metrics.registerMap(this, this.mapConfig.getTieredStoreConfig());
    }

    @Override
    protected Evictor newEvictor(EvictionPolicyComparator evictionPolicyComparator, int evictionBatchSize, IPartitionService partitionService) {
        if (InMemoryFormat.NATIVE == this.mapConfig.getInMemoryFormat()) {
            return new HDEvictorImpl(evictionPolicyComparator, new HDEvictionChecker(EnterpriseMapContainerImpl.getMemoryInfoAccessor(), this.mapServiceContext), evictionBatchSize, partitionService, this.hdStorageInfo, this.mapServiceContext.getNodeEngine().getLogger(HDEvictorImpl.class));
        }
        return super.newEvictor(evictionPolicyComparator, evictionBatchSize, partitionService);
    }

    @Override
    public void logMerkleTreeImplicitlyEnabled(ILogger logger) {
        if (this.implicitMerkleTreeEnableLogged.compareAndSet(false, true)) {
            logger.info("Enabling MerkleTreeConfig for map \"" + this.name + "\", as it enhances member recovery performance. Consider enabling MerkleTreeConfig explicitly in your configuration.");
        }
    }

    private void logMerkleTreeInfoIfEnabled() {
        MerkleTreeConfig mapMerkleTreeConfig = this.mapConfig.getMerkleTreeConfig();
        if (this.mapServiceContext.shouldEnableMerkleTree(this.mapConfig, false)) {
            ILogger logger = this.mapServiceContext.getNodeEngine().getLogger(EnterpriseMapContainer.class);
            logger.fine("Using Merkle trees with depth " + mapMerkleTreeConfig.getDepth() + " for map " + this.name);
        }
    }

    @Override
    public HiDensityStorageInfo getHDStorageInfo() {
        return this.hdStorageInfo;
    }

    @Override
    protected void onDestroyInternal() {
        DelegatingWanScheme wanReplicationDelegate = this.getWanContext().getWanReplicationDelegate();
        if (wanReplicationDelegate != null) {
            wanReplicationDelegate.destroyMapData(this.name);
        }
        super.onDestroyInternal();
        PartitionContainer[] partitionContainers = this.mapServiceContext.getPartitionContainers();
        for (PartitionContainer partitionContainer : partitionContainers) {
            ((EnterprisePartitionContainer)partitionContainer).clearPartitionStateOnMapDestroy(this);
        }
        for (String mapDir : this.tieredStoreIMapRootDirs) {
            try {
                IOUtil.delete(Path.of(mapDir, new String[0]));
            }
            catch (Exception e) {
                this.mapServiceContext.getNodeEngine().getLogger(this.getClass()).warning(e);
            }
        }
        this.tieredStoreIMapRootDirs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyGlobalIndexes() {
        boolean hasTieredStore = this.getMapConfig().getTieredStoreConfig().isEnabled();
        if (hasTieredStore) {
            assert (this.mapServiceContext.isForciblyEnabledGlobalIndex());
            TieredStoreService tieredStoreService = (TieredStoreService)this.mapServiceContext.getNodeEngine().getService("hz:ee:tieredStoreServiceImpl");
            Epoch epoch = tieredStoreService.globalEpoch();
            int threadIndex = epoch.register();
            try {
                super.destroyGlobalIndexes();
            }
            finally {
                epoch.unregister(threadIndex);
            }
        } else {
            super.destroyGlobalIndexes();
        }
    }

    @Override
    public void getCustomStepAwareStorage(int partitionId, Consumer<Step> stepCollector) {
        if (this.globalIndexRegistry != null) {
            return;
        }
        IndexRegistry partitionedIndexRegistry = this.getOrNullPartitionedIndexRegistry(partitionId);
        if (partitionedIndexRegistry == null) {
            return;
        }
        partitionedIndexRegistry.getCustomStepAwareStorage(stepCollector);
    }

    @Override
    public void addToTieredStoreIMapDirPaths(String rootPath) {
        this.tieredStoreIMapRootDirs.add(rootPath);
    }
}

