/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.util;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.domain.LicenseVersion;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.license.extractor.LicenseExtractorV2;
import com.hazelcast.license.extractor.LicenseExtractorV3;
import com.hazelcast.license.extractor.LicenseExtractorV4;
import com.hazelcast.license.extractor.LicenseExtractorV5;
import com.hazelcast.license.extractor.LicenseExtractorV6;
import com.hazelcast.license.nlc.BuiltInLicenseProvider;
import com.hazelcast.license.nlc.BuiltInLicenseProviderFactory;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class LicenseHelper {
    private LicenseHelper() {
    }

    public static int extractHazelcastMajorMinorVersionAsInt(String version) {
        String[] parts = version.split("\\.");
        if (parts.length > 2) {
            int versionPart1 = Integer.parseInt(parts[0]);
            int versionPart2 = Integer.parseInt(parts[1]);
            return LicenseHelper.generateFinalStateOfIntVersion(versionPart1, versionPart2);
        }
        String[] betaParts = parts[1].split("-");
        int versionPart1 = Integer.parseInt(parts[0]);
        int versionPart2 = Integer.parseInt(betaParts[0]);
        return LicenseHelper.generateFinalStateOfIntVersion(versionPart1, versionPart2);
    }

    private static int generateFinalStateOfIntVersion(int versionPart1, int versionPart2) {
        boolean isDoubleDigit;
        boolean bl = isDoubleDigit = versionPart2 > 9 && versionPart2 < 100;
        if (isDoubleDigit) {
            return versionPart1 * 100 + versionPart2;
        }
        return versionPart1 * 10 + versionPart2;
    }

    public static boolean isExpired(License license) {
        return ZonedDateTime.now(ZoneOffset.UTC).isAfter(LicenseHelper.getExpiryDateWithGracePeriod(license));
    }

    public static ZonedDateTime getExpiryDateWithGracePeriod(License license) {
        return license.getExpiryDate().plusMonths(license.getGracePeriod());
    }

    public static License getLicense(String licenseKey, String versionString) {
        License license;
        if (licenseKey == null) {
            throw new InvalidLicenseException("License Key not configured!");
        }
        try {
            license = LicenseExtractorV6.extractLicense(licenseKey);
        }
        catch (InvalidLicenseException e1) {
            try {
                license = LicenseExtractorV5.extractLicense(licenseKey);
            }
            catch (InvalidLicenseException e2) {
                try {
                    license = LicenseExtractorV4.extractLicense(licenseKey);
                }
                catch (InvalidLicenseException e3) {
                    try {
                        license = LicenseExtractorV3.extractLicense(licenseKey);
                    }
                    catch (InvalidLicenseException e) {
                        license = LicenseExtractorV2.extractLicense(licenseKey);
                    }
                }
            }
        }
        int version = LicenseHelper.extractHazelcastMajorMinorVersionAsInt(versionString);
        if (license.getHazelcastVersion() != 99 && license.getHazelcastVersion() != version) {
            throw new InvalidLicenseException("This license cannot work with your hazelcast version!");
        }
        if (license.isTrial() && LicenseHelper.isExpired(license)) {
            throw new InvalidLicenseException("Trial license has expired! Please contact your sales representative or contact support@hazelcast.com");
        }
        if (LicenseHelper.isExpired(license)) {
            throw new InvalidLicenseException("Enterprise License has expired! Please contact your sales representative or contact support@hazelcast.com");
        }
        return license;
    }

    public static License getBuiltInLicense() {
        BuiltInLicenseProviderFactory providerFactory = new BuiltInLicenseProviderFactory();
        BuiltInLicenseProvider licenseProvider = providerFactory.create();
        if (licenseProvider != null) {
            return licenseProvider.provide();
        }
        return null;
    }

    public static boolean isBuiltInLicense(License license) {
        if (license != null) {
            return license.getVersion() == LicenseVersion.V6 && license.isOem() && license.getKey() == null && license.getCreationDate() == null && Instant.ofEpochMilli(Long.MAX_VALUE).atZone(ZoneOffset.UTC).equals(license.getExpiryDate());
        }
        return false;
    }

    public static void checkLicensePerFeature(License license, Feature feature) {
        if (!license.getFeatures().contains(feature)) {
            throw new InvalidLicenseException("The Feature " + feature.getText() + " is not enabled for your license key. Please contact your sales representative or contact support@hazelcast.com");
        }
    }
}

