/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.extractor;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.domain.LicenseVersion;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.license.extractor.ExtractorUtils;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.EnumSet;

public class LicenseExtractorV5 {
    public static final int RESERVED = 43;
    public static final char[] CHARS = "az{Vh}r4:t$e]>_3%?@o|^p=.x*~<R;&c[s!+L-F7\u00a3IvY6ulkJB9jfQSdTWqGbX58ECw21nNM0PHKZmyUiOAgD".toCharArray();
    public static final int LENGTH = CHARS.length;

    private LicenseExtractorV5() {
    }

    public static License extractLicense(String licenseKey) throws InvalidLicenseException {
        char r;
        if (licenseKey == null || licenseKey.isEmpty()) {
            throw new InvalidLicenseException("License key can not be empty.");
        }
        String[] keyTokens = licenseKey.split("#");
        char[] originalKey = keyTokens[keyTokens.length - 1].toCharArray();
        if (LENGTH != originalKey.length) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        char[] key = new char[LENGTH];
        System.arraycopy(originalKey, 0, key, 0, LENGTH);
        char fp = key[42];
        key[42] = '\u0000';
        char lp = key[43];
        key[43] = '\u0000';
        char[] hash = ExtractorUtils.hash(key);
        if (hash[0] != fp || hash[hash.length - 1] != lp) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        int ix = 0;
        boolean isTrial = key[LicenseExtractorV5.ix0(r = key[ix++])] == '1';
        char t = key[ix++];
        char licenseType = key[LicenseExtractorV5.ix0(t)];
        char d0 = key[ix++];
        char d1 = key[ix++];
        int day = LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(d0)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(d1)]);
        char m0 = key[ix++];
        char m1 = key[ix++];
        int month = LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(m0)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(m1)]);
        char y0 = key[ix++];
        char y1 = key[ix++];
        int year = 2000 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(y0)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(y1)]);
        ZonedDateTime expiryDate = LocalDate.of(year, month, day).atTime(LocalTime.MAX).atZone(ZoneOffset.UTC);
        char n0 = key[ix++];
        char n1 = key[ix++];
        char n2 = key[ix++];
        char n3 = key[ix++];
        int nodes = LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(n0)]) * 1000 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(n1)]) * 100 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(n2)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(n3)]);
        char l0 = key[ix++];
        char l1 = key[ix++];
        char l2 = key[ix++];
        char l3 = key[ix++];
        int hazelcastVersion = LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(l0)]) == 1 ? LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(l1)]) * 100 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(l2)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(l3)]) : LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(l1)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(l2)]);
        char oem = key[ix++];
        boolean isOem = key[LicenseExtractorV5.ix0(oem)] == '1';
        char g1 = key[ix++];
        char g2 = key[ix++];
        int gracePeriod = LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(g1)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(g2)]);
        char cm1 = key[ix++];
        char cm2 = key[ix++];
        int monthDiffCreationAndExpiryDates = LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(cm1)]) * 10 + LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(cm2)]);
        ZonedDateTime creationDate = expiryDate.minusMonths(monthDiffCreationAndExpiryDates);
        char s1 = key[ix++];
        char s2 = key[ix++];
        char s3 = key[ix++];
        char s4 = key[ix++];
        char s5 = key[ix++];
        char f0 = key[ix++];
        char f1 = key[ix++];
        char f2 = key[ix++];
        char f3 = key[ix++];
        char f4 = key[ix++];
        char f5 = key[ix++];
        char f6 = key[ix++];
        char f7 = key[ix++];
        char f8 = key[ix++];
        char f9 = key[ix++];
        char f10 = key[ix++];
        char f11 = key[ix++];
        char f12 = key[ix++];
        char f13 = key[ix++];
        char f14 = key[ix++];
        char f15 = key[ix++];
        EnumSet<Feature> featureSet = EnumSet.noneOf(Feature.class);
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f0)]) == 1) {
            featureSet.add(Feature.MAN_CENTER);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f1)]) == 1) {
            featureSet.add(Feature.CLUSTERED_JMX);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f2)]) == 1) {
            featureSet.add(Feature.CLUSTERED_REST);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f3)]) == 1) {
            featureSet.add(Feature.SECURITY);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f4)]) == 1) {
            featureSet.add(Feature.WAN);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f5)]) == 1) {
            featureSet.add(Feature.HD_MEMORY);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f6)]) == 1) {
            featureSet.add(Feature.PERSISTENCE);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f7)]) == 1) {
            featureSet.add(Feature.ROLLING_UPGRADE);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f8)]) == 1) {
            featureSet.add(Feature.STREAMING_MAN_CENTER);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f9)]) == 1) {
            featureSet.add(Feature.STREAMING_LOSSLESS_CLUSTER_RESTART);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f10)]) == 1) {
            featureSet.add(Feature.STREAMING_JOB_UPGRADES);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f11)]) == 1) {
            featureSet.add(Feature.STREAMING_ENTERPRISE);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f12)]) == 1) {
            featureSet.add(Feature.CLIENT_FILTERING);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f13)]) == 1) {
            featureSet.add(Feature.CP_PERSISTENCE);
        }
        if (LicenseExtractorV5.ix1(key[LicenseExtractorV5.ix0(f14)]) == 1) {
            featureSet.add(Feature.DYNAMIC_CONFIGURATION);
        }
        return License.builder().version(LicenseVersion.V5).key(licenseKey).creationDate(creationDate).expiryDate(expiryDate).allowedNumberOfNodes(nodes).allowedNativeMemorySize(100).hazelcastVersion(hazelcastVersion).oem(isOem).gracePeriod(gracePeriod).trial(isTrial).features(featureSet).build();
    }

    private static int ix0(char c) {
        return LicenseExtractorV5.ix(CHARS, c);
    }

    private static int ix1(char c) {
        return LicenseExtractorV5.ix(ExtractorUtils.DIGITS, c);
    }

    private static int ix(char[] cc, char c) {
        for (int i = 0; i < cc.length; ++i) {
            if (c != cc[i]) continue;
            return i;
        }
        return -1;
    }
}

