/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.extractor;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.domain.LicenseVersion;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.license.extractor.ExtractorUtils;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.EnumSet;

public class LicenseExtractorV4 {
    public static final int RESERVED = 30;

    private LicenseExtractorV4() {
    }

    public static License extractLicense(String licenseKey) throws InvalidLicenseException {
        char r;
        if (licenseKey == null || licenseKey.isEmpty()) {
            throw new InvalidLicenseException("License key can not be empty.");
        }
        String[] keyTokens = licenseKey.split("#");
        char[] originalKey = keyTokens[keyTokens.length - 1].toCharArray();
        if (ExtractorUtils.LENGTH != originalKey.length) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        char[] key = new char[ExtractorUtils.LENGTH];
        System.arraycopy(originalKey, 0, key, 0, ExtractorUtils.LENGTH);
        char fp = key[29];
        key[29] = '\u0000';
        char lp = key[30];
        key[30] = '\u0000';
        char[] hash = ExtractorUtils.hash(key);
        if (hash[0] != fp || hash[hash.length - 1] != lp) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        int ix = 0;
        boolean isTrial = key[LicenseExtractorV4.ix0(r = key[ix++])] == '1';
        char t = key[ix++];
        char licenseType = key[LicenseExtractorV4.ix0(t)];
        char d0 = key[ix++];
        char d1 = key[ix++];
        int day = LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(d0)]) * 10 + LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(d1)]);
        char m0 = key[ix++];
        char m1 = key[ix++];
        int month = LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(m0)]) * 10 + LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(m1)]);
        char y0 = key[ix++];
        char y1 = key[ix++];
        int year = 2000 + LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(y0)]) * 10 + LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(y1)]);
        char n0 = key[ix++];
        char n1 = key[ix++];
        char n2 = key[ix++];
        char n3 = key[ix++];
        int nodes = LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(n0)]) * 1000 + LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(n1)]) * 100 + LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(n2)]) * 10 + LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(n3)]);
        char l0 = key[ix++];
        char l1 = key[ix++];
        int hazelcastVersion = LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(l0)]) * 10 + LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(l1)]);
        char f0 = key[ix++];
        char f1 = key[ix++];
        char f2 = key[ix++];
        char f3 = key[ix++];
        char f4 = key[ix++];
        char f5 = key[ix++];
        char f6 = key[ix++];
        char f7 = key[ix++];
        char f8 = key[ix++];
        char f9 = key[ix++];
        char f10 = key[ix++];
        char f11 = key[ix++];
        char f12 = key[ix++];
        char f13 = key[ix++];
        char f14 = key[ix++];
        EnumSet<Feature> featureSet = EnumSet.noneOf(Feature.class);
        if (LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(f0)]) == 1) {
            featureSet.add(Feature.MAN_CENTER);
        }
        if (LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(f1)]) == 1) {
            featureSet.add(Feature.WEB_SESSION);
        }
        if (LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(f2)]) == 1) {
            featureSet.add(Feature.CLUSTERED_JMX);
        }
        if (LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(f3)]) == 1) {
            featureSet.add(Feature.CLUSTERED_REST);
        }
        if (LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(f4)]) == 1) {
            featureSet.add(Feature.SECURITY);
        }
        if (LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(f5)]) == 1) {
            featureSet.add(Feature.WAN);
        }
        if (LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(f6)]) == 1) {
            featureSet.add(Feature.HD_MEMORY);
        }
        if (LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(f7)]) == 1) {
            featureSet.add(Feature.PERSISTENCE);
        }
        if (LicenseExtractorV4.ix1(key[LicenseExtractorV4.ix0(f8)]) == 1) {
            // empty if block
        }
        featureSet.add(Feature.ROLLING_UPGRADE);
        return License.builder().version(LicenseVersion.V4).key(licenseKey).expiryDate(LocalDate.of(year, month, day).atTime(LocalTime.MAX).atZone(ZoneOffset.UTC)).allowedNumberOfNodes(nodes).allowedNativeMemorySize(100).hazelcastVersion(hazelcastVersion).trial(isTrial).features(featureSet).build();
    }

    private static int ix0(char c) {
        return LicenseExtractorV4.ix(ExtractorUtils.CHARS, c);
    }

    private static int ix1(char c) {
        return LicenseExtractorV4.ix(ExtractorUtils.DIGITS, c);
    }

    private static int ix(char[] cc, char c) {
        for (int i = 0; i < cc.length; ++i) {
            if (c != cc[i]) continue;
            return i;
        }
        return -1;
    }
}

