/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.extractor;

import com.hazelcast.license.domain.License;
import com.hazelcast.license.domain.LicenseVersion;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.license.extractor.ExtractorUtils;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;

public class LicenseExtractorV3 {
    public static final int RESERVED = 23;

    private LicenseExtractorV3() {
    }

    public static License extractLicense(String licenseKey) throws InvalidLicenseException {
        char r;
        if (licenseKey == null || licenseKey.isEmpty()) {
            throw new InvalidLicenseException("License key can not be empty.");
        }
        String[] keyTokens = licenseKey.split("#");
        char[] originalKey = keyTokens[keyTokens.length - 1].toCharArray();
        if (ExtractorUtils.LENGTH != originalKey.length) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        char[] key = new char[ExtractorUtils.LENGTH];
        System.arraycopy(originalKey, 0, key, 0, ExtractorUtils.LENGTH);
        char fp = key[22];
        key[22] = '\u0000';
        char lp = key[23];
        key[23] = '\u0000';
        char[] hash = ExtractorUtils.hash(key);
        if (hash[0] != fp || hash[hash.length - 1] != lp) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        int ix = 0;
        boolean isTrial = key[LicenseExtractorV3.ix0(r = key[ix++])] == '1';
        char t = key[ix++];
        char licenseType = key[LicenseExtractorV3.ix0(t)];
        char d0 = key[ix++];
        char d1 = key[ix++];
        int day = LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(d0)]) * 10 + LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(d1)]);
        char m0 = key[ix++];
        char m1 = key[ix++];
        int month = LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(m0)]) * 10 + LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(m1)]);
        char y0 = key[ix++];
        char y1 = key[ix++];
        int year = 2000 + LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(y0)]) * 10 + LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(y1)]);
        char n0 = key[ix++];
        char n1 = key[ix++];
        char n2 = key[ix++];
        char n3 = key[ix++];
        int nodes = LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(n0)]) * 1000 + LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(n1)]) * 100 + LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(n2)]) * 10 + LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(n3)]);
        char h0 = key[ix++];
        char h1 = key[ix++];
        char h2 = key[ix++];
        char h3 = key[ix++];
        char h4 = key[ix++];
        char h5 = key[ix++];
        char h6 = key[ix++];
        char h7 = key[ix++];
        int hdAmount = LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(h0)]) * 1000000 + LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(h1)]) * 1000000 + LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(h2)]) * 100000 + LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(h3)]) * 10000 + LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(h4)]) * 1000 + LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(h5)]) * 100 + LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(h6)]) * 10 + LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(h7)]);
        char l0 = key[ix++];
        char l1 = key[ix++];
        int hazelcastVersion = LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(l0)]) * 10 + LicenseExtractorV3.ix1(key[LicenseExtractorV3.ix0(l1)]);
        return License.builder().key(licenseKey).expiryDate(LocalDate.of(year, month, day).atTime(LocalTime.MAX).atZone(ZoneOffset.UTC)).allowedNumberOfNodes(nodes).allowedNativeMemorySize(hdAmount).hazelcastVersion(hazelcastVersion).oem(false).trial(isTrial).version(LicenseVersion.V3).features(ExtractorUtils.getFeaturesForLegacyLicenses(licenseType, LicenseVersion.V3)).build();
    }

    private static int ix0(char c) {
        return LicenseExtractorV3.ix(ExtractorUtils.CHARS, c);
    }

    private static int ix1(char c) {
        return LicenseExtractorV3.ix(ExtractorUtils.DIGITS, c);
    }

    private static int ix(char[] cc, char c) {
        for (int i = 0; i < cc.length; ++i) {
            if (c != cc[i]) continue;
            return i;
        }
        return -1;
    }
}

