/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.extractor;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.LicenseVersion;
import java.util.EnumSet;
import java.util.Set;

public final class ExtractorUtils {
    public static final char[] CHARS = "dsx4MZQvo2tqegGLpWhCDXnPYzciBR3murF5SA7KIObaw1Vf6JNyjEl0UTkH".toCharArray();
    public static final int LENGTH = CHARS.length;
    public static final char[] DIGITS = "0123456789".toCharArray();
    public static final int yearBase = 2000;

    private ExtractorUtils() {
    }

    public static char[] hash(char[] a) {
        if (a == null) {
            return new char[]{'0'};
        }
        int result = 1;
        for (char element : a) {
            result = 31 * result + element;
        }
        return Integer.toString(Math.abs(result)).toCharArray();
    }

    static Set<Feature> getFeaturesForLegacyLicenses(char type, LicenseVersion version) {
        EnumSet<Feature> featureList = EnumSet.noneOf(Feature.class);
        if (type == '0') {
            featureList.add(Feature.MAN_CENTER);
        }
        if (type == '2') {
            featureList.add(Feature.SECURITY);
        }
        if (type == '1') {
            ExtractorUtils.addEnterpriseFeatures(featureList);
            if (version == LicenseVersion.V2) {
                featureList.add(Feature.HD_MEMORY);
            }
        }
        if (version == LicenseVersion.V3 && type == '3') {
            ExtractorUtils.addEnterpriseFeatures(featureList);
            featureList.add(Feature.HD_MEMORY);
            featureList.add(Feature.PERSISTENCE);
        }
        return featureList;
    }

    private static void addEnterpriseFeatures(Set<Feature> featureList) {
        featureList.add(Feature.MAN_CENTER);
        featureList.add(Feature.WEB_SESSION);
        featureList.add(Feature.CLUSTERED_REST);
        featureList.add(Feature.CLUSTERED_JMX);
        featureList.add(Feature.SECURITY);
        featureList.add(Feature.WAN);
        featureList.add(Feature.ROLLING_UPGRADE);
    }
}

