/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.domain;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.LicenseVersion;
import com.hazelcast.license.util.HashUtils;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

public final class License
implements Serializable {
    public static final int UNLIMITED_HAZELCAST_VERSION = 99;
    public static final int UNLIMITED_NUMBER_OF_NODES = 9999;
    public static final int UNLIMITED_MARKER_HD_CACHE = 99999999;
    private final int allowedNumberOfNodes;
    private final LicenseVersion version;
    private final boolean trial;
    private final String key;
    private final ZonedDateTime creationDate;
    private final ZonedDateTime expiryDate;
    private final int allowedNativeMemorySize;
    private final int allowedTieredStoreSize;
    private final int allowedTpcCores;
    private final int hazelcastVersion;
    private final boolean oem;
    private final int gracePeriod;
    private final Set<Feature> features;

    public String computeKeyHash() {
        return HashUtils.computeKeyHash(this.key);
    }

    private String formatHazelcastVersion() {
        if (this.hazelcastVersion < 310) {
            int majorPart = this.hazelcastVersion / 10;
            int minorPart = this.hazelcastVersion % 10;
            return majorPart + "." + minorPart;
        }
        int majorPart = this.hazelcastVersion / 100;
        int minorPart1 = this.hazelcastVersion % 100;
        return majorPart + "." + minorPart1;
    }

    public String toString() {
        return "License{allowedNumberOfNodes=" + this.allowedNumberOfNodes + ", expiryDate=" + this.expiryDate + ", features=" + this.features.stream().map(Feature::getText).collect(Collectors.joining(", ", "[ ", " ]")) + ", keyHash=" + this.computeKeyHash() + (String)(this.hazelcastVersion == 99 ? ", No Version Restriction" : ", restrictedToVersion=" + this.formatHazelcastVersion()) + "}";
    }

    private static Set<Feature> $default$features() {
        return EnumSet.noneOf(Feature.class);
    }

    License(int allowedNumberOfNodes, LicenseVersion version, boolean trial, String key, ZonedDateTime creationDate, ZonedDateTime expiryDate, int allowedNativeMemorySize, int allowedTieredStoreSize, int allowedTpcCores, int hazelcastVersion, boolean oem, int gracePeriod, Set<Feature> features) {
        this.allowedNumberOfNodes = allowedNumberOfNodes;
        this.version = version;
        this.trial = trial;
        this.key = key;
        this.creationDate = creationDate;
        this.expiryDate = expiryDate;
        this.allowedNativeMemorySize = allowedNativeMemorySize;
        this.allowedTieredStoreSize = allowedTieredStoreSize;
        this.allowedTpcCores = allowedTpcCores;
        this.hazelcastVersion = hazelcastVersion;
        this.oem = oem;
        this.gracePeriod = gracePeriod;
        this.features = features;
    }

    public static LicenseBuilder builder() {
        return new LicenseBuilder();
    }

    public LicenseBuilder toBuilder() {
        return new LicenseBuilder().allowedNumberOfNodes(this.allowedNumberOfNodes).version(this.version).trial(this.trial).key(this.key).creationDate(this.creationDate).expiryDate(this.expiryDate).allowedNativeMemorySize(this.allowedNativeMemorySize).allowedTieredStoreSize(this.allowedTieredStoreSize).allowedTpcCores(this.allowedTpcCores).hazelcastVersion(this.hazelcastVersion).oem(this.oem).gracePeriod(this.gracePeriod).features(this.features);
    }

    public int getAllowedNumberOfNodes() {
        return this.allowedNumberOfNodes;
    }

    public LicenseVersion getVersion() {
        return this.version;
    }

    public boolean isTrial() {
        return this.trial;
    }

    public String getKey() {
        return this.key;
    }

    public ZonedDateTime getCreationDate() {
        return this.creationDate;
    }

    public ZonedDateTime getExpiryDate() {
        return this.expiryDate;
    }

    public int getAllowedNativeMemorySize() {
        return this.allowedNativeMemorySize;
    }

    public int getAllowedTieredStoreSize() {
        return this.allowedTieredStoreSize;
    }

    public int getAllowedTpcCores() {
        return this.allowedTpcCores;
    }

    public int getHazelcastVersion() {
        return this.hazelcastVersion;
    }

    public boolean isOem() {
        return this.oem;
    }

    public int getGracePeriod() {
        return this.gracePeriod;
    }

    public Set<Feature> getFeatures() {
        return this.features;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof License)) {
            return false;
        }
        License other = (License)o;
        if (this.getAllowedNumberOfNodes() != other.getAllowedNumberOfNodes()) {
            return false;
        }
        if (this.isTrial() != other.isTrial()) {
            return false;
        }
        if (this.getAllowedNativeMemorySize() != other.getAllowedNativeMemorySize()) {
            return false;
        }
        if (this.getAllowedTieredStoreSize() != other.getAllowedTieredStoreSize()) {
            return false;
        }
        if (this.getAllowedTpcCores() != other.getAllowedTpcCores()) {
            return false;
        }
        if (this.getHazelcastVersion() != other.getHazelcastVersion()) {
            return false;
        }
        if (this.isOem() != other.isOem()) {
            return false;
        }
        if (this.getGracePeriod() != other.getGracePeriod()) {
            return false;
        }
        LicenseVersion this$version = this.getVersion();
        LicenseVersion other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        ZonedDateTime this$creationDate = this.getCreationDate();
        ZonedDateTime other$creationDate = other.getCreationDate();
        if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
            return false;
        }
        ZonedDateTime this$expiryDate = this.getExpiryDate();
        ZonedDateTime other$expiryDate = other.getExpiryDate();
        if (this$expiryDate == null ? other$expiryDate != null : !((Object)this$expiryDate).equals(other$expiryDate)) {
            return false;
        }
        Set<Feature> this$features = this.getFeatures();
        Set<Feature> other$features = other.getFeatures();
        return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAllowedNumberOfNodes();
        result = result * 59 + (this.isTrial() ? 79 : 97);
        result = result * 59 + this.getAllowedNativeMemorySize();
        result = result * 59 + this.getAllowedTieredStoreSize();
        result = result * 59 + this.getAllowedTpcCores();
        result = result * 59 + this.getHazelcastVersion();
        result = result * 59 + (this.isOem() ? 79 : 97);
        result = result * 59 + this.getGracePeriod();
        LicenseVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        ZonedDateTime $creationDate = this.getCreationDate();
        result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
        ZonedDateTime $expiryDate = this.getExpiryDate();
        result = result * 59 + ($expiryDate == null ? 43 : ((Object)$expiryDate).hashCode());
        Set<Feature> $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        return result;
    }

    public static class LicenseBuilder {
        private int allowedNumberOfNodes;
        private LicenseVersion version;
        private boolean trial;
        private String key;
        private ZonedDateTime creationDate;
        private ZonedDateTime expiryDate;
        private int allowedNativeMemorySize;
        private int allowedTieredStoreSize;
        private int allowedTpcCores;
        private int hazelcastVersion;
        private boolean oem;
        private int gracePeriod;
        private boolean features$set;
        private Set<Feature> features$value;

        LicenseBuilder() {
        }

        public LicenseBuilder allowedNumberOfNodes(int allowedNumberOfNodes) {
            this.allowedNumberOfNodes = allowedNumberOfNodes;
            return this;
        }

        public LicenseBuilder version(LicenseVersion version) {
            this.version = version;
            return this;
        }

        public LicenseBuilder trial(boolean trial) {
            this.trial = trial;
            return this;
        }

        public LicenseBuilder key(String key) {
            this.key = key;
            return this;
        }

        public LicenseBuilder creationDate(ZonedDateTime creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public LicenseBuilder expiryDate(ZonedDateTime expiryDate) {
            this.expiryDate = expiryDate;
            return this;
        }

        public LicenseBuilder allowedNativeMemorySize(int allowedNativeMemorySize) {
            this.allowedNativeMemorySize = allowedNativeMemorySize;
            return this;
        }

        public LicenseBuilder allowedTieredStoreSize(int allowedTieredStoreSize) {
            this.allowedTieredStoreSize = allowedTieredStoreSize;
            return this;
        }

        public LicenseBuilder allowedTpcCores(int allowedTpcCores) {
            this.allowedTpcCores = allowedTpcCores;
            return this;
        }

        public LicenseBuilder hazelcastVersion(int hazelcastVersion) {
            this.hazelcastVersion = hazelcastVersion;
            return this;
        }

        public LicenseBuilder oem(boolean oem) {
            this.oem = oem;
            return this;
        }

        public LicenseBuilder gracePeriod(int gracePeriod) {
            this.gracePeriod = gracePeriod;
            return this;
        }

        public LicenseBuilder features(Set<Feature> features) {
            this.features$value = features;
            this.features$set = true;
            return this;
        }

        public License build() {
            Set<Feature> features$value = this.features$value;
            if (!this.features$set) {
                features$value = License.$default$features();
            }
            return new License(this.allowedNumberOfNodes, this.version, this.trial, this.key, this.creationDate, this.expiryDate, this.allowedNativeMemorySize, this.allowedTieredStoreSize, this.allowedTpcCores, this.hazelcastVersion, this.oem, this.gracePeriod, features$value);
        }

        public String toString() {
            return "License.LicenseBuilder(allowedNumberOfNodes=" + this.allowedNumberOfNodes + ", version=" + this.version + ", trial=" + this.trial + ", key=" + this.key + ", creationDate=" + this.creationDate + ", expiryDate=" + this.expiryDate + ", allowedNativeMemorySize=" + this.allowedNativeMemorySize + ", allowedTieredStoreSize=" + this.allowedTieredStoreSize + ", allowedTpcCores=" + this.allowedTpcCores + ", hazelcastVersion=" + this.hazelcastVersion + ", oem=" + this.oem + ", gracePeriod=" + this.gracePeriod + ", features$value=" + this.features$value + ")";
        }
    }
}

