/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.instance.impl.ClusterTopologyIntentTracker;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.util.HostnameUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.kubernetes.KubernetesApiEndpointProvider;
import com.hazelcast.kubernetes.KubernetesApiEndpointSlicesProvider;
import com.hazelcast.kubernetes.KubernetesApiProvider;
import com.hazelcast.kubernetes.KubernetesClientException;
import com.hazelcast.kubernetes.KubernetesConfig;
import com.hazelcast.kubernetes.KubernetesTokenProvider;
import com.hazelcast.kubernetes.RuntimeContext;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.exception.RestClientException;
import com.hazelcast.spi.utils.RestClient;
import com.hazelcast.spi.utils.RetryUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class KubernetesClient {
    static final String SERVICE_TYPE_LOADBALANCER = "LoadBalancer";
    static final String SERVICE_TYPE_NODEPORT = "NodePort";
    private static final ILogger LOGGER = Logger.getLogger(KubernetesClient.class);
    private static final int HTTP_GONE = 410;
    private static final int HTTP_UNAUTHORIZED = 401;
    private static final int HTTP_FORBIDDEN = 403;
    private static final int CONNECTION_TIMEOUT_SECONDS = 10;
    private static final int READ_TIMEOUT_SECONDS = 10;
    private static final List<String> NON_RETRYABLE_KEYWORDS = Arrays.asList("\"reason\":\"Forbidden\"", "\"reason\":\"NotFound\"", "Failure in generating SSLSocketFactory", "REST call interrupted");
    private static final int STS_MONITOR_SHUTDOWN_AWAIT_TIMEOUT_MS = 1000;
    @Nullable
    final StsMonitorThread stsMonitorThread;
    private final String stsName;
    private final String namespace;
    private final String kubernetesMaster;
    private final String caCertificate;
    private final int retries;
    private final KubernetesApiProvider apiProvider;
    private final KubernetesConfig.ExposeExternallyMode exposeExternallyMode;
    private final boolean useNodeNameAsExternalAddress;
    private final String servicePerPodLabelName;
    private final String servicePerPodLabelValue;
    private final KubernetesTokenProvider tokenProvider;
    @Nullable
    private final ClusterTopologyIntentTracker clusterTopologyIntentTracker;
    private boolean isNoPublicIpAlreadyLogged;
    private boolean isKnownExceptionAlreadyLogged;
    private boolean isNodePortWarningAlreadyLogged;

    KubernetesClient(String namespace, String kubernetesMaster, KubernetesTokenProvider tokenProvider, String caCertificate, int retries, KubernetesConfig.ExposeExternallyMode exposeExternallyMode, boolean useNodeNameAsExternalAddress, String servicePerPodLabelName, String servicePerPodLabelValue, @Nullable ClusterTopologyIntentTracker clusterTopologyIntentTracker) {
        this.namespace = namespace;
        this.kubernetesMaster = kubernetesMaster;
        this.tokenProvider = tokenProvider;
        this.caCertificate = caCertificate;
        this.retries = retries;
        this.exposeExternallyMode = exposeExternallyMode;
        this.useNodeNameAsExternalAddress = useNodeNameAsExternalAddress;
        this.servicePerPodLabelName = servicePerPodLabelName;
        this.servicePerPodLabelValue = servicePerPodLabelValue;
        this.clusterTopologyIntentTracker = clusterTopologyIntentTracker;
        if (clusterTopologyIntentTracker != null) {
            clusterTopologyIntentTracker.initialize();
        }
        this.apiProvider = this.buildKubernetesApiUrlProvider();
        this.stsName = this.extractStsName();
        this.stsMonitorThread = clusterTopologyIntentTracker != null && clusterTopologyIntentTracker.isEnabled() ? new StsMonitorThread() : null;
    }

    KubernetesClient(String namespace, String kubernetesMaster, KubernetesTokenProvider tokenProvider, String caCertificate, int retries, KubernetesConfig.ExposeExternallyMode exposeExternallyMode, boolean useNodeNameAsExternalAddress, String servicePerPodLabelName, String servicePerPodLabelValue, @Nullable ClusterTopologyIntentTracker clusterTopologyIntentTracker, String stsName) {
        this.namespace = namespace;
        this.kubernetesMaster = kubernetesMaster;
        this.tokenProvider = tokenProvider;
        this.caCertificate = caCertificate;
        this.retries = retries;
        this.exposeExternallyMode = exposeExternallyMode;
        this.useNodeNameAsExternalAddress = useNodeNameAsExternalAddress;
        this.servicePerPodLabelName = servicePerPodLabelName;
        this.servicePerPodLabelValue = servicePerPodLabelValue;
        this.clusterTopologyIntentTracker = clusterTopologyIntentTracker;
        if (clusterTopologyIntentTracker != null) {
            clusterTopologyIntentTracker.initialize();
        }
        this.apiProvider = this.buildKubernetesApiUrlProvider();
        this.stsName = stsName;
        this.stsMonitorThread = clusterTopologyIntentTracker != null && clusterTopologyIntentTracker.isEnabled() ? new StsMonitorThread() : null;
    }

    KubernetesClient(String namespace, String kubernetesMaster, KubernetesTokenProvider tokenProvider, String caCertificate, int retries, KubernetesConfig.ExposeExternallyMode exposeExternallyMode, boolean useNodeNameAsExternalAddress, String servicePerPodLabelName, String servicePerPodLabelValue, KubernetesApiProvider apiProvider) {
        this.namespace = namespace;
        this.kubernetesMaster = kubernetesMaster;
        this.tokenProvider = tokenProvider;
        this.caCertificate = caCertificate;
        this.retries = retries;
        this.exposeExternallyMode = exposeExternallyMode;
        this.useNodeNameAsExternalAddress = useNodeNameAsExternalAddress;
        this.servicePerPodLabelName = servicePerPodLabelName;
        this.servicePerPodLabelValue = servicePerPodLabelValue;
        this.apiProvider = apiProvider;
        this.stsMonitorThread = null;
        this.stsName = this.extractStsName();
        this.clusterTopologyIntentTracker = null;
    }

    public void start() {
        if (this.stsMonitorThread != null) {
            this.stsMonitorThread.start();
        }
    }

    public void destroy() {
        if (this.stsMonitorThread != null) {
            LOGGER.info("Shutting down StatefulSet monitor thread");
            this.stsMonitorThread.shutdown();
        }
        if (this.clusterTopologyIntentTracker != null) {
            if (this.stsMonitorThread != null) {
                try {
                    this.stsMonitorThread.join(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.clusterTopologyIntentTracker.destroy();
        }
    }

    KubernetesApiProvider buildKubernetesApiUrlProvider() {
        try {
            String endpointSlicesUrlString = String.format("%s/apis/discovery.k8s.io/v1/namespaces/%s/endpointslices", this.kubernetesMaster, this.namespace);
            this.callGet(endpointSlicesUrlString);
            LOGGER.finest("Using EndpointSlices API to discover endpoints.");
        }
        catch (Exception e) {
            LOGGER.finest("EndpointSlices are not available, using Endpoints API to discover endpoints.");
            return new KubernetesApiEndpointProvider();
        }
        return new KubernetesApiEndpointSlicesProvider();
    }

    List<Endpoint> endpoints() {
        try {
            String urlString = String.format("%s/api/v1/namespaces/%s/pods", this.kubernetesMaster, this.namespace);
            return this.enrichWithPublicAddresses(KubernetesClient.parsePodsList(this.callGet(urlString)));
        }
        catch (RestClientException e) {
            return this.handleKnownException(e);
        }
    }

    List<Endpoint> endpointsByServiceLabel(String serviceLabels, String serviceLabelValues) {
        try {
            String param = KubernetesClient.getLabelSelectorParameter(serviceLabels, serviceLabelValues);
            String urlString = String.format(this.apiProvider.getEndpointsByServiceLabelUrlString(), this.kubernetesMaster, this.namespace, param);
            return this.enrichWithPublicAddresses(this.apiProvider.parseEndpointsList(this.callGet(urlString)));
        }
        catch (RestClientException e) {
            return this.handleKnownException(e);
        }
    }

    List<Endpoint> endpointsByName(String endpointName) {
        try {
            String urlString = String.format(this.apiProvider.getEndpointsByNameUrlString(), this.kubernetesMaster, this.namespace, endpointName);
            return this.enrichWithPublicAddresses(this.apiProvider.parseEndpoints(this.callGet(urlString)));
        }
        catch (RestClientException e) {
            return this.handleKnownException(e);
        }
    }

    List<Endpoint> endpointsByPodLabel(String podLabels, String podLabelValues) {
        try {
            String param = KubernetesClient.getLabelSelectorParameter(podLabels, podLabelValues);
            String urlString = String.format("%s/api/v1/namespaces/%s/pods?%s", this.kubernetesMaster, this.namespace, param);
            return this.enrichWithPublicAddresses(KubernetesClient.parsePodsList(this.callGet(urlString)));
        }
        catch (RestClientException e) {
            return this.handleKnownException(e);
        }
    }

    String zone(String podName) {
        String nodeUrlString = String.format("%s/api/v1/nodes/%s", this.kubernetesMaster, this.nodeName(podName));
        return KubernetesClient.extractZone(this.callGet(nodeUrlString));
    }

    String nodeName(String podName) {
        String podUrlString = String.format("%s/api/v1/namespaces/%s/pods/%s", this.kubernetesMaster, this.namespace, podName);
        return KubernetesClient.extractNodeName(this.callGet(podUrlString));
    }

    boolean isNoPublicIpAlreadyLogged() {
        return this.isNoPublicIpAlreadyLogged;
    }

    boolean isKnownExceptionAlreadyLogged() {
        return this.isKnownExceptionAlreadyLogged;
    }

    boolean isNodePortWarningAlreadyLogged() {
        return this.isNodePortWarningAlreadyLogged;
    }

    private String extractStsName() {
        String stsName = HostnameUtil.getLocalHostname();
        int dashIndex = stsName.lastIndexOf(45);
        if (dashIndex > 0) {
            stsName = stsName.substring(0, dashIndex);
        }
        return stsName;
    }

    private RuntimeContext extractSts(JsonObject jsonObject) {
        int specReplicas = jsonObject.get("spec").asObject().getInt("replicas", -1);
        int readyReplicas = jsonObject.get("status").asObject().getInt("readyReplicas", -1);
        String resourceVersion = jsonObject.get("metadata").asObject().getString("resourceVersion", null);
        int replicas = jsonObject.get("status").asObject().getInt("currentReplicas", -1);
        return new RuntimeContext(specReplicas, readyReplicas, replicas, resourceVersion);
    }

    @Nullable
    private String extractNodeName(EndpointAddress endpointAddress, Map<EndpointAddress, String> nodes) {
        String nodeName = nodes.get(endpointAddress);
        if (nodeName == null) {
            JsonObject podJson = this.callGet(String.format("%s/api/v1/namespaces/%s/pods/%s", this.kubernetesMaster, this.namespace, endpointAddress.getTargetRefName()));
            return podJson.get("spec").asObject().get("nodeName").asString();
        }
        return nodeName;
    }

    private List<Endpoint> enrichWithPublicAddresses(List<Endpoint> endpoints) {
        if (this.exposeExternallyMode == KubernetesConfig.ExposeExternallyMode.DISABLED) {
            return endpoints;
        }
        try {
            Object endpointsUrl = String.format(this.apiProvider.getEndpointsUrlString(), this.kubernetesMaster, this.namespace);
            if (!StringUtil.isNullOrEmptyAfterTrim(this.servicePerPodLabelName) && !StringUtil.isNullOrEmptyAfterTrim(this.servicePerPodLabelValue)) {
                endpointsUrl = (String)endpointsUrl + String.format("?labelSelector=%s=%s", this.servicePerPodLabelName, this.servicePerPodLabelValue);
            }
            JsonObject endpointsJson = this.callGet((String)endpointsUrl);
            List<String> privateAddresses = KubernetesClient.privateAddresses(endpoints);
            Map<EndpointAddress, String> services = this.apiProvider.extractServices(endpointsJson, privateAddresses);
            Map<EndpointAddress, String> nodeAddresses = this.apiProvider.extractNodes(endpointsJson, privateAddresses);
            HashMap<String, Address> publicServiceAddresses = new HashMap<String, Address>();
            HashMap<String, String> cachedNodePublicIps = new HashMap<String, String>();
            for (Map.Entry<EndpointAddress, String> serviceEntry : services.entrySet()) {
                EndpointAddress privateAddress = serviceEntry.getKey();
                String service = serviceEntry.getValue();
                String serviceUrl = String.format("%s/api/v1/namespaces/%s/services/%s", this.kubernetesMaster, this.namespace, service);
                JsonObject serviceJson = this.callGet(serviceUrl);
                String serviceType = KubernetesClient.extractServiceType(serviceJson);
                if (SERVICE_TYPE_LOADBALANCER.equals(serviceType)) {
                    Address loadBalancerServiceAddress = KubernetesClient.extractLoadBalancerServiceAddress(serviceJson);
                    publicServiceAddresses.put(privateAddress.getIp(), loadBalancerServiceAddress);
                    continue;
                }
                if (SERVICE_TYPE_NODEPORT.equals(serviceType)) {
                    Address nodePortServiceAddress = this.extractNodePortServiceAddress(serviceJson, serviceEntry.getKey(), nodeAddresses, cachedNodePublicIps);
                    publicServiceAddresses.put(privateAddress.getIp(), nodePortServiceAddress);
                    if (this.isNodePortWarningAlreadyLogged || this.exposeExternallyMode != KubernetesConfig.ExposeExternallyMode.ENABLED) continue;
                    LOGGER.warning("Using NodePort service type for public addresses may lead to connection issues from outside of the Kubernetes cluster. Ensure external accessibility of the NodePort IPs.");
                    this.isNodePortWarningAlreadyLogged = true;
                    continue;
                }
                throw new IllegalStateException(String.format("Service type '%s' is not supported to discover the public addresses of the members", serviceType));
            }
            return KubernetesClient.createEndpoints(endpoints, publicServiceAddresses);
        }
        catch (Exception e) {
            if (this.exposeExternallyMode == KubernetesConfig.ExposeExternallyMode.ENABLED) {
                throw e;
            }
            LOGGER.finest(e);
            if (!this.isNoPublicIpAlreadyLogged) {
                LOGGER.warning("Cannot fetch public IPs of Hazelcast Member PODs, you won't be able to use Hazelcast Smart Client from outside of the Kubernetes network");
                this.isNoPublicIpAlreadyLogged = true;
            }
            return endpoints;
        }
    }

    private String externalIpAddressForNode(String node) {
        String nodeExternalAddress;
        if (this.useNodeNameAsExternalAddress) {
            LOGGER.info("Using node name instead of public IP for node, must be available from client: " + node);
            nodeExternalAddress = node;
        } else {
            String nodeUrl = String.format("%s/api/v1/nodes/%s", this.kubernetesMaster, node);
            nodeExternalAddress = KubernetesClient.extractNodePublicIp(this.callGet(nodeUrl));
        }
        return nodeExternalAddress;
    }

    private Address extractNodePortServiceAddress(JsonObject serviceJson, EndpointAddress endpointAddress, Map<EndpointAddress, String> nodeAddresses, Map<String, String> cachedNodePublicIps) {
        String nodePublicIpAddress;
        Integer nodePort = KubernetesClient.extractNodePort(serviceJson);
        String node = this.extractNodeName(endpointAddress, nodeAddresses);
        if (cachedNodePublicIps.containsKey(node)) {
            nodePublicIpAddress = cachedNodePublicIps.get(node);
        } else {
            nodePublicIpAddress = this.externalIpAddressForNode(node);
            cachedNodePublicIps.put(node, nodePublicIpAddress);
        }
        return new Address(nodePublicIpAddress, nodePort);
    }

    private JsonObject callGet(String urlString) {
        return RetryUtils.retry(() -> Json.parse((this.caCertificate == null ? RestClient.create(urlString, 10) : RestClient.createWithSSL(urlString, this.caCertificate, 10)).withHeader("Authorization", String.format("Bearer %s", this.tokenProvider.getToken())).withRequestTimeoutSeconds(10).get().getBody()).asObject(), this.retries, NON_RETRYABLE_KEYWORDS);
    }

    private List<Endpoint> handleKnownException(RestClientException e) {
        if (e.getHttpErrorCode() == 401) {
            if (!this.isKnownExceptionAlreadyLogged) {
                LOGGER.warning("Kubernetes API authorization failure! To use Hazelcast Kubernetes discovery, please check your 'api-token' property. Starting standalone.");
                this.isKnownExceptionAlreadyLogged = true;
            }
        } else if (e.getHttpErrorCode() == 403) {
            if (!this.isKnownExceptionAlreadyLogged) {
                LOGGER.warning("Kubernetes API access is forbidden! Starting standalone. To use Hazelcast Kubernetes discovery, configure the required RBAC. For 'default' service account in 'default' namespace execute `kubectl apply -f https://raw.githubusercontent.com/hazelcast/hazelcast/master/kubernetes-rbac.yaml` If you want to use a different service account and a different namespace, you can update the mentioned rbac.yaml file accordingly and use it. Error Kubernetes API Cause details:", e);
                this.isKnownExceptionAlreadyLogged = true;
            }
        } else {
            throw e;
        }
        LOGGER.finest(e);
        return Collections.emptyList();
    }

    private static String getLabelSelectorParameter(String labelNames, String labelValues) {
        ArrayList<String> labelNameList = new ArrayList<String>(Arrays.asList(labelNames.split(",")));
        ArrayList<String> labelValueList = new ArrayList<String>(Arrays.asList(labelValues.split(",")));
        ArrayList<String> selectorList = new ArrayList<String>(labelNameList.size());
        for (int i = 0; i < labelNameList.size(); ++i) {
            selectorList.add(i, String.format("%s=%s", labelNameList.get(i), labelValueList.get(i)));
        }
        return String.format("labelSelector=%s", String.join((CharSequence)",", selectorList));
    }

    private static List<Endpoint> parsePodsList(JsonObject podsListJson) {
        ArrayList<Endpoint> addresses = new ArrayList<Endpoint>();
        for (JsonValue item : KubernetesClient.toJsonArray(podsListJson.get("items"))) {
            String podName = item.asObject().get("metadata").asObject().get("name").asString();
            JsonObject status = item.asObject().get("status").asObject();
            String ip = KubernetesClient.toString(status.get("podIP"));
            if (ip == null) continue;
            Integer port = KubernetesClient.extractContainerPort(item);
            addresses.add(new Endpoint(new EndpointAddress(ip, port, podName), KubernetesClient.isReady(status)));
        }
        return addresses;
    }

    private static Integer extractContainerPort(JsonValue podItemJson) {
        JsonArray containers = KubernetesClient.toJsonArray(podItemJson.asObject().get("spec").asObject().get("containers"));
        if (containers.size() == 1) {
            JsonValue container = containers.get(0);
            return KubernetesClient.containerPort(container);
        }
        for (JsonValue container : containers) {
            if (!container.asObject().getString("name", "").equals("hazelcast")) continue;
            return KubernetesClient.containerPort(container);
        }
        return null;
    }

    private static Integer containerPort(JsonValue container) {
        JsonValue port;
        JsonValue containerPort;
        JsonArray ports = KubernetesClient.toJsonArray(container.asObject().get("ports"));
        if (ports.size() > 0 && (containerPort = (port = ports.get(0)).asObject().get("containerPort")) != null && containerPort.isNumber()) {
            return containerPort.asInt();
        }
        return null;
    }

    private static boolean isReady(JsonObject podItemStatusJson) {
        for (JsonValue containerStatus : KubernetesClient.toJsonArray(podItemStatusJson.get("containerStatuses"))) {
            if (containerStatus.asObject().get("ready").asBoolean()) continue;
            return false;
        }
        return true;
    }

    private static String extractNodeName(JsonObject podJson) {
        return KubernetesClient.toString(podJson.get("spec").asObject().get("nodeName"));
    }

    private static String extractZone(JsonObject nodeJson) {
        JsonObject labels = nodeJson.get("metadata").asObject().get("labels").asObject();
        List<String> zoneLabels = Arrays.asList("topology.kubernetes.io/zone", "failure-domain.kubernetes.io/zone", "failure-domain.beta.kubernetes.io/zone");
        for (String zoneLabel : zoneLabels) {
            JsonValue zone = labels.get(zoneLabel);
            if (zone == null) continue;
            return KubernetesClient.toString(zone);
        }
        return null;
    }

    private static String extractServiceType(JsonObject serviceResponse) {
        return serviceResponse.get("spec").asObject().get("type").asString();
    }

    private static Address extractLoadBalancerServiceAddress(JsonObject serviceJson) {
        String loadBalancerIpAddress = KubernetesClient.extractLoadBalancerIpAddress(serviceJson);
        Integer servicePort = KubernetesClient.extractServicePort(serviceJson);
        return new Address(loadBalancerIpAddress, servicePort);
    }

    private static List<String> privateAddresses(List<Endpoint> endpoints) {
        ArrayList<String> result = new ArrayList<String>();
        for (Endpoint endpoint : endpoints) {
            result.add(endpoint.getPrivateAddress().getIp());
        }
        return result;
    }

    private static String extractLoadBalancerIpAddress(JsonObject serviceResponse) {
        try {
            JsonObject ingress = serviceResponse.get("status").asObject().get("loadBalancer").asObject().get("ingress").asArray().get(0).asObject();
            JsonValue address = ingress.get("ip");
            if (address == null) {
                address = ingress.get("hostname");
            }
            return address.asString();
        }
        catch (Exception e) {
            throw new KubernetesClientException("Unable to extract the public address from the LoadBalancer service", e);
        }
    }

    private static List<Endpoint> createEndpoints(List<Endpoint> endpoints, Map<String, Address> publicAddresses) {
        ArrayList<Endpoint> result = new ArrayList<Endpoint>();
        for (Endpoint endpoint : endpoints) {
            EndpointAddress privateAddress = endpoint.getPrivateAddress();
            Address serviceAddress = publicAddresses.get(privateAddress.getIp());
            EndpointAddress publicAddress = new EndpointAddress(serviceAddress.ip, serviceAddress.port, privateAddress.getTargetRefName());
            result.add(new Endpoint(privateAddress, publicAddress, endpoint.isReady(), endpoint.getAdditionalProperties()));
        }
        return result;
    }

    private static Integer extractServicePort(JsonObject serviceJson) {
        JsonArray ports = KubernetesClient.toJsonArray(serviceJson.get("spec").asObject().get("ports"));
        if (ports.size() != 1) {
            throw new KubernetesClientException(String.format("Cannot expose externally, service %s needs to have exactly one port defined", serviceJson.get("metadata").asObject().get("name")));
        }
        return ports.get(0).asObject().get("port").asInt();
    }

    private static Integer extractNodePort(JsonObject serviceJson) {
        JsonArray ports = KubernetesClient.toJsonArray(serviceJson.get("spec").asObject().get("ports"));
        if (ports.size() != 1) {
            throw new KubernetesClientException(String.format("Cannot expose externally, service %s needs to have exactly one nodePort defined", serviceJson.get("metadata").asObject().get("name")));
        }
        return ports.get(0).asObject().get("nodePort").asInt();
    }

    private static String extractNodePublicIp(JsonObject nodeJson) {
        for (JsonValue address : KubernetesClient.toJsonArray(nodeJson.get("status").asObject().get("addresses"))) {
            if (!"ExternalIP".equals(address.asObject().get("type").asString())) continue;
            return address.asObject().get("address").asString();
        }
        throw new KubernetesClientException(String.format("Cannot expose externally, node %s does not have ExternalIP assigned", nodeJson.get("metadata").asObject().get("name")));
    }

    private static JsonArray toJsonArray(JsonValue jsonValue) {
        if (jsonValue == null || jsonValue.isNull()) {
            return new JsonArray();
        }
        return jsonValue.asArray();
    }

    private static String toString(JsonValue jsonValue) {
        if (jsonValue == null || jsonValue.isNull()) {
            return null;
        }
        if (jsonValue.isString()) {
            return jsonValue.asString();
        }
        return jsonValue.toString();
    }

    final class StsMonitorThread
    extends Thread {
        private static final int MAX_SPINS = 3;
        private static final int MAX_YIELDS = 10;
        private static final int MIN_PARK_PERIOD_MILLIS = 1;
        private static final int MAX_PARK_PERIOD_SECONDS = 10;
        volatile boolean running;
        volatile boolean finished;
        volatile boolean shuttingDown;
        String latestResourceVersion;
        RuntimeContext latestRuntimeContext;
        int idleCount;
        RestClient.WatchResponse watchResponse;
        private final String stsUrlString;
        private final BackoffIdleStrategy backoffIdleStrategy;

        StsMonitorThread() {
            super("hz-k8s-sts-monitor");
            this.running = true;
            this.stsUrlString = this.formatStsListUrl();
            this.backoffIdleStrategy = new BackoffIdleStrategy(3L, 10L, TimeUnit.MILLISECONDS.toNanos(1L), TimeUnit.SECONDS.toNanos(10L));
        }

        @Override
        public void run() {
            while (this.running && !this.shuttingDown) {
                try {
                    RuntimeContext previous = this.latestRuntimeContext;
                    this.readInitialStsList();
                    this.updateTracker(previous, this.latestRuntimeContext);
                    this.watchResponse = this.sendWatchRequest();
                }
                catch (RestClientException e) {
                    if (this.shuttingDown) break;
                    this.handleFailure(e);
                    continue;
                }
                this.idleCount = 0;
                try {
                    String message;
                    while ((message = this.watchResponse.nextLine()) != null) {
                        this.onMessage(message);
                    }
                }
                catch (IOException e) {
                    if (this.shuttingDown) continue;
                    LOGGER.info("Exception while watching for StatefulSet changes", e);
                    try {
                        this.watchResponse.disconnect();
                    }
                    catch (Exception t) {
                        LOGGER.fine("Exception while closing connection after an IOException", t);
                    }
                }
            }
            this.finished = true;
        }

        public void shutdown() {
            this.shuttingDown = true;
            try {
                if (this.watchResponse != null) {
                    this.watchResponse.disconnect();
                }
            }
            catch (IOException e) {
                LOGGER.fine("Exception while closing connection during shutdown", e);
            }
            KubernetesClient.this.stsMonitorThread.interrupt();
        }

        private void handleFailure(RestClientException e) {
            if (e.getHttpErrorCode() == 410) {
                LOGGER.info("StatefulSet watcher has fallen behind, re-reading sts list and resuming watch: " + e.getMessage());
            } else {
                LOGGER.warning("Error while attempting to watch kubernetes API for StatefulSets: " + e.getHttpErrorCode() + " " + e.getMessage() + ". Backing off (n: " + this.idleCount + " ) before retrying.");
                this.backoffIdleStrategy.idle(this.idleCount);
                ++this.idleCount;
            }
        }

        String formatStsListUrl() {
            String fieldSelectorValue = String.format("metadata.name=%s", KubernetesClient.this.stsName);
            fieldSelectorValue = URLEncoder.encode(fieldSelectorValue, StandardCharsets.UTF_8);
            return String.format("%s/apis/apps/v1/namespaces/%s/statefulsets?fieldSelector=%s", KubernetesClient.this.kubernetesMaster, KubernetesClient.this.namespace, fieldSelectorValue);
        }

        void readInitialStsList() {
            JsonObject jsonObject = KubernetesClient.this.callGet(this.stsUrlString);
            this.latestResourceVersion = jsonObject.get("metadata").asObject().getString("resourceVersion", null);
            this.latestRuntimeContext = this.parseStsList(jsonObject);
        }

        @Nonnull
        RestClient.WatchResponse sendWatchRequest() throws RestClientException {
            RestClient restClient = (KubernetesClient.this.caCertificate == null ? RestClient.create(this.stsUrlString) : RestClient.createWithSSL(this.stsUrlString, KubernetesClient.this.caCertificate)).withHeader("Authorization", String.format("Bearer %s", KubernetesClient.this.tokenProvider.getToken()));
            return restClient.watch(this.latestResourceVersion);
        }

        @Nullable
        RuntimeContext parseStsList(JsonObject jsonObject) {
            String resourceVersion = jsonObject.get("metadata").asObject().getString("resourceVersion", null);
            for (JsonValue item : KubernetesClient.toJsonArray(jsonObject.get("items"))) {
                String itemName = item.asObject().get("metadata").asObject().getString("name", null);
                if (!KubernetesClient.this.stsName.equals(itemName)) continue;
                int specReplicas = item.asObject().get("spec").asObject().getInt("replicas", -1);
                int readyReplicas = item.asObject().get("status").asObject().getInt("readyReplicas", -1);
                int replicas = item.asObject().get("status").asObject().getInt("currentReplicas", -1);
                return new RuntimeContext(specReplicas, readyReplicas, replicas, resourceVersion);
            }
            return null;
        }

        void onMessage(String message) {
            JsonObject jsonObject;
            JsonObject sts;
            String itemName;
            if (LOGGER.isFinestEnabled()) {
                LOGGER.finest("Complete message from kubernetes API: " + message);
            }
            if (!KubernetesClient.this.stsName.equals(itemName = (sts = (jsonObject = Json.parse(message).asObject()).get("object").asObject()).asObject().get("metadata").asObject().getString("name", null))) {
                return;
            }
            String watchType = jsonObject.getString("type", null);
            RuntimeContext ctx = null;
            switch (watchType) {
                case "MODIFIED": {
                    ctx = KubernetesClient.this.extractSts(sts);
                    this.latestResourceVersion = ctx.getResourceVersion();
                    break;
                }
                case "DELETED": {
                    ctx = KubernetesClient.this.extractSts(sts);
                    this.latestResourceVersion = ctx.getResourceVersion();
                    ctx = new RuntimeContext(0, ctx.getReadyReplicas(), ctx.getCurrentReplicas(), ctx.getResourceVersion());
                    break;
                }
                case "ADDED": {
                    throw new IllegalStateException("A new sts with same name as this cannot be added");
                }
                default: {
                    LOGGER.info("Unknown watch type " + watchType + ", complete message:\n" + message);
                }
            }
            if (this.latestRuntimeContext != null && ctx != null) {
                this.updateTracker(this.latestRuntimeContext, ctx);
            }
            this.latestRuntimeContext = ctx;
        }

        void updateTracker(RuntimeContext previous, RuntimeContext updated) {
            if (previous != null) {
                LOGGER.info("Updating cluster topology tracker with previous: " + String.valueOf(previous) + ", updated: " + String.valueOf(updated));
                KubernetesClient.this.clusterTopologyIntentTracker.update(previous.getSpecifiedReplicaCount(), updated.getSpecifiedReplicaCount(), previous.getReadyReplicas(), updated.getReadyReplicas(), previous.getCurrentReplicas(), updated.getCurrentReplicas());
            } else {
                LOGGER.info("Initializing cluster topology tracker with initial context: " + String.valueOf(this.latestRuntimeContext));
                KubernetesClient.this.clusterTopologyIntentTracker.update(-1, updated.getSpecifiedReplicaCount(), -1, updated.getReadyReplicas(), -1, updated.getCurrentReplicas());
            }
        }
    }

    static final class EndpointAddress {
        private final Address address;
        private String targetRefName;

        EndpointAddress(Address address) {
            this.address = address;
        }

        EndpointAddress(String ip, Integer port) {
            this(new Address(ip, port));
        }

        EndpointAddress(String ip, Integer port, String targetRefName) {
            this(ip, port);
            this.targetRefName = targetRefName;
        }

        String getIp() {
            return this.address.ip;
        }

        Integer getPort() {
            return this.address.port;
        }

        String getTargetRefName() {
            return this.targetRefName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndpointAddress endpointAddress = (EndpointAddress)o;
            return Objects.equals(this.address, endpointAddress.address) && Objects.equals(this.targetRefName, endpointAddress.targetRefName);
        }

        public int hashCode() {
            return Objects.hash(this.address, this.targetRefName);
        }

        public String toString() {
            return this.address.toString();
        }
    }

    static final class Address {
        private final String ip;
        private final Integer port;

        Address(String ip, Integer port) {
            this.ip = ip;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Address address = (Address)o;
            return Objects.equals(this.ip, address.ip) && Objects.equals(this.port, address.port);
        }

        public int hashCode() {
            return Objects.hash(this.ip, this.port);
        }

        public String toString() {
            return String.format("%s:%s", this.ip, this.port);
        }
    }

    static final class Endpoint {
        private final EndpointAddress privateAddress;
        private final EndpointAddress publicAddress;
        private final boolean isReady;
        private final Map<String, String> additionalProperties;

        Endpoint(EndpointAddress privateAddress, boolean isReady) {
            this.privateAddress = privateAddress;
            this.publicAddress = null;
            this.isReady = isReady;
            this.additionalProperties = Collections.emptyMap();
        }

        Endpoint(EndpointAddress privateAddress, boolean isReady, Map<String, String> additionalProperties) {
            this.privateAddress = privateAddress;
            this.publicAddress = null;
            this.isReady = isReady;
            this.additionalProperties = additionalProperties;
        }

        Endpoint(EndpointAddress privateAddress, EndpointAddress publicAddress, boolean isReady, Map<String, String> additionalProperties) {
            this.privateAddress = privateAddress;
            this.publicAddress = publicAddress;
            this.isReady = isReady;
            this.additionalProperties = additionalProperties;
        }

        EndpointAddress getPublicAddress() {
            return this.publicAddress;
        }

        EndpointAddress getPrivateAddress() {
            return this.privateAddress;
        }

        boolean isReady() {
            return this.isReady;
        }

        Map<String, String> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }
}

