/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.client.impl.protocol.ClientExceptionFactory;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JobAlreadyExistsException;
import com.hazelcast.jet.RestartableException;
import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.core.TopologyChangedException;
import com.hazelcast.jet.datamodel.Tuple3;
import com.hazelcast.jet.impl.exception.CancellationByUserException;
import com.hazelcast.jet.impl.exception.EnteringPassiveClusterStateException;
import com.hazelcast.jet.impl.exception.JetDisabledException;
import com.hazelcast.jet.impl.exception.JobTerminateRequestedException;
import com.hazelcast.jet.impl.exception.TerminatedWithSnapshotException;
import com.hazelcast.jet.impl.execution.TaskletExecutionException;
import com.hazelcast.jet.impl.operation.InitExecutionOperation;
import com.hazelcast.jet.impl.operation.StartExecutionOperation;
import com.hazelcast.jet.pipeline.test.AssertionCompletedException;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.sql.impl.ResultLimitReachedException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExceptionUtil {
    private static final List<Tuple3<Integer, Class<? extends Throwable>, ClientExceptionFactory.ExceptionFactory>> EXCEPTIONS = Arrays.asList(Tuple3.tuple3(500, JetException.class, JetException::new), Tuple3.tuple3(501, TopologyChangedException.class, TopologyChangedException::new), Tuple3.tuple3(502, JobNotFoundException.class, JobNotFoundException::new), Tuple3.tuple3(503, JobAlreadyExistsException.class, JobAlreadyExistsException::new), Tuple3.tuple3(504, AssertionCompletedException.class, AssertionCompletedException::new), Tuple3.tuple3(505, JetDisabledException.class, JetDisabledException::new), Tuple3.tuple3(506, CancellationByUserException.class, CancellationByUserException::new), Tuple3.tuple3(507, TaskletExecutionException.class, TaskletExecutionException::new));

    private ExceptionUtil() {
    }

    public static boolean isRestartableException(Throwable t) {
        return ExceptionUtil.isTopologyException(t) || t instanceof RestartableException || t instanceof JetException && ExceptionUtil.isOrHasCause(t, RestartableException.class) || t instanceof CompletionException && ExceptionUtil.isOrHasCause(t, RestartableException.class);
    }

    public static boolean isTopologyException(Throwable t) {
        return t instanceof TopologyChangedException || t instanceof MemberLeftException || t instanceof TargetNotMemberException || t instanceof HazelcastInstanceNotActiveException || t instanceof EnteringPassiveClusterStateException || t instanceof OperationTimeoutException && (t.getMessage().contains(InitExecutionOperation.class.getSimpleName()) || t.getMessage().contains(StartExecutionOperation.class.getSimpleName()));
    }

    public static void registerJetExceptions(@Nonnull ClientExceptionFactory factory) {
        for (Tuple3<Integer, Class<? extends Throwable>, ClientExceptionFactory.ExceptionFactory> exception : EXCEPTIONS) {
            factory.register(exception.f0(), exception.f1(), exception.f2());
        }
    }

    public static Throwable peel(@Nullable Throwable t) {
        while ((t instanceof CompletionException || t instanceof ExecutionException || t instanceof InvocationTargetException) && t.getCause() != null && t.getCause() != t) {
            t = t.getCause();
        }
        return t;
    }

    @Nonnull
    private static RuntimeException peeledAndUnchecked(@Nonnull Throwable t) {
        if ((t = ExceptionUtil.peel(t)) instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new JetException(t);
    }

    @Nonnull
    public static RuntimeException rethrow(@Nonnull Throwable t) {
        com.hazelcast.internal.util.ExceptionUtil.rethrowIfError(t);
        throw ExceptionUtil.peeledAndUnchecked(t);
    }

    public static RuntimeException handleSerializedLambdaCce(HazelcastSerializationException e) {
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ClassCastException) || !cause.getMessage().startsWith("cannot assign instance of java.lang.invoke.SerializedLambda")) continue;
            throw new JetException("Class containing the lambda probably missing from class path, did you add it using JobConfig.addClass()?: " + String.valueOf(e), e);
        }
        throw e;
    }

    public static boolean isOrHasCause(Throwable t, Class<?> classToFind) {
        while (t != null && t.getCause() != t && !classToFind.isAssignableFrom(t.getClass())) {
            t = t.getCause();
        }
        return t != null && classToFind.isAssignableFrom(t.getClass());
    }

    public static boolean isTechnicalCancellationException(Throwable t) {
        Throwable peeledFailure = ExceptionUtil.peel(t);
        return peeledFailure instanceof JobTerminateRequestedException || peeledFailure instanceof ResultLimitReachedException || peeledFailure instanceof TerminatedWithSnapshotException || peeledFailure instanceof CancellationByUserException || ExceptionUtil.checkCause(peeledFailure);
    }

    private static boolean checkCause(Throwable peeledFailure) {
        return peeledFailure.getCause() != null && peeledFailure != peeledFailure.getCause() && ExceptionUtil.isTechnicalCancellationException(peeledFailure.getCause());
    }
}

