/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.function.ComparatorEx;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyor;
import com.hazelcast.internal.util.concurrent.Pipe;
import com.hazelcast.internal.util.concurrent.QueuedPipe;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.execution.DoneItem;
import com.hazelcast.jet.impl.execution.InboundEdgeStream;
import com.hazelcast.jet.impl.execution.KeyedWatermarkCoalescer;
import com.hazelcast.jet.impl.execution.SnapshotBarrier;
import com.hazelcast.jet.impl.execution.SpecialBroadcastItem;
import com.hazelcast.jet.impl.util.PrefixedLogger;
import com.hazelcast.jet.impl.util.ProgressState;
import com.hazelcast.jet.impl.util.ProgressTracker;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ConcurrentInboundEdgeStream {
    private ConcurrentInboundEdgeStream() {
    }

    public static InboundEdgeStream create(@Nonnull ConcurrentConveyor<Object> conveyor, int ordinal, int priority, boolean waitForAllBarriers, @Nonnull String debugName, @Nullable ComparatorEx<?> comparator) {
        if (comparator == null) {
            return new RoundRobinDrain(conveyor, ordinal, priority, debugName, waitForAllBarriers);
        }
        return new OrderedDrain(conveyor, ordinal, priority, debugName, comparator);
    }

    private static final class RoundRobinDrain
    extends InboundEdgeStreamBase {
        private final ItemDetector itemDetector = new ItemDetector();
        private final KeyedWatermarkCoalescer coalescers;
        private final BitSet receivedBarriers;
        private boolean waitForAllBarriers;
        private SnapshotBarrier currentBarrier;
        private final List<SpecialBroadcastItem> specialItemsStash = new ArrayList<SpecialBroadcastItem>();

        RoundRobinDrain(@Nonnull ConcurrentConveyor<Object> conveyor, int ordinal, int priority, @Nonnull String debugName, boolean waitForAllBarriers) {
            super(conveyor, ordinal, priority, debugName);
            this.waitForAllBarriers = waitForAllBarriers;
            this.coalescers = new KeyedWatermarkCoalescer(conveyor.queueCount());
            this.receivedBarriers = new BitSet(conveyor.queueCount());
        }

        @Override
        @Nonnull
        public ProgressState drainTo(@Nonnull Consumer<Object> dest) {
            if (!this.specialItemsStash.isEmpty()) {
                this.specialItemsStash.forEach(dest);
                this.specialItemsStash.clear();
                return ProgressState.MADE_PROGRESS;
            }
            this.tracker.reset();
            boolean normalItemWasObservedOnAnyQueue = false;
            for (int queueIndex = 0; queueIndex < this.conveyor.queueCount(); ++queueIndex) {
                int liveQueueCount;
                this.itemDetector.normalItemObserved = false;
                QueuedPipe<Object> q = this.conveyor.queue(queueIndex);
                if (q == null || this.waitForAllBarriers && this.receivedBarriers.get(queueIndex)) continue;
                ProgressState result = this.drainQueue(q, dest);
                this.tracker.mergeWith(result);
                normalItemWasObservedOnAnyQueue |= this.itemDetector.normalItemObserved;
                if (this.itemDetector.item != null) {
                    if (this.itemDetector.item == DoneItem.DONE_ITEM) {
                        this.conveyor.removeQueue(queueIndex);
                        this.receivedBarriers.clear(queueIndex);
                        this.specialItemsStash.addAll(this.coalescers.queueDone(queueIndex));
                    } else if (this.itemDetector.item instanceof Watermark) {
                        Watermark watermark = (Watermark)this.itemDetector.item;
                        this.specialItemsStash.addAll(this.coalescers.observeWm(queueIndex, watermark));
                    } else if (this.itemDetector.item instanceof SnapshotBarrier) {
                        this.observeBarrier(queueIndex, (SnapshotBarrier)this.itemDetector.item);
                        this.tracker.madeProgress();
                    } else assert (false) : "should never get here";
                }
                if (this.itemDetector.normalItemObserved) {
                    this.coalescers.observeEvent(queueIndex);
                }
                if ((liveQueueCount = this.conveyor.liveQueueCount()) <= 0 || this.itemDetector.item == null || this.receivedBarriers.cardinality() != liveQueueCount) continue;
                assert (this.currentBarrier != null) : "currentBarrier == null";
                this.specialItemsStash.add(this.currentBarrier);
                this.currentBarrier = null;
                this.receivedBarriers.clear();
                break;
            }
            if (!normalItemWasObservedOnAnyQueue) {
                this.specialItemsStash.forEach(dest);
                this.specialItemsStash.clear();
            }
            if (this.conveyor.liveQueueCount() > 0) {
                this.tracker.notDone();
            }
            return this.tracker.toProgressState();
        }

        @Override
        public boolean isDone() {
            return super.isDone() && this.specialItemsStash.isEmpty();
        }

        private ProgressState drainQueue(Pipe<Object> queue, Consumer<Object> dest) {
            this.itemDetector.reset(dest);
            int drainedCount = queue.drain(this.itemDetector);
            this.itemDetector.dest = null;
            return ProgressState.valueOf(drainedCount > 0, this.itemDetector.item == DoneItem.DONE_ITEM);
        }

        private void observeBarrier(int queueIndex, SnapshotBarrier barrier) {
            if (this.currentBarrier == null) {
                this.currentBarrier = barrier;
            } else assert (this.currentBarrier.equals(barrier)) : String.valueOf(this.currentBarrier) + " != " + String.valueOf(barrier);
            if (barrier.isTerminal()) {
                this.waitForAllBarriers = true;
            }
            this.receivedBarriers.set(queueIndex);
        }

        private static final class ItemDetector
        implements Predicate<Object> {
            Consumer<Object> dest;
            SpecialBroadcastItem item;
            boolean normalItemObserved;

            private ItemDetector() {
            }

            void reset(Consumer<Object> newDest) {
                this.dest = newDest;
                this.item = null;
            }

            @Override
            public boolean test(Object o) {
                if (o instanceof SpecialBroadcastItem) {
                    this.item = (SpecialBroadcastItem)o;
                    return false;
                }
                this.normalItemObserved = true;
                this.dest.accept(o);
                return true;
            }
        }
    }

    private static final class OrderedDrain
    extends InboundEdgeStreamBase {
        private final Comparator<Object> comparator;
        private final List<QueuedPipe<Object>> queues;
        private final List<ArrayDeque<Object>> drainedItems;
        private Object lastItem;
        private int lastMinIndex;

        OrderedDrain(@Nonnull ConcurrentConveyor<Object> conveyor, int ordinal, int priority, @Nonnull String debugName, @Nullable ComparatorEx<?> comparator) {
            super(conveyor, ordinal, priority, debugName);
            this.comparator = comparator;
            this.drainedItems = new ArrayList<ArrayDeque<Object>>(conveyor.queueCount());
            this.queues = new ArrayList<QueuedPipe<Object>>(conveyor.queueCount());
            for (int i = 0; i < conveyor.queueCount(); ++i) {
                QueuedPipe<Object> q = conveyor.queue(i);
                this.drainedItems.add(new ArrayDeque(q.capacity()));
                this.queues.add(q);
            }
        }

        @Override
        @Nonnull
        public ProgressState drainTo(@Nonnull Consumer<Object> dest) {
            this.tracker.reset();
            this.tracker.notDone();
            for (int i = 0; i < this.queues.size(); ++i) {
                if (!this.drainedItems.get(i).isEmpty()) continue;
                this.queues.get(i).drainTo((Collection<Object>)this.drainedItems.get(i), Integer.MAX_VALUE);
            }
            block1: while (true) {
                Object minItem = null;
                for (int i = 0; i < this.drainedItems.size(); ++i) {
                    Object item = this.drainedItems.get(i).peek();
                    if (item == null) {
                        return this.tracker.toProgressState();
                    }
                    this.tracker.madeProgress();
                    if (item == DoneItem.DONE_ITEM) {
                        this.queues.remove(i);
                        this.drainedItems.remove(i);
                        if (!this.queues.isEmpty()) continue block1;
                        this.tracker.done();
                        return this.tracker.toProgressState();
                    }
                    if (item instanceof Watermark || item instanceof SnapshotBarrier) {
                        throw new JetException("Unexpected item observed: " + String.valueOf(item));
                    }
                    if (minItem != null && this.comparator.compare(minItem, item) <= 0) continue;
                    minItem = item;
                    this.lastMinIndex = i;
                }
                this.drainedItems.get(this.lastMinIndex).remove();
                assert (this.lastItem == null || this.comparator.compare(this.lastItem, minItem) <= 0) : "Disorder on a monotonicOrder edge";
                this.lastItem = minItem;
                dest.accept(this.lastItem);
            }
        }

        @Override
        public boolean isDone() {
            return this.queues.isEmpty();
        }
    }

    private static abstract class InboundEdgeStreamBase
    implements InboundEdgeStream {
        final ProgressTracker tracker = new ProgressTracker();
        final ConcurrentConveyor<Object> conveyor;
        final int ordinal;
        final int priority;
        final ILogger logger;

        private InboundEdgeStreamBase(@Nonnull ConcurrentConveyor<Object> conveyor, int ordinal, int priority, @Nonnull String debugName) {
            this.conveyor = conveyor;
            this.ordinal = ordinal;
            this.priority = priority;
            this.logger = PrefixedLogger.prefixedLogger(Logger.getLogger(this.getClass()), debugName);
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Coalescing " + conveyor.queueCount() + " input queues");
            }
        }

        @Override
        public int ordinal() {
            return this.ordinal;
        }

        @Override
        public int priority() {
            return this.priority;
        }

        @Override
        public boolean isDone() {
            return this.conveyor.liveQueueCount() == 0;
        }

        @Override
        public int sizes() {
            return this.conveyorSum(Collection::size);
        }

        @Override
        public int capacities() {
            return this.conveyorSum(Pipe::capacity);
        }

        private int conveyorSum(ToIntFunction<QueuedPipe<Object>> toIntF) {
            int sum = 0;
            for (int queueIndex = 0; queueIndex < this.conveyor.queueCount(); ++queueIndex) {
                QueuedPipe<Object> q = this.conveyor.queue(queueIndex);
                if (q == null) continue;
                sum += toIntF.applyAsInt(q);
            }
            return sum;
        }
    }
}

