/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.internal.nio.Bits;
import com.hazelcast.internal.serialization.BinaryInterface;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.processor.TransactionPoolSnapshotUtility;
import com.hazelcast.jet.impl.processor.TwoPhaseSnapshotCommitUtility;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public abstract class XaSinkProcessorBase
implements Processor {
    private static final int COMMIT_RETRY_DELAY_MS = 100;
    protected TransactionPoolSnapshotUtility<XaTransactionId, XaTransaction> snapshotUtility;
    private ProcessingGuarantee externalGuarantee;
    private Processor.Context context;
    private XAResource xaResource;

    protected XaSinkProcessorBase(ProcessingGuarantee externalGuarantee) {
        this.externalGuarantee = externalGuarantee;
    }

    @Override
    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) throws Exception {
        this.context = context;
        this.externalGuarantee = com.hazelcast.jet.impl.util.Util.min(this.externalGuarantee, context.processingGuarantee());
        this.snapshotUtility = new TransactionPoolSnapshotUtility<XaTransactionId, XaTransaction>(outbox, context, false, this.externalGuarantee, 2, (procIndex, txnIndex) -> new XaTransactionId(context, (int)procIndex, (int)txnIndex), x$0 -> new XaTransaction((XaTransactionId)x$0), this::recoverTransaction, this::abortTransaction);
    }

    @Override
    public boolean tryProcess() {
        return this.snapshotUtility.tryProcess();
    }

    @Override
    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return true;
    }

    @Override
    public boolean complete() {
        this.snapshotUtility.afterCompleted();
        return true;
    }

    @Override
    public boolean snapshotCommitPrepare() {
        return this.snapshotUtility.snapshotCommitPrepare();
    }

    @Override
    public boolean snapshotCommitFinish(boolean success) {
        return this.snapshotUtility.snapshotCommitFinish(success);
    }

    @Override
    public void restoreFromSnapshot(@Nonnull Inbox inbox) {
        this.snapshotUtility.restoreFromSnapshot(inbox);
    }

    @Override
    public void close() throws Exception {
        if (this.snapshotUtility != null) {
            this.snapshotUtility.close();
        }
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    public void setXaResource(XAResource xaResource) {
        this.xaResource = xaResource;
        if (this.snapshotUtility.usesTransactionLifecycle() && xaResource == null) {
            throw new JetException("null XA resource set where it was required");
        }
    }

    private void recoverTransaction(Xid xid) throws InterruptedException {
        if (!this.snapshotUtility.usesTransactionLifecycle()) {
            return;
        }
        block8: while (true) {
            try {
                this.xaResource.commit(xid, false);
                this.context.logger().info("Successfully committed restored transaction ID: " + String.valueOf(xid));
            }
            catch (XAException e) {
                switch (e.errorCode) {
                    case 4: {
                        LoggingUtil.logFine(this.context.logger(), "Commit failed with XA_RETRY, will retry in %s ms. XID: %s", 100, xid);
                        Thread.sleep(100L);
                        LoggingUtil.logFine(this.context.logger(), "Retrying commit %s", xid);
                        continue block8;
                    }
                    case 7: {
                        this.context.logger().info("Due to a heuristic decision, the work done on behalf of the specified transaction branch was already committed. Transaction ID: " + String.valueOf(xid));
                        break;
                    }
                    case 6: {
                        this.context.logger().warning("Due to a heuristic decision, the work done on behalf of the restored transaction ID was rolled back. Messages written in that transaction are lost. Ignoring the problem and will continue the job. Transaction ID: " + String.valueOf(xid), this.handleXAException(e, xid));
                        break;
                    }
                    case -4: {
                        LoggingUtil.logFine(this.context.logger(), "Failed to commit XID restored from snapshot: The specified XID is not known to the resource manager. This happens normally when the transaction was committed in phase 2 of the snapshot and can be ignored, but can happen also if the transaction wasn't committed in phase 2 and the RM lost it (in this case data written in it is lost). Transaction ID: %s", xid);
                        break;
                    }
                    default: {
                        throw new JetException("Failed to commit XID restored from the snapshot, XA error code: " + e.errorCode + ". Data loss is possible. Transaction ID: " + String.valueOf(xid) + ", cause: " + String.valueOf(e), this.handleXAException(e, xid));
                    }
                }
            }
            break;
        }
    }

    private void abortTransaction(Xid xid) {
        block3: {
            if (!this.snapshotUtility.usesTransactionLifecycle()) {
                return;
            }
            try {
                this.xaResource.rollback(xid);
            }
            catch (XAException e) {
                if (e.errorCode == -4) break block3;
                LoggingUtil.logFine(this.context.logger(), "Failed to roll back, transaction ID: %s. Error: %s", xid, this.handleXAException(e, xid));
            }
        }
    }

    private XAException handleXAException(XAException e, Xid xid) {
        if (e.getMessage() == null) {
            return new BetterXAException("errorCode=" + e.errorCode + (String)(xid != null ? ", xid=" + String.valueOf(xid) : ""), e.errorCode, e);
        }
        return e;
    }

    private static final class BetterXAException
    extends XAException {
        private static final long serialVersionUID = 1L;

        private BetterXAException(String message, int errorCode, Throwable cause) {
            super(message);
            this.initCause(cause);
            this.errorCode = errorCode;
        }
    }

    private final class XaTransaction
    implements TwoPhaseSnapshotCommitUtility.TransactionalResource<XaTransactionId> {
        private final XaTransactionId xid;
        private boolean ignoreCommit;
        private boolean isAssociated;

        private XaTransaction(XaTransactionId xid) {
            this.xid = xid;
        }

        @Override
        public XaTransactionId id() {
            return this.xid;
        }

        @Override
        public void begin() throws XAException {
            assert (!this.isAssociated) : "already associated";
            try {
                XaSinkProcessorBase.this.xaResource.start(this.xid, 0);
                this.isAssociated = true;
            }
            catch (XAException e) {
                throw XaSinkProcessorBase.this.handleXAException(e, this.xid);
            }
        }

        @Override
        public void endAndPrepare() throws XAException {
            assert (this.isAssociated) : "not associated";
            try {
                XaSinkProcessorBase.this.xaResource.end(this.xid, 0x4000000);
                this.isAssociated = false;
                int res = XaSinkProcessorBase.this.xaResource.prepare(this.xid);
                this.ignoreCommit = res == 3;
            }
            catch (XAException e) {
                throw XaSinkProcessorBase.this.handleXAException(e, this.xid);
            }
        }

        @Override
        public void commit() throws XAException {
            if (!this.ignoreCommit) {
                try {
                    XaSinkProcessorBase.this.xaResource.commit(this.xid, false);
                }
                catch (XAException e) {
                    throw XaSinkProcessorBase.this.handleXAException(e, this.xid);
                }
            }
        }

        @Override
        public void rollback() throws XAException {
            assert (this.isAssociated) : "not associated";
            try {
                XaSinkProcessorBase.this.xaResource.end(this.xid, 0x20000000);
                this.isAssociated = false;
                XaSinkProcessorBase.this.xaResource.rollback(this.xid);
            }
            catch (XAException e) {
                throw XaSinkProcessorBase.this.handleXAException(e, this.xid);
            }
        }

        @Override
        public void release() throws Exception {
            if (this.isAssociated) {
                XaSinkProcessorBase.this.xaResource.end(this.xid, 0x4000000);
            }
        }
    }

    @BinaryInterface
    private static final class XaTransactionId
    extends SerializableXID
    implements TwoPhaseSnapshotCommitUtility.TransactionId {
        private static final int JET_FORMAT_ID = 275827911;
        private static final int OFFSET_JOB_ID = 0;
        private static final int OFFSET_JOB_NAME_HASH = 8;
        private static final int OFFSET_VERTEX_ID_HASH = 16;
        private static final int OFFSET_PROCESSOR_INDEX = 24;
        private static final int OFFSET_TRANSACTION_INDEX = 28;
        private static final int GTRID_LENGTH = 32;

        private XaTransactionId() {
        }

        private XaTransactionId(Processor.Context context, int processorIndex, int transactionIndex) {
            super(275827911, XaTransactionId.createGtrid(context.jobId(), XaTransactionId.stringHash(context.jobConfig().getName()), XaTransactionId.stringHash(context.vertexName()), processorIndex, transactionIndex), new byte[1]);
        }

        private static long stringHash(String string) {
            byte[] bytes = String.valueOf(string).getBytes(StandardCharsets.UTF_8);
            return HashUtil.MurmurHash3_x64_64(bytes, 0, bytes.length);
        }

        private static byte[] createGtrid(long jobId, long jobNameHash, long vertexIdHash, int processorIndex, int transactionIndex) {
            byte[] res = new byte[32];
            Bits.writeLong(res, 0, jobId, true);
            Bits.writeLong(res, 8, jobNameHash, true);
            Bits.writeLong(res, 16, vertexIdHash, true);
            Bits.writeInt(res, 24, processorIndex, true);
            Bits.writeInt(res, 28, transactionIndex, true);
            return res;
        }

        @Override
        public int index() {
            return Bits.readInt(this.getGlobalTransactionId(), 24, true);
        }

        @Override
        public String toString() {
            return XaTransactionId.class.getSimpleName() + "{jobId=" + Util.idToString(Bits.readLong(this.getGlobalTransactionId(), 0, true)) + ", jobNameHash=" + Bits.readLong(this.getGlobalTransactionId(), 8, true) + ", vertexIdHash=" + Bits.readLong(this.getGlobalTransactionId(), 16, true) + ", processorIndex=" + this.index() + ", transactionIndex=" + Bits.readInt(this.getGlobalTransactionId(), 28, true) + "}";
        }
    }
}

