/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.impl.EnterpriseMasterContext;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.JobExecutionRecord;
import com.hazelcast.jet.impl.JobRecord;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.MasterContext;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class EnterpriseJobCoordinationService
extends JobCoordinationService {
    EnterpriseJobCoordinationService(NodeEngineImpl nodeEngine, JetServiceBackend jetServiceBackend, JetConfig config, JobRepository jobRepository) {
        super(nodeEngine, jetServiceBackend, config, jobRepository);
    }

    @Override
    MasterContext createMasterContext(JobRecord jobRecord, JobExecutionRecord jobExecutionRecord) {
        return new EnterpriseMasterContext(this.nodeEngine(), this, jobRecord, jobExecutionRecord);
    }

    @Override
    public EnterpriseMasterContext getMasterContext(long jobId) {
        return (EnterpriseMasterContext)super.getMasterContext(jobId);
    }

    public CompletableFuture<Void> exportSnapshot(long jobId, String name, boolean cancelJob) {
        CompletableFuture<CompletableFuture> future = this.submitToCoordinatorThread(() -> {
            this.assertIsMaster("Cannot export snapshot for job " + Util.idToString(jobId) + " from non-master node");
            EnterpriseMasterContext masterContext = this.getMasterContext(jobId);
            if (masterContext == null) {
                throw new JobNotFoundException("MasterContext not found to export snapshot of job " + Util.idToString(jobId));
            }
            return masterContext.snapshotContext().exportSnapshot(name, cancelJob);
        });
        return future.thenCompose(Function.identity());
    }
}

