/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.dataconnection.DataConnectionService;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.internal.util.RandomPicker;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.JetDataSerializerHook;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.processor.ExpectNothingP;
import com.hazelcast.jet.impl.processor.MetaSupplierFromProcessorSupplier;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.security.PermissionsUtil;
import com.hazelcast.spi.annotation.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface ProcessorMetaSupplier
extends Serializable {
    @Nullable
    default public Permission getRequiredPermission() {
        return null;
    }

    @Nonnull
    default public Map<String, String> getTags() {
        return Collections.emptyMap();
    }

    default public int preferredLocalParallelism() {
        return -1;
    }

    default public void init(@Nonnull Context context) throws Exception {
    }

    default public boolean initIsCooperative() {
        return false;
    }

    @Nonnull
    public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> var1);

    default public boolean closeIsCooperative() {
        return false;
    }

    default public void close(@Nullable Throwable error) throws Exception {
    }

    default public boolean isReusable() {
        return false;
    }

    @Nonnull
    public static ProcessorMetaSupplier of(int preferredLocalParallelism, @Nullable Permission permission, @Nonnull ProcessorSupplier procSupplier) {
        return new MetaSupplierFromProcessorSupplier(preferredLocalParallelism, permission, procSupplier);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(int preferredLocalParallelism, @Nonnull ProcessorSupplier procSupplier) {
        return ProcessorMetaSupplier.of(preferredLocalParallelism, null, procSupplier);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nullable Permission permission, @Nonnull ProcessorSupplier procSupplier) {
        return ProcessorMetaSupplier.of(-1, permission, procSupplier);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull ProcessorSupplier procSupplier) {
        return ProcessorMetaSupplier.of(null, procSupplier);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(int preferredLocalParallelism, @Nonnull SupplierEx<? extends Processor> procSupplier) {
        return ProcessorMetaSupplier.of(preferredLocalParallelism, null, ProcessorSupplier.of(procSupplier));
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull SupplierEx<? extends Processor> procSupplier) {
        return ProcessorMetaSupplier.of(-1, procSupplier);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(final int preferredLocalParallelism, final @Nonnull FunctionEx<? super Address, ? extends ProcessorSupplier> addressToSupplier) {
        Vertex.checkLocalParallelism(preferredLocalParallelism);
        return new ProcessorMetaSupplier(){
            private static final long serialVersionUID = 1L;

            @Override
            public int preferredLocalParallelism() {
                return preferredLocalParallelism;
            }

            @Override
            @Nonnull
            public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
                return addressToSupplier;
            }

            @Override
            public boolean isReusable() {
                return true;
            }

            @Override
            public boolean initIsCooperative() {
                return true;
            }

            @Override
            public boolean closeIsCooperative() {
                return true;
            }
        };
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull FunctionEx<? super Address, ? extends ProcessorSupplier> addressToSupplier) {
        return ProcessorMetaSupplier.of(-1, addressToSupplier);
    }

    @Nonnull
    public static ProcessorMetaSupplier preferLocalParallelismOne(@Nonnull ProcessorSupplier supplier) {
        return ProcessorMetaSupplier.of(1, null, supplier);
    }

    @Nonnull
    public static ProcessorMetaSupplier preferLocalParallelismOne(@Nullable Permission permission, @Nonnull ProcessorSupplier supplier) {
        return ProcessorMetaSupplier.of(1, permission, supplier);
    }

    @Nonnull
    public static ProcessorMetaSupplier preferLocalParallelismOne(@Nonnull SupplierEx<? extends Processor> procSupplier) {
        return ProcessorMetaSupplier.of(1, null, ProcessorSupplier.of(procSupplier));
    }

    @Nonnull
    public static ProcessorMetaSupplier preferLocalParallelismOne(@Nullable Permission permission, @Nonnull SupplierEx<? extends Processor> procSupplier) {
        return ProcessorMetaSupplier.of(1, permission, ProcessorSupplier.of(procSupplier));
    }

    @Nonnull
    public static ProcessorMetaSupplier forceTotalParallelismOne(@Nonnull ProcessorSupplier supplier, @Nullable Permission permission) {
        return ProcessorMetaSupplier.forceTotalParallelismOne(supplier, UuidUtil.newUnsecureUuidString(), permission);
    }

    @Nonnull
    public static ProcessorMetaSupplier forceTotalParallelismOne(@Nonnull ProcessorSupplier supplier) {
        return new SpecificMemberPms(supplier, null);
    }

    @Nonnull
    public static ProcessorMetaSupplier forceTotalParallelismOne(@Nonnull ProcessorSupplier supplier, @Nonnull String partitionKey) {
        return ProcessorMetaSupplier.forceTotalParallelismOne(supplier, partitionKey, null);
    }

    @Nonnull
    public static ProcessorMetaSupplier forceTotalParallelismOne(final @Nonnull ProcessorSupplier supplier, final @Nonnull String partitionKey, final @Nullable Permission permission) {
        return new ProcessorMetaSupplier(){
            private static final long serialVersionUID = 1L;
            private transient Address ownerAddress;

            @Override
            public void init(@Nonnull Context context) {
                PermissionsUtil.checkPermission(supplier, context);
                if (context.localParallelism() != 1) {
                    throw new IllegalArgumentException("Local parallelism of " + context.localParallelism() + " was requested for a vertex that supports only total parallelism of 1. Local parallelism must be 1.");
                }
                String key = StringPartitioningStrategy.getPartitionKey(partitionKey);
                int partitionId = context.hazelcastInstance().getPartitionService().getPartition(key).getPartitionId();
                this.ownerAddress = context.partitionAssignment().entrySet().stream().filter(en -> Util.arrayIndexOf(partitionId, (int[])en.getValue()) >= 0).findAny().map(Map.Entry::getKey).orElseThrow(() -> new RuntimeException("Owner partition not assigned to any participating member"));
            }

            @Nonnull
            public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
                return addr -> addr.equals(this.ownerAddress) ? supplier : count -> Collections.singletonList(new ExpectNothingP());
            }

            @Override
            public int preferredLocalParallelism() {
                return 1;
            }

            @Override
            public Permission getRequiredPermission() {
                return permission;
            }

            @Override
            public boolean initIsCooperative() {
                return true;
            }

            @Override
            public boolean closeIsCooperative() {
                return true;
            }
        };
    }

    @Nonnull
    public static ProcessorMetaSupplier forceTotalParallelismOne(@Nonnull ProcessorSupplier supplier, @Nonnull Address memberAddress) {
        return new SpecificMemberPms(supplier, memberAddress);
    }

    @Nonnull
    @Beta
    public static ProcessorMetaSupplier randomMember(@Nonnull ProcessorSupplier supplier) {
        return new RandomMemberPms(supplier);
    }

    @SerializableByConvention
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="the class is never java-serialized")
    public static class SpecificMemberPms
    implements ProcessorMetaSupplier,
    IdentifiedDataSerializable {
        protected ProcessorSupplier supplier;
        protected Address memberAddress;

        public SpecificMemberPms() {
        }

        protected SpecificMemberPms(ProcessorSupplier supplier, @Nullable Address memberAddress) {
            this.supplier = supplier;
            this.memberAddress = memberAddress;
        }

        @Override
        public void init(@Nonnull Context context) throws Exception {
            PermissionsUtil.checkPermission(this.supplier, context);
            if (context.localParallelism() != 1) {
                throw new IllegalArgumentException("Local parallelism of " + context.localParallelism() + " was requested for a vertex that supports only total parallelism of 1. Local parallelism must be 1.");
            }
        }

        @Override
        public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
            if (this.memberAddress != null && !addresses.contains(this.memberAddress)) {
                throw new JetException("Cluster does not contain the required member: " + String.valueOf(this.memberAddress));
            }
            Address memberAddressToUse = this.memberAddress != null ? this.memberAddress : addresses.get(RandomPicker.getInt(addresses.size()));
            return addr -> addr.equals(memberAddressToUse) ? this.supplier : new ExpectNothingProcessorSupplier();
        }

        @Override
        public int preferredLocalParallelism() {
            return 1;
        }

        @Override
        public boolean isReusable() {
            return true;
        }

        @Override
        public boolean initIsCooperative() {
            return true;
        }

        @Override
        public boolean closeIsCooperative() {
            return true;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject(this.supplier);
            out.writeObject(this.memberAddress);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.supplier = (ProcessorSupplier)in.readObject();
            this.memberAddress = (Address)in.readObject();
        }

        @Override
        public int getFactoryId() {
            return JetDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 20;
        }
    }

    public static class RandomMemberPms
    implements ProcessorMetaSupplier,
    IdentifiedDataSerializable {
        private ProcessorSupplier supplier;

        RandomMemberPms() {
        }

        private RandomMemberPms(ProcessorSupplier supplier) {
            this.supplier = supplier;
        }

        @Override
        public void init(@Nonnull Context context) throws Exception {
            PermissionsUtil.checkPermission(this.supplier, context);
        }

        @Override
        @Nonnull
        public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
            Address memberAddress = addresses.get(RandomPicker.getInt(addresses.size()));
            return addr -> addr.equals(memberAddress) ? this.supplier : new ExpectNothingProcessorSupplier();
        }

        @Override
        public boolean isReusable() {
            return true;
        }

        @Override
        public boolean initIsCooperative() {
            return true;
        }

        @Override
        public boolean closeIsCooperative() {
            return true;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject(this.supplier);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.supplier = (ProcessorSupplier)in.readObject();
        }

        @Override
        public int getFactoryId() {
            return JetDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 21;
        }
    }

    public static interface Context {
        @Nonnull
        public HazelcastInstance hazelcastInstance();

        @Nonnull
        @Deprecated
        public JetInstance jetInstance();

        public long jobId();

        public long executionId();

        @Nonnull
        public JobConfig jobConfig();

        public int totalParallelism();

        public int localParallelism();

        public int memberCount();

        @Nonnull
        public String vertexName();

        @Nonnull
        public ILogger logger();

        default public boolean snapshottingEnabled() {
            return this.processingGuarantee() != ProcessingGuarantee.NONE;
        }

        public ProcessingGuarantee processingGuarantee();

        public long maxProcessorAccumulatedRecords();

        public boolean isLightJob();

        public Map<Address, int[]> partitionAssignment();

        public ClassLoader classLoader();

        public DataConnectionService dataConnectionService();

        public void checkPermission(@Nonnull Permission var1) throws AccessControlException;
    }

    public static class ExpectNothingProcessorSupplier
    implements ProcessorSupplier,
    IdentifiedDataSerializable {
        @Override
        @Nonnull
        public Collection<? extends Processor> get(int count) {
            return IntStream.range(0, count).mapToObj(i -> new ExpectNothingP()).collect(Collectors.toList());
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
        }

        @Override
        public int getFactoryId() {
            return JetDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 19;
        }
    }
}

