/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.config.LicenseKey;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.util.LicenseHelper;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class LicenseExpirationReminderTask
implements Runnable {
    static Factory factory = new DefaultFactory();
    private static final String BANNER_TEMPLATE = "%n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ WARNING @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%nTHIS HAZELCAST LICENSE ID :LICENSE_ID: :EXPIRY_TIME::GRACE_PERIOD:Please contact your Hazelcast Account Executive or%nemail :HAZELCAST_EMAIL:.%nPhone: :HAZELCAST_PHONE_NUMBER:%n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@";
    private final License license;
    private final long expiryInMillis;
    private final TaskScheduler scheduler;
    private boolean cancelRequested;
    private ScheduledFuture<?> future;
    private final ILogger logger = Logger.getLogger(LicenseExpirationReminderTask.class);
    private final long nowInMillis;

    LicenseExpirationReminderTask(TaskScheduler scheduler, License license, long nowInMillis) {
        this.license = license;
        this.expiryInMillis = license.getExpiryDate().toInstant().toEpochMilli();
        this.scheduler = scheduler;
        this.nowInMillis = nowInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long nowInMillis = this.nowInMillis == -1L ? Clock.currentTimeMillis() : this.nowInMillis;
        NotificationPeriod period = NotificationPeriod.NONE;
        try {
            period = this.calculateNotificationPeriod(nowInMillis);
            if (!NotificationPeriod.NONE.equals((Object)period)) {
                this.logger.warning(this.assembleLicenseInfoBanner(period, nowInMillis));
            }
        }
        finally {
            LicenseExpirationReminderTask licenseExpirationReminderTask = this;
            synchronized (licenseExpirationReminderTask) {
                if (!this.cancelRequested) {
                    long rescheduleDelay = this.calcSchedulingDelay(period, nowInMillis);
                    this.future = this.scheduler.schedule(this, rescheduleDelay, TimeUnit.MILLISECONDS);
                    this.logger.fine("Current period " + String.valueOf((Object)period) + ". Rescheduling check, in " + rescheduleDelay + " seconds. Expiration " + String.valueOf(this.license.getExpiryDate()));
                }
            }
        }
    }

    public static LicenseExpirationReminderTask scheduleWith(TaskScheduler scheduler, License license) {
        LicenseExpirationReminderTask task = factory.newInstance(scheduler, license);
        scheduler.schedule(task, 0L, TimeUnit.SECONDS);
        return task;
    }

    public LicenseExpirationReminderTask rescheduleWithNewLicense(License license) {
        this.cancel();
        return license == null ? null : LicenseExpirationReminderTask.scheduleWith(this.scheduler, license);
    }

    private synchronized void cancel() {
        this.cancelRequested = true;
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    NotificationPeriod calculateNotificationPeriod(long nowInMillis) {
        if (this.expiryInMillis <= nowInMillis && this.license.getGracePeriod() > 0) {
            return NotificationPeriod.of(LicenseHelper.getExpiryDateWithGracePeriod(this.license).toInstant().toEpochMilli() - nowInMillis, true);
        }
        return NotificationPeriod.of(this.expiryInMillis - nowInMillis, false);
    }

    String assembleLicenseInfoBanner(NotificationPeriod period, long nowInMillis) {
        return String.format(BANNER_TEMPLATE, new Object[0]).replace(":EXPIRY_TIME:", this.formatExpiryTimeString(nowInMillis)).replace(":HAZELCAST_EMAIL:", "sales@hazelcast.com").replace(":HAZELCAST_PHONE_NUMBER:", "+1 (650) 521-5453").replace(":LICENSE_ID:", LicenseKey.maskLicense(this.license.getKey())).replace(":GRACE_PERIOD:", (CharSequence)(period.isGrace && this.remainingDaysTillGraceEnds(nowInMillis) != -1 ? "You are now in a grace period of " + this.license.getGracePeriod() + " month(s). " + String.format("The license will expire%nin " + this.remainingDaysTillGraceEnds(nowInMillis) + " days time.%n%n", new Object[0]) : ""));
    }

    long calcSchedulingDelay(NotificationPeriod period, long nowInMillis) {
        if (!NotificationPeriod.NONE.equals((Object)period)) {
            return period.notificationInterval;
        }
        long scheduledInMillis = this.expiryInMillis - NotificationPeriod.ADVISORY.limitInMillisBeforePeriodAvails;
        if (scheduledInMillis <= nowInMillis) {
            this.logger.warning(new IllegalStateException("Notification period isn't NONE and tried to schedule in the past. This task will be retried after one day. | NotificationPeriod: " + String.valueOf((Object)period) + " | nowInMillis: " + nowInMillis + " | expiryInMillis: " + this.expiryInMillis + " | license.getGracePeriod(): " + this.license.getGracePeriod()));
            return NotificationPeriod.ADVISORY.notificationInterval;
        }
        return scheduledInMillis - nowInMillis;
    }

    private int remainingDaysTillGraceEnds(long nowInMillis) {
        long diff = LicenseHelper.getExpiryDateWithGracePeriod(this.license).toInstant().toEpochMilli() - nowInMillis;
        return diff > 0L ? (int)TimeUnit.MILLISECONDS.toDays(diff) : -1;
    }

    private String formatExpiryTimeString(long nowInMillis) {
        long diff = this.license.getExpiryDate().toInstant().toEpochMilli() - nowInMillis;
        if (diff <= 0L) {
            return String.format("HAS EXPIRED!%n%n", new Object[0]);
        }
        long days = TimeUnit.MILLISECONDS.toDays(diff);
        if (days > 0L) {
            return String.format("WILL EXPIRE IN %d DAYS.%nYour Hazelcast cluster will stop working on the next re-start after%nexpiry.%n%n", days);
        }
        long hours = TimeUnit.MILLISECONDS.toHours(diff);
        if (hours > 0L) {
            return String.format("WILL EXPIRE IN %d HOURS.%nYour Hazelcast cluster will stop working on the next re-start after%nexpiry.%n%n", hours);
        }
        long minutes = TimeUnit.MILLISECONDS.toMinutes(diff);
        if (minutes > 0L) {
            return String.format("WILL EXPIRE IN %d MINS.%nYour Hazelcast cluster will stop working on the next re-start after%nexpiry.%n%n", minutes);
        }
        return String.format("WILL EXPIRE IN A FEW SECONDS.%nYour Hazelcast cluster will stop working on the next re-start after%nexpiry.%n%n", new Object[0]);
    }

    static enum NotificationPeriod {
        ADVISORY(TimeUnit.DAYS.toMillis(1L), TimeUnit.DAYS.toMillis(60L)),
        WARNING(TimeUnit.HOURS.toMillis(1L), TimeUnit.DAYS.toMillis(30L)),
        ALERT(TimeUnit.MINUTES.toMillis(30L), TimeUnit.DAYS.toMillis(7L)),
        GRACE_WARNING(TimeUnit.HOURS.toMillis(1L), TimeUnit.DAYS.toMillis(30L), true),
        GRACE_ALERT(TimeUnit.MINUTES.toMillis(30L), TimeUnit.DAYS.toMillis(7L), true),
        NONE(-1L, -1L);

        private final long notificationInterval;
        private final long limitInMillisBeforePeriodAvails;
        private final boolean isGrace;

        private NotificationPeriod(long notificationInterval, long limitInMillisBeforePeriodAvails, boolean isGrace) {
            this.notificationInterval = notificationInterval;
            this.limitInMillisBeforePeriodAvails = limitInMillisBeforePeriodAvails;
            this.isGrace = isGrace;
        }

        private NotificationPeriod(long notificationInterval, long limitInMillisBeforePeriodAvails) {
            this(notificationInterval, limitInMillisBeforePeriodAvails, false);
        }

        public long getNotificationInterval() {
            return this.notificationInterval;
        }

        static NotificationPeriod of(long expiryDateInMillis, boolean isGrace) {
            if (expiryDateInMillis <= NotificationPeriod.ALERT.limitInMillisBeforePeriodAvails) {
                return isGrace ? GRACE_ALERT : ALERT;
            }
            if (expiryDateInMillis <= NotificationPeriod.WARNING.limitInMillisBeforePeriodAvails) {
                return isGrace ? GRACE_WARNING : WARNING;
            }
            if (expiryDateInMillis <= NotificationPeriod.ADVISORY.limitInMillisBeforePeriodAvails) {
                return isGrace ? NONE : ADVISORY;
            }
            return NONE;
        }
    }

    @FunctionalInterface
    static interface Factory {
        public LicenseExpirationReminderTask newInstance(TaskScheduler var1, License var2);
    }

    static class DefaultFactory
    implements Factory {
        DefaultFactory() {
        }

        @Override
        public LicenseExpirationReminderTask newInstance(TaskScheduler scheduler, License license) {
            return new LicenseExpirationReminderTask(scheduler, license, -1L);
        }
    }
}

