/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.service.impl;

import com.hazelcast.config.DeviceConfig;
import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.config.TieredStoreConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.tstore.device.DeviceMetrics;
import com.hazelcast.internal.tstore.hybridlog.impl.AggregatedHybridLogImplMetrics;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImplMetrics;
import com.hazelcast.map.impl.EnterpriseMapServiceContext;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.query.impl.IndexRegistry;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.TSGlobalIndexImpl;
import com.hazelcast.query.impl.TSPartitionedIndexImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class TieredStoreServiceImplMetrics {
    private final PerMemberMetrics perMemberMetrics = new PerMemberMetrics();
    private final ConcurrentMap<MapContainer, PerMapMetrics> perMapMetricsMap = new ConcurrentHashMap<MapContainer, PerMapMetrics>();
    private final ConcurrentMap<String, PerDeviceMetrics> perDeviceMetricsMap = new ConcurrentHashMap<String, PerDeviceMetrics>();

    public PerMemberMetrics getPerMemberMetrics() {
        return this.perMemberMetrics;
    }

    public ConcurrentMap<MapContainer, PerMapMetrics> getPerMapMetricsMap() {
        return this.perMapMetricsMap;
    }

    public void registerMap(MapContainer mapContainer, TieredStoreConfig tstoreConfig) {
        this.perMapMetricsMap.computeIfAbsent(mapContainer, name -> new PerMapMetrics(mapContainer.getName(), tstoreConfig));
    }

    public void deregisterMap(MapContainer mapContainer) {
        this.perMapMetricsMap.remove(mapContainer);
    }

    void registerDevice(DeviceConfig deviceConfig) {
        this.perDeviceMetricsMap.computeIfAbsent(deviceConfig.getName(), k -> new PerDeviceMetrics(deviceConfig));
    }

    void clear() {
        this.perMapMetricsMap.clear();
        this.perDeviceMetricsMap.clear();
    }

    void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context, Node node) {
        this.perMapMetricsMap.keySet().forEach(k -> this.provideMapHybridLogMetrics(descriptor, context, (MapContainer)k, node));
        this.perDeviceMetricsMap.values().forEach(m -> m.collect(descriptor, context));
        this.perMemberMetrics.collect(descriptor, context);
    }

    private void provideMapHybridLogMetrics(MetricDescriptor descriptor, MetricsCollectionContext context, MapContainer mapContainer, Node node) {
        if (!node.isRunning()) {
            return;
        }
        InternalPartitionService partitionService = node.getNodeEngine().getPartitionService();
        MapService mapService = (MapService)node.getNodeEngine().getService("hz:impl:mapService");
        EnterpriseMapServiceContext mapServiceContext = (EnterpriseMapServiceContext)mapService.getMapServiceContext();
        PerMapMetrics perMapMetrics = (PerMapMetrics)this.perMapMetricsMap.get(mapContainer);
        PerDeviceMetrics perDeviceMetrics = (PerDeviceMetrics)this.perDeviceMetricsMap.get(perMapMetrics.getDeviceName());
        if (perDeviceMetrics == null) {
            return;
        }
        TieredStoreServiceImplMetrics.provideFromPartitions(mapContainer, descriptor, context, perMapMetrics, partitionService, mapServiceContext);
        if (mapContainer.shouldUseGlobalIndex()) {
            TieredStoreServiceImplMetrics.provideFromGlobalIndexes(mapContainer, descriptor, context, perMapMetrics);
        } else {
            TieredStoreServiceImplMetrics.provideFromPartitionedIndexes(mapContainer, descriptor, context, perMapMetrics, partitionService);
        }
        perMapMetrics.collect(descriptor, context, this.perMemberMetrics, perDeviceMetrics);
    }

    private static void provideFromPartitions(MapContainer mapContainer, MetricDescriptor descriptor, MetricsCollectionContext context, PerMapMetrics metric, InternalPartitionService partitionService, EnterpriseMapServiceContext mapServiceContext) {
        int partitionCount = partitionService.getPartitionCount();
        ArrayList<HybridLogImplMetrics> sourceMetrics = new ArrayList<HybridLogImplMetrics>(partitionCount);
        for (int partition = 0; partition < partitionCount; ++partition) {
            EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)mapServiceContext.getPartitionContainer(partition);
            HybridLogImpl hybridLog = (HybridLogImpl)partitionContainer.getHybridLogOrNull(mapContainer);
            if (hybridLog == null) continue;
            HybridLogImplMetrics hybridLogMetrics = hybridLog.getMetrics();
            DeviceMetrics deviceMetrics = hybridLog.getDevice().getMetrics();
            String hybridLogId = hybridLog.getId();
            sourceMetrics.add(hybridLogMetrics);
            metric.aggregate(deviceMetrics.getDeviceUsageInBytes(), hybridLogMetrics.getHybridLogLengthTotal() - deviceMetrics.getDeletedSizeTotalInBytes());
            if (!partitionService.isPartitionOwner(partition)) continue;
            MetricDescriptor descriptorCopy = descriptor.copy().withDiscriminator("name", mapContainer.getName()).withPrefix("map").withTag("partition", Integer.toString(partition)).withTag("hybridLogId", hybridLogId);
            context.collect(descriptorCopy, hybridLogMetrics);
        }
        MetricDescriptor descriptorCopy = descriptor.copy().withDiscriminator("name", mapContainer.getName()).withPrefix("map");
        TieredStoreServiceImplMetrics.provideAggregatedHybridLogMetrics(context, descriptorCopy, sourceMetrics);
    }

    private static void provideAggregatedHybridLogMetrics(MetricsCollectionContext context, MetricDescriptor descriptor, List<HybridLogImplMetrics> sourceMetrics) {
        AggregatedHybridLogImplMetrics mapHybridLogMetrics = AggregatedHybridLogImplMetrics.aggregate(sourceMetrics);
        context.collect(descriptor, mapHybridLogMetrics);
    }

    private static void provideFromGlobalIndexes(MapContainer mapContainer, MetricDescriptor descriptor, MetricsCollectionContext context, PerMapMetrics metric) {
        IndexRegistry globalIndexRegistry = mapContainer.getGlobalIndexRegistry();
        for (InternalIndex index : globalIndexRegistry.getIndexes()) {
            TSGlobalIndexImpl tsIndex = (TSGlobalIndexImpl)index;
            String indexName = tsIndex.getName();
            HybridLogImpl hybridLog = (HybridLogImpl)tsIndex.getIndexHybridLog();
            String hybridLogId = hybridLog.getId();
            HybridLogImplMetrics hybridLogMetrics = hybridLog.getMetrics();
            DeviceMetrics deviceMetrics = hybridLog.getDevice().getMetrics();
            metric.aggregate(deviceMetrics.getDeviceUsageInBytes(), hybridLogMetrics.getHybridLogLengthTotal() - deviceMetrics.getDeletedSizeTotalInBytes());
            MetricDescriptor descriptorCopy = descriptor.copy().withDiscriminator("name", mapContainer.getName()).withPrefix("map").withTag("index", indexName).withTag("hybridLogId", hybridLogId);
            context.collect(descriptorCopy, hybridLogMetrics);
        }
    }

    private static void provideFromPartitionedIndexes(MapContainer mapContainer, MetricDescriptor descriptor, MetricsCollectionContext context, PerMapMetrics metric, InternalPartitionService partitionService) {
        assert (!mapContainer.shouldUseGlobalIndex());
        String mapName = mapContainer.getName();
        for (int partitionId = 0; partitionId < partitionService.getPartitionCount(); ++partitionId) {
            IndexRegistry partitionedIndexRegistry = mapContainer.getOrNullPartitionedIndexRegistry(partitionId);
            if (partitionedIndexRegistry == null) continue;
            for (InternalIndex index : partitionedIndexRegistry.getIndexes()) {
                TSPartitionedIndexImpl tsIndex = (TSPartitionedIndexImpl)index;
                String indexName = tsIndex.getName();
                HybridLogImpl hybridLog = (HybridLogImpl)tsIndex.getIndexHybridLog();
                String hybridLogId = hybridLog.getId();
                HybridLogImplMetrics hybridLogMetrics = hybridLog.getMetrics();
                DeviceMetrics deviceMetrics = hybridLog.getDevice().getMetrics();
                metric.aggregate(deviceMetrics.getDeviceUsageInBytes(), hybridLogMetrics.getHybridLogLengthTotal() - deviceMetrics.getDeletedSizeTotalInBytes());
                if (!partitionService.isPartitionOwner(partitionId)) continue;
                MetricDescriptor descriptorCopy = descriptor.copy().withDiscriminator("name", mapName).withPrefix("map").withTag("partition", Integer.toString(partitionId)).withTag("index", indexName).withTag("hybridLogId", hybridLogId);
                context.collect(descriptorCopy, hybridLogMetrics);
            }
        }
    }

    public static final class PerMemberMetrics {
        private static final AtomicLongFieldUpdater<PerMemberMetrics> DEVICE_USAGE = AtomicLongFieldUpdater.newUpdater(PerMemberMetrics.class, "deviceUsage");
        private static final AtomicLongFieldUpdater<PerMemberMetrics> HYBRID_LOG_LENGTH = AtomicLongFieldUpdater.newUpdater(PerMemberMetrics.class, "hybridLogLength");
        @Probe(name="tstore.device.node.used", unit=ProbeUnit.BYTES)
        private volatile long deviceUsage;
        @Probe(name="tstore.hlog.ts.length", unit=ProbeUnit.BYTES)
        private volatile long hybridLogLength;
        private volatile long lastSeenHybridLogLength;

        private PerMemberMetrics() {
        }

        private void aggregate(long deviceUsage, long logLength) {
            DEVICE_USAGE.addAndGet(this, deviceUsage);
            HYBRID_LOG_LENGTH.addAndGet(this, logLength);
        }

        private void collect(MetricDescriptor descriptor, MetricsCollectionContext context) {
            context.collect(descriptor.copy(), this);
            this.lastSeenHybridLogLength = HYBRID_LOG_LENGTH.get(this);
            this.deviceUsage = 0L;
            this.hybridLogLength = 0L;
        }

        public long getLastSeenHybridLogLength() {
            return this.lastSeenHybridLogLength;
        }
    }

    public static final class PerMapMetrics {
        private final String mapName;
        private final TieredStoreConfig tstoreConfig;
        @Probe(name="tstore.device.ds.used", unit=ProbeUnit.BYTES)
        private volatile long deviceUsed;
        @Probe(name="tstore.hlog.ds.length", unit=ProbeUnit.BYTES)
        private volatile long logLength;

        private PerMapMetrics(String mapName, TieredStoreConfig tstoreConfig) {
            this.mapName = mapName;
            this.tstoreConfig = tstoreConfig;
        }

        public String getDeviceName() {
            return this.tstoreConfig.getDiskTierConfig().getDeviceName();
        }

        private void aggregate(long deviceUsage, long logLength) {
            this.deviceUsed += deviceUsage;
            this.logLength += logLength;
        }

        private void collect(MetricDescriptor descriptor, MetricsCollectionContext context, PerMemberMetrics perMemberMetrics, PerDeviceMetrics sharedDeviceMetrics) {
            MetricDescriptor descriptorCopy = descriptor.copy().withDiscriminator("name", this.mapName).withPrefix("map");
            context.collect(descriptorCopy, this);
            perMemberMetrics.aggregate(this.deviceUsed, this.logLength);
            sharedDeviceMetrics.aggregate(this.deviceUsed);
            this.deviceUsed = 0L;
            this.logLength = 0L;
        }
    }

    public static final class PerDeviceMetrics {
        private final DeviceConfig deviceConfig;
        @Probe(name="tstore.device.sys.used", unit=ProbeUnit.BYTES)
        private volatile long sysUsedSpace;
        @Probe(name="tstore.device.sys.free", unit=ProbeUnit.BYTES)
        private volatile long sysFreeSpace;
        @Probe(name="tstore.device.sys.capacity", unit=ProbeUnit.BYTES)
        private volatile long sysCapacity;
        @Probe(name="tstore.device.ts.used", unit=ProbeUnit.BYTES)
        private volatile long tsUsedSpace;
        @Probe(name="tstore.device.ts.free", unit=ProbeUnit.BYTES)
        private volatile long tsFreeSpace;
        @Probe(name="tstore.device.ts.capacity", unit=ProbeUnit.BYTES)
        private final long tsCapacity;

        private PerDeviceMetrics(DeviceConfig deviceConfig) {
            this.deviceConfig = deviceConfig;
            if (!deviceConfig.isLocal()) {
                throw new IllegalStateException("Only local devices are supported. " + deviceConfig.getClass().getSimpleName() + " is not a local device configuration.");
            }
            LocalDeviceConfig localDeviceConfig = (LocalDeviceConfig)deviceConfig;
            this.tsCapacity = localDeviceConfig.getCapacity().getUnit().toBytes(localDeviceConfig.getCapacity().getValue());
        }

        private void aggregate(long deviceUsage) {
            this.tsUsedSpace += deviceUsage;
            this.tsFreeSpace = this.tsCapacity - this.tsUsedSpace;
        }

        private void collect(MetricDescriptor descriptor, MetricsCollectionContext context) {
            this.updateSystemMetrics();
            this.updateTstoreMetrics();
            MetricDescriptor withDiscriminator = descriptor.copy().withDiscriminator("name", this.deviceConfig.getName());
            context.collect(withDiscriminator, this);
            this.tsUsedSpace = 0L;
            this.tsFreeSpace = 0L;
        }

        private void updateTstoreMetrics() {
        }

        private void updateSystemMetrics() {
            File baseDir;
            if (!this.deviceConfig.isLocal()) {
                return;
            }
            LocalDeviceConfig localDeviceConfig = (LocalDeviceConfig)this.deviceConfig;
            for (baseDir = localDeviceConfig.getBaseDir(); baseDir != null && !baseDir.exists(); baseDir = baseDir.getParentFile()) {
            }
            if (baseDir == null || !baseDir.exists()) {
                return;
            }
            long usableSpace = baseDir.getUsableSpace();
            long totalSpace = baseDir.getTotalSpace();
            this.sysUsedSpace = totalSpace - usableSpace;
            this.sysFreeSpace = usableSpace;
            this.sysCapacity = totalSpace;
        }
    }
}

