/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.service.impl;

import com.hazelcast.cluster.Member;
import com.hazelcast.config.Config;
import com.hazelcast.config.DeviceConfig;
import com.hazelcast.config.DiskTierConfig;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.TieredStoreConfig;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.TStoreException;
import com.hazelcast.internal.tstore.compaction.CompactionManager;
import com.hazelcast.internal.tstore.compaction.CompactionStats;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.device.DeviceOperationExecutor;
import com.hazelcast.internal.tstore.device.DeviceOperationExecutorImpl;
import com.hazelcast.internal.tstore.device.HybridLogFileHandlePool;
import com.hazelcast.internal.tstore.device.local.LocalStorageDevice;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.HybridLogConfiguration;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.PagePool;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import com.hazelcast.internal.tstore.service.TieredStoreService;
import com.hazelcast.internal.tstore.service.TieredStoreUser;
import com.hazelcast.internal.tstore.service.impl.Escaping;
import com.hazelcast.internal.tstore.service.impl.TieredStoreConfigValidator;
import com.hazelcast.internal.tstore.service.impl.TieredStoreServiceImplMetrics;
import com.hazelcast.internal.util.DirectoryLock;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EnterpriseMapContainer;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.memory.Capacity;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class TieredStoreServiceImpl
implements TieredStoreService,
DynamicMetricsProvider,
LifecycleListener {
    static final String LOGGER_NAME = "TStore:Service";
    private static final boolean DEFAULT_REMOVE_DEVICE_DIR_ON_MEMBER_START = true;
    private static final HazelcastProperty REMOVE_DEVICE_DIR_ON_MEMBER_START = new HazelcastProperty("hazelcast.tiered.store.remove.unexpected.device.dirs.on.member.start", true);
    private static final double HYBRID_LOG_READONLY_PERCENTAGE = 0.1;
    private static final int EPOCH_MAX_THREADS_SUPPORTED = 4 * Runtime.getRuntime().availableProcessors();
    private static final int MAX_DIR_CREATION_ATTEMPTS = 10;
    private final int hybridLogPageSize;
    private final boolean clearDeviceDirOnMemberStart;
    private final Node node;
    private final ILogger logger;
    private final HazelcastProperties properties;
    private final Supplier<MemoryAllocator> memoryAllocatorSupplier;
    private final AtomicInteger storeIdSeq = new AtomicInteger();
    private final ConcurrentMap<String, DeviceOperationExecutor> deviceExecutors;
    private final ConcurrentMap<String, CompactionStats> deviceCompactionStats;
    private final ConcurrentMap<String, CompactionManager> deviceCompactionManagers;
    private final TieredStoreServiceImplMetrics metrics = new TieredStoreServiceImplMetrics();
    private final ConcurrentMap<String, DirectoryLock> locksByDeviceDir = new ConcurrentHashMap<String, DirectoryLock>();
    private volatile Epoch globalEpoch;
    private volatile MemoryAllocator memoryAllocator;
    private volatile PagePool pagePool;
    private boolean forciblyUseGlobalEpoch;
    private UUID uuidToCleanup;

    TieredStoreServiceImpl(Node node, Supplier<MemoryAllocator> memoryAllocatorSupplier) {
        this.node = node;
        this.logger = node.getLogger(LOGGER_NAME);
        this.properties = node.getProperties();
        this.memoryAllocatorSupplier = memoryAllocatorSupplier;
        this.clearDeviceDirOnMemberStart = this.properties.getBoolean(REMOVE_DEVICE_DIR_ON_MEMBER_START);
        this.hybridLogPageSize = (int)MemoryUnit.MEGABYTES.toBytes(this.properties.getInteger(ClusterProperty.TIERED_STORE_HYBRID_LOG_PAGE_SIZE_IN_MEGABYTES));
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Enabling tiered store");
        }
        Config config = node.getConfig();
        TieredStoreConfigValidator.validate(config, this.properties, new NamedConfig[0]);
        this.logMinimumClusterSize(config);
        this.deviceExecutors = MapUtil.createConcurrentHashMap(1);
        this.deviceCompactionStats = MapUtil.createConcurrentHashMap(config.getDeviceConfigs().size());
        this.deviceCompactionManagers = MapUtil.createConcurrentHashMap(config.getDeviceConfigs().size());
        node.hazelcastInstance.getLifecycleService().addLifecycleListener(this);
    }

    @Override
    public void stateChanged(LifecycleEvent event) {
        LifecycleEvent.LifecycleState state = event.getState();
        if (state == LifecycleEvent.LifecycleState.MERGING) {
            this.uuidToCleanup = this.node.getThisUuid();
        } else if (state == LifecycleEvent.LifecycleState.MERGED || state == LifecycleEvent.LifecycleState.MERGE_FAILED) {
            this.uuidToCleanup = null;
        }
    }

    @Override
    public CompactionManager getOrNullCompactionManager(String deviceName) {
        return (CompactionManager)this.deviceCompactionManagers.get(deviceName);
    }

    @Override
    public void validateDynamicConfig(Config config, NamedConfig ... dynamicConfigs) throws InvalidConfigurationException {
        TieredStoreConfigValidator.validate(config, this.node.getProperties(), new NamedConfig[0]);
    }

    public ConcurrentMap<String, CompactionStats> getDeviceCompactionStats() {
        return this.deviceCompactionStats;
    }

    @Override
    public void increaseDeviceCapacity(String deviceName, Capacity newCapacity) {
        if (this.deviceCompactionStats.containsKey(deviceName)) {
            CompactionStats compactionStats = (CompactionStats)this.deviceCompactionStats.get(deviceName);
            compactionStats.increaseDeviceCapacity(newCapacity);
        }
    }

    private void logMinimumClusterSize(Config config) {
        NativeMemoryConfig nativeMemoryConfig = config.getNativeMemoryConfig();
        long totalMemoryRequiredClusterWide = config.getMapConfigs().values().stream().filter(mapConfig -> mapConfig.getTieredStoreConfig().isEnabled()).mapToLong(mapConfig -> (long)(mapConfig.getTotalBackupCount() + 1) * mapConfig.getTieredStoreConfig().getMemoryTierConfig().getCapacity().bytes()).sum();
        double perMemberMemoryUsable = (double)nativeMemoryConfig.getCapacity().bytes() * ((100.0 - (double)nativeMemoryConfig.getMetadataSpacePercentage()) / 100.0) * 0.8;
        int requiredMembers = (int)Math.ceil((double)totalMemoryRequiredClusterWide / perMemberMemoryUsable);
        this.logger.info(String.format("Given the configured '%s' native memory, at least %d members should be in the cluster to prevent out of memory errors caused by tiered store operations", nativeMemoryConfig.getCapacity(), requiredMembers));
    }

    private HybridLogImpl newHybridLog(TieredStoreConfig tieredStoreConfig, TieredStoreUser user, int partitionCount, MapContainer mapContainer, int partitionId) {
        String mapName = mapContainer.getName();
        int partitionDigits = (int)(Math.log10(partitionCount) + 1.0);
        String partitionIdStr = String.format("p%1$" + partitionDigits + "s", partitionId).replace(' ', '0');
        String hybridLogId = user.name().toLowerCase(Locale.ROOT) + File.separator + mapName + File.separator + partitionIdStr;
        Capacity capacity = tieredStoreConfig.getMemoryTierConfig().getCapacity();
        long capacityBytes = capacity.bytes() / 2L;
        long perHybridLogCapacity = capacityBytes / (long)partitionCount;
        Epoch effectiveEpoch = this.getEpoch(mapContainer, partitionId);
        return this.newHybridLog0(tieredStoreConfig, user, effectiveEpoch, mapContainer, mapName, partitionId, partitionIdStr, hybridLogId, perHybridLogCapacity);
    }

    public Epoch getEpoch(MapContainer mapContainer, int partitionId) {
        return this.forciblyUseGlobalEpoch ? this.globalEpoch() : this.localEpoch(mapContainer, partitionId);
    }

    private HybridLogImpl newGlobalIndexHybridLog(TieredStoreConfig tieredStoreConfig, TieredStoreUser user, MapContainer mapContainer, IndexConfig indexConfig, String tag) {
        Capacity capacity = indexConfig.getBTreeIndexConfig().getMemoryTierConfig().getCapacity();
        long capacityBytes = capacity.bytes() / 2L;
        String indexName = indexConfig.getName() + "_" + tag;
        String hybridLogId = user.name().toLowerCase(Locale.ROOT) + File.separator + mapContainer.getName() + File.separator + indexName;
        assert (this.forciblyUseGlobalEpoch);
        Epoch epoch = this.globalEpoch();
        return this.newHybridLog0(tieredStoreConfig, user, epoch, mapContainer, mapContainer.getName() + "_" + indexName, 0, indexName, hybridLogId, capacityBytes);
    }

    private HybridLogImpl newPartitionedIndexHybridLog(TieredStoreConfig tieredStoreConfig, TieredStoreUser user, int partitionCount, MapContainer mapContainer, IndexConfig indexConfig, int partitionId, String tag) {
        String mapName = mapContainer.getName();
        String indexName = indexConfig.getName() + "_" + tag;
        int partitionDigits = (int)(Math.log10(partitionCount) + 1.0);
        String partitionIdStr = String.format("p%1$" + partitionDigits + "s", partitionId).replace(' ', '0');
        String hybridLogId = user.name().toLowerCase(Locale.ROOT) + File.separator + mapName + File.separator + indexName + File.separator + partitionIdStr;
        Capacity capacity = indexConfig.getBTreeIndexConfig().getMemoryTierConfig().getCapacity();
        long capacityBytes = capacity.bytes() / 2L;
        long perHybridLogCapacity = capacityBytes / (long)partitionCount;
        Epoch localEpoch = this.localEpoch(mapContainer, partitionId);
        return this.newHybridLog0(tieredStoreConfig, user, localEpoch, mapContainer, mapName + "_" + indexName, partitionId, partitionIdStr, hybridLogId, perHybridLogCapacity);
    }

    private HybridLogImpl newHybridLog0(TieredStoreConfig tieredStoreConfig, TieredStoreUser user, Epoch epoch, MapContainer mapContainer, String userName, int partitionId, String partitionIdStr, String hybridLogId, long capacityBytes) {
        long desiredReadOnlyCapacity = (long)Math.ceil((double)capacityBytes * 0.1);
        int readOnlyPages = (int)Math.max(desiredReadOnlyCapacity / (long)this.hybridLogPageSize, 1L);
        long desiredMutableCapacity = capacityBytes - desiredReadOnlyCapacity;
        int mutablePages = (int)Math.max(desiredMutableCapacity / (long)this.hybridLogPageSize, 1L);
        HybridLogConfiguration config = new HybridLogConfiguration().setPageSize(this.hybridLogPageSize).setReadOnlyPages(readOnlyPages).setMutablePages(mutablePages);
        MapServiceContext mapServiceContext = this.getMapServiceContext();
        EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)mapServiceContext.getPartitionContainer(partitionId);
        Device device = this.createDevice(tieredStoreConfig.getDiskTierConfig(), user, mapContainer, partitionContainer, partitionIdStr, userName);
        HybridLogImpl hlog = new HybridLogImpl(hybridLogId, config, epoch, this.pagePool, device);
        device.init(hlog);
        return hlog;
    }

    private DirectoryLock acquireDir(LocalDeviceConfig config) {
        String deviceName = config.getName();
        String escapedDeviceName = Escaping.escape(deviceName);
        File baseDir = config.getBaseDir();
        TieredStoreServiceImpl.ensureDirHasCreated(baseDir);
        File[] deviceDirsForNode = baseDir.listFiles(f -> {
            UUID thisNodesUuid = this.node.getThisUuid();
            if (!(f.isDirectory() && UuidUtil.isUUID(f.getName()) && thisNodesUuid.equals(UUID.fromString(f.getName())))) {
                this.logger.fine(f.getAbsolutePath() + " is not a valid TStore directory");
                return false;
            }
            File subDirAsDeviceDir = new File(f, escapedDeviceName);
            boolean directory = subDirAsDeviceDir.isDirectory();
            if (!directory) {
                this.logger.fine("No device directory exists at " + subDirAsDeviceDir.getAbsolutePath() + " for " + deviceName);
            }
            return directory;
        });
        if (deviceDirsForNode == null || deviceDirsForNode.length == 0) {
            return this.newDeviceDirForNode(baseDir, escapedDeviceName);
        }
        File dir = deviceDirsForNode[0];
        File subDirAsDeviceDir = new File(dir, escapedDeviceName);
        this.logger.fine("Trying to lock existing TStore device directory: " + subDirAsDeviceDir.getAbsolutePath());
        DirectoryLock directoryLock = DirectoryLock.lockForDirectory(subDirAsDeviceDir, this.logger);
        this.logger.info("Found existing TStore directory: " + subDirAsDeviceDir.getAbsolutePath());
        return directoryLock;
    }

    public void removeOrLogUnexpectedDeviceDirsOnMemberStart() {
        Map<String, DeviceConfig> deviceConfigs = this.node.getConfig().getDeviceConfigs();
        for (DeviceConfig deviceConfig : deviceConfigs.values()) {
            if (!(deviceConfig instanceof LocalDeviceConfig)) continue;
            this.removeOrLogDeviceDir((LocalDeviceConfig)deviceConfig);
        }
    }

    private void removeOrLogDeviceDir(LocalDeviceConfig config) {
        File baseDir = config.getBaseDir();
        if (!Files.isDirectory(baseDir.toPath(), new LinkOption[0])) {
            return;
        }
        List<String> paths = this.findUnknownMembersNodeUuidDirs(baseDir);
        for (String path : paths) {
            if (this.clearDeviceDirOnMemberStart) {
                this.logger.fine("Trying to delete unknown members dir=" + path);
                File directory = new File(path);
                IOUtil.deleteQuietly(directory);
                continue;
            }
            this.logger.warning("Found unexpected tiered storage directory, it can be a candidate for manual removal=" + path);
        }
    }

    private List<String> findUnknownMembersNodeUuidDirs(File baseDir) {
        ArrayList<String> paths = new ArrayList<String>();
        HashSet<UUID> knownNodeUuids = new HashSet<UUID>();
        Set<Member> knownMembers = this.node.getClusterService().getMembers();
        for (Member member : knownMembers) {
            knownNodeUuids.add(member.getUuid());
        }
        File[] files = baseDir.listFiles();
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (!file.isDirectory() || !UuidUtil.isUUID(fileName) || knownNodeUuids.contains(UUID.fromString(fileName))) continue;
                paths.add(file.getAbsolutePath());
            }
        }
        return paths;
    }

    private DirectoryLock newDeviceDirForNode(File baseDir, String deviceName) {
        String nodeUuidDirName = this.node.getThisUuid().toString();
        File nodeUuidDir = new File(baseDir, nodeUuidDirName);
        TieredStoreServiceImpl.ensureDirHasCreated(nodeUuidDir);
        File subDirAsDeviceDir = new File(nodeUuidDir, deviceName);
        TieredStoreServiceImpl.ensureDirHasCreated(subDirAsDeviceDir);
        this.logger.info("Created new empty TStore directory: " + subDirAsDeviceDir.getAbsolutePath());
        return DirectoryLock.lockForDirectory(subDirAsDeviceDir, this.logger);
    }

    static void ensureDirHasCreated(File dir) {
        if (!(dir.exists() || dir.mkdirs() || dir.exists())) {
            throw new TStoreException("Could not locate or create base directory. Please check filesystem permissions in " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new TStoreException(dir.getAbsolutePath() + " is not a directory!");
        }
    }

    @Nonnull
    private Device createDevice(DiskTierConfig diskTierConfig, TieredStoreUser user, MapContainer mapContainer, EnterprisePartitionContainer partitionContainer, String partitionIdStr, String userName) {
        String name = mapContainer.getName();
        if (!diskTierConfig.isEnabled()) {
            throw new IllegalArgumentException(String.format("Map '%s' is configured for tiered storage, but disk tier store is not enabled. Currently this is not supported, disk tier store must be enabled", name));
        }
        String deviceName = diskTierConfig.getDeviceName();
        LocalDeviceConfig localDeviceConfig = (LocalDeviceConfig)this.node.getConfig().getDeviceConfig(deviceName);
        assert (localDeviceConfig != null) : "must have a matching localDeviceConfig for " + deviceName;
        File baseDir = this.locksByDeviceDir.computeIfAbsent(deviceName, deviceNameAsKey -> this.acquireDir(localDeviceConfig)).getDir();
        CompactionManager compactionManager = this.deviceCompactionManagers.computeIfAbsent(deviceName, deviceNameAsKey -> this.createCompactionManager());
        CompactionStats compactionStats = this.deviceCompactionStats.computeIfAbsent(deviceName, deviceNameAsKey -> this.createCompactionStats(localDeviceConfig, compactionManager));
        DeviceOperationExecutor deviceOperationExecutor = this.deviceExecutors.computeIfAbsent(deviceName, deviceNameAsKey -> this.createDeviceOperationExecutor(localDeviceConfig));
        this.metrics.registerDevice(localDeviceConfig);
        File storePath = Paths.get(baseDir.getAbsolutePath(), user.name().toLowerCase(), Escaping.escape(userName), partitionIdStr).toFile();
        for (int attempt = 0; attempt < 10 && !storePath.exists(); ++attempt) {
            if (!storePath.mkdirs() || !this.logger.isFineEnabled()) continue;
            this.logger.fine(String.format("Created directory '%s'", storePath));
        }
        if (!storePath.exists()) {
            throw new TStoreException(String.format("Unable to create directory '%s'", storePath));
        }
        int storeId = this.storeIdSeq.incrementAndGet();
        HybridLogFileHandlePool hybridLogFileHandlePool = partitionContainer.getOrCreateHandlePool(mapContainer);
        int partitionId = partitionContainer.getPartitionId();
        LocalStorageDevice device = new LocalStorageDevice(storeId, new TStoreUserId(user, userName), localDeviceConfig, this.hybridLogPageSize, storePath, hybridLogFileHandlePool, deviceOperationExecutor, compactionStats, partitionId, true, this.properties);
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Added local device '" + localDeviceConfig.getName() + "' with path '" + String.valueOf(localDeviceConfig.getBaseDir()) + "'");
        }
        return device;
    }

    @Override
    @Nonnull
    public Epoch globalEpoch() {
        assert (this.forciblyUseGlobalEpoch);
        return this.globalEpoch;
    }

    Epoch localEpoch(MapContainer mapContainer, int partitionId) {
        assert (!this.forciblyUseGlobalEpoch);
        MapServiceContext mapServiceContext = this.getMapServiceContext();
        EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)mapServiceContext.getPartitionContainer(partitionId);
        return partitionContainer.getOrCreateLocalEpoch(mapContainer);
    }

    @Nonnull
    private DeviceOperationExecutorImpl createDeviceOperationExecutor(LocalDeviceConfig localDeviceConfig) {
        return new DeviceOperationExecutorImpl(localDeviceConfig.getWriteIOThreadCount(), localDeviceConfig.getReadIOThreadCount(), localDeviceConfig.getBlockSize(), this.hybridLogPageSize, localDeviceConfig.getName(), this.node.hazelcastInstance.getName());
    }

    @Override
    @Nonnull
    public HybridLog createHybridLog(TieredStoreUser user, MapContainer mapContainer, int partitionId) {
        int partitionCount = this.node.getNodeEngine().getPartitionService().getPartitionCount();
        TieredStoreConfig tstoreConfig = mapContainer.getMapConfig().getTieredStoreConfig();
        HybridLogImpl hybridLog = this.newHybridLog(tstoreConfig, user, partitionCount, mapContainer, partitionId);
        this.addRootDirPathToMapContainer(mapContainer, hybridLog);
        return hybridLog;
    }

    private void addRootDirPathToMapContainer(MapContainer mapContainer, HybridLogImpl hybridLog) {
        File storeDirPath = ((LocalStorageDevice)hybridLog.getDevice()).getStoreDirPath();
        String rootPath = storeDirPath.getParent();
        ((EnterpriseMapContainer)mapContainer).addToTieredStoreIMapDirPaths(rootPath);
    }

    @Override
    @Nonnull
    public HybridLog createGlobalIndexHybridLog(TieredStoreUser user, MapContainer mapContainer, IndexConfig indexConfig, String tag) {
        TieredStoreConfig tieredStoreConfig = mapContainer.getMapConfig().getTieredStoreConfig();
        HybridLogImpl hybridLog = this.newGlobalIndexHybridLog(tieredStoreConfig, user, mapContainer, indexConfig, tag);
        this.addRootDirPathToMapContainer(mapContainer, hybridLog);
        return hybridLog;
    }

    @Override
    @Nonnull
    public HybridLog createPartitionedIndexHybridLog(TieredStoreUser user, MapContainer mapContainer, IndexConfig indexConfig, int partitionId, String tag) {
        int partitionCount = this.node.getNodeEngine().getPartitionService().getPartitionCount();
        TieredStoreConfig tieredStoreConfig = mapContainer.getMapConfig().getTieredStoreConfig();
        HybridLogImpl hybridLog = this.newPartitionedIndexHybridLog(tieredStoreConfig, user, partitionCount, mapContainer, indexConfig, partitionId, tag);
        this.addRootDirPathToMapContainer(mapContainer, hybridLog);
        return hybridLog;
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.forciblyUseGlobalEpoch = this.getMapServiceContext().isForciblyEnabledGlobalIndex();
        this.memoryAllocator = this.memoryAllocatorSupplier.get();
        assert (this.memoryAllocator instanceof HazelcastMemoryManager);
        HazelcastMemoryManager memoryManager = (HazelcastMemoryManager)this.memoryAllocator;
        this.pagePool = new PagePool(memoryManager.getTieredStoreAllocator(), this.hybridLogPageSize, 1);
        if (this.forciblyUseGlobalEpoch) {
            this.globalEpoch = this.createEpoch();
        }
        ((NodeEngineImpl)nodeEngine).getMetricsRegistry().registerDynamicMetricsProvider(this);
    }

    public Epoch createEpoch() {
        return new Epoch(EPOCH_MAX_THREADS_SUPPORTED, ((HazelcastMemoryManager)this.memoryAllocator).getSystemAllocator());
    }

    private CompactionStats createCompactionStats(DeviceConfig deviceConfig, CompactionManager compactionManager) {
        return new CompactionStats(compactionManager, deviceConfig.getCapacity().bytes(), this.partitionCount(), this.properties);
    }

    private CompactionManager createCompactionManager() {
        return new CompactionManager(this.partitionCount(), this.properties, this.node.hazelcastInstance.getName());
    }

    private int partitionCount() {
        HazelcastProperties properties = this.node.getProperties();
        return properties.getInteger(ClusterProperty.PARTITION_COUNT);
    }

    @Override
    public void reset() {
        this.memoryAllocator = this.memoryAllocatorSupplier.get();
        assert (this.memoryAllocator instanceof HazelcastMemoryManager);
        HazelcastMemoryManager memoryManager = (HazelcastMemoryManager)this.memoryAllocator;
        if (this.forciblyUseGlobalEpoch) {
            this.globalEpoch = new Epoch(EPOCH_MAX_THREADS_SUPPORTED, memoryManager.getSystemAllocator());
        }
        this.locksByDeviceDir.values().forEach(DirectoryLock::release);
        this.locksByDeviceDir.clear();
        if (this.uuidToCleanup != null) {
            String uuid = this.uuidToCleanup.toString();
            this.uuidToCleanup = null;
            Map<String, DeviceConfig> deviceConfigs = this.node.getConfig().getDeviceConfigs();
            for (DeviceConfig deviceConfig : deviceConfigs.values()) {
                if (!(deviceConfig instanceof LocalDeviceConfig)) continue;
                LocalDeviceConfig localDeviceConfig = (LocalDeviceConfig)deviceConfig;
                String baseDir = localDeviceConfig.getBaseDir().getAbsolutePath();
                try {
                    IOUtil.delete(Paths.get(baseDir, uuid));
                }
                catch (Throwable t) {
                    this.logger.warning("Failed to delete node t-store directory", t);
                }
            }
        }
    }

    private MapServiceContext getMapServiceContext() {
        MapService mapService = (MapService)this.node.getNodeEngine().getService("hz:impl:mapService");
        return mapService.getMapServiceContext();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.deviceExecutors.values().forEach(DeviceOperationExecutor::shutdown);
        this.deviceExecutors.clear();
        this.deviceCompactionManagers.values().forEach(CompactionManager::terminate);
        this.deviceCompactionManagers.clear();
        this.deviceCompactionStats.clear();
        this.metrics.clear();
        if (this.globalEpoch != null) {
            assert (this.forciblyUseGlobalEpoch);
            this.globalEpoch.close();
        }
        if (this.pagePool != null) {
            this.pagePool.close();
        }
        this.locksByDeviceDir.values().forEach(DirectoryLock::release);
        this.removeNodeUuidDirs();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Tiered store shutdown is completed");
        }
    }

    private void removeNodeUuidDirs() {
        String thisNodesUuid = this.node.getThisUuid().toString();
        Map<String, DeviceConfig> deviceConfigs = this.node.getConfig().getDeviceConfigs();
        for (DeviceConfig deviceConfig : deviceConfigs.values()) {
            if (!(deviceConfig instanceof LocalDeviceConfig)) continue;
            String baseDir = ((LocalDeviceConfig)deviceConfig).getBaseDir().getAbsolutePath();
            IOUtil.deleteQuietly(Paths.get(baseDir, thisNodesUuid).toFile());
        }
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        this.metrics.provideDynamicMetrics(descriptor, context, this.node);
    }

    public Node getNode() {
        return this.node;
    }

    public TieredStoreServiceImplMetrics getMetrics() {
        return this.metrics;
    }

    public long getEpochAndPagePoolNativeCommit() {
        return this.pagePool.nativeMemoryConsumptionBytes() + (this.globalEpoch != null ? this.globalEpoch.nativeMemoryConsumptionBytes() : 0L);
    }
}

