/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.tstore.hybridlog.LogicalAddressSource;
import com.hazelcast.internal.tstore.hybridlog.PinType;
import com.hazelcast.internal.tstore.hybridlog.TieredStoreWorkingSet;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.PageMetadata;
import com.hazelcast.internal.tstore.hybridlog.impl.PagePinnedOffsets;
import com.hazelcast.internal.tstore.hybridlog.impl.Pager;
import com.hazelcast.internal.tstore.hybridlog.impl.TStoreUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;

class TieredStoreWorkingSetImpl
implements TieredStoreWorkingSet {
    private final ILogger logger = Logger.getLogger(TieredStoreWorkingSetImpl.class);
    private final AtomicBoolean spinLock = new AtomicBoolean();
    private final HybridLogImpl log;
    private final Pager pager;
    private final boolean finestEnabled;
    private volatile boolean open = true;

    TieredStoreWorkingSetImpl(HybridLogImpl log) {
        this.log = Objects.requireNonNull(log);
        this.pager = log.pager;
        this.finestEnabled = this.logger.isFinestEnabled();
    }

    @Override
    public boolean pin(long logicalAddress, PinType pinType, BooleanSupplier pagePinStateCallback) {
        PageMetadata pageMetadata = this.pager.pageMetadata(logicalAddress);
        return this.pin(logicalAddress, pageMetadata, pinType, pagePinStateCallback);
    }

    @Override
    public boolean pin(LogicalAddressSource logicalAddressSource, PinType pinType, BooleanSupplier pagePinStateCallback) {
        return this.pin(logicalAddressSource.getLogicalAddress(), pinType, pagePinStateCallback);
    }

    private boolean pin(long logicalAddress, PageMetadata pageMetadata, PinType pinType, BooleanSupplier pagePinStateCallback) {
        PagePinnedOffsets pagePinnedOffsets = pageMetadata.pinnedOffsets();
        if (this.pager.pageOf(logicalAddress) != pageMetadata.page()) {
            return false;
        }
        int offset = this.pager.offsetOf(logicalAddress);
        boolean releasedSpinLock = false;
        this.spinLock();
        try {
            int pinnedOffsetsBefore = pagePinnedOffsets.size();
            int pinCounter = pagePinnedOffsets.pinOffset(offset, pinType);
            int pinnedOffsetsAfter = pagePinnedOffsets.size();
            boolean pagePinnedAfter = pagePinnedOffsets.isAnyOffsetPinned();
            assert (pagePinnedAfter) : TStoreUtil.loggingAssertMessage(this.logger, "Page is not pinned after calling pinOffset", new Object[0]);
            boolean pageStatePinned = pagePinStateCallback.getAsBoolean();
            if (!pageStatePinned) {
                pagePinnedOffsets.unpinOffset(offset, pinType);
            }
            pagePinnedAfter = pagePinnedOffsets.isAnyOffsetPinned();
            if (this.finestEnabled) {
                this.releaseSpinLock();
                releasedSpinLock = true;
                if (pageStatePinned) {
                    this.logger.finest(this.log.debugPrologue() + " - '" + String.valueOf((Object)pinType) + "' pinned " + this.pager.prettyFormat(logicalAddress) + " on " + String.valueOf(pageMetadata) + " new counter: " + pinnedOffsetsAfter + ", total pinned offsets before: " + pinnedOffsetsBefore + ", total pinned offsets after: " + pinnedOffsetsAfter + ", pagePinnedAfter: " + pagePinnedAfter);
                } else {
                    this.logger.finest(this.log.debugPrologue() + " - Couldn't '" + String.valueOf((Object)pinType) + "' pin " + this.pager.prettyFormat(logicalAddress) + " on " + String.valueOf(pageMetadata) + " new counter: " + pinCounter + ", total pinned offsets before: " + pinnedOffsetsBefore + ", total pinned offsets after: " + pinnedOffsetsAfter + ", pagePinnedAfter: " + pagePinnedAfter);
                }
            }
            boolean bl = pageStatePinned;
            return bl;
        }
        catch (Exception e) {
            this.releaseSpinLock();
            releasedSpinLock = true;
            String message = "Unexpected error while pinning " + this.pager.prettyFormat(logicalAddress) + " for '" + String.valueOf((Object)pinType) + "'. Page's pinType: '" + String.valueOf((Object)pagePinnedOffsets.pagePinType()) + "', address's pinType: '" + String.valueOf((Object)pagePinnedOffsets.pinType(offset)) + "', pageMetadata: " + String.valueOf(pageMetadata) + ". Cause message: " + e.getMessage();
            this.logger.severe(message, new RuntimeException("Just for logging"));
            throw new IllegalStateException(message, e);
        }
        finally {
            if (!releasedSpinLock) {
                this.releaseSpinLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpin(long logicalAddress, PinType pinType, BiConsumer<PinType, PinType> newPagePinTypeCallback) {
        PageMetadata pageMetadata = this.pager.pageMetadata(logicalAddress);
        PagePinnedOffsets pagePinnedOffsets = this.pagePins(pageMetadata.page());
        int offset = this.pager.offsetOf(logicalAddress);
        boolean releasedSpinLock = false;
        this.spinLock();
        try {
            int pinCounter;
            PinType pinTypeBefore = pagePinnedOffsets.pagePinType();
            int pinnedOffsetsBefore = 0;
            boolean offsetPinnedBefore = false;
            if (this.finestEnabled) {
                pinnedOffsetsBefore = pagePinnedOffsets.size();
                offsetPinnedBefore = pagePinnedOffsets.isOffsetPinned(offset);
            }
            if (-2 == (pinCounter = pagePinnedOffsets.unpinOffset(offset, pinType))) {
                this.releaseSpinLock();
                releasedSpinLock = true;
                throw new IllegalArgumentException(this.log.debugPrologue() + " - Logical address " + this.pager.prettyFormat(logicalAddress) + " with page metadata " + String.valueOf(this.pager.pageMetadata(logicalAddress)) + " is not pinned and can't be unpinned.");
            }
            PinType pinTypeAfter = pagePinnedOffsets.pagePinType();
            if (pinTypeBefore != pinTypeAfter) {
                newPagePinTypeCallback.accept(pinTypeBefore, pinTypeAfter);
            }
            if (this.finestEnabled) {
                int pinnedOffsetsAfter = pagePinnedOffsets.size();
                this.releaseSpinLock();
                releasedSpinLock = true;
                this.logger.finest(this.log.debugPrologue() + " - '" + String.valueOf((Object)pinType) + "' unpinned " + this.pager.prettyFormat(logicalAddress) + " on " + String.valueOf(pageMetadata) + ". New counter: " + pinCounter + ", offset pinned before: " + offsetPinnedBefore + ", total pinned offsets before: " + pinnedOffsetsBefore + ", total pinned offsets after: " + pinnedOffsetsAfter + ", pinTypeBefore: " + String.valueOf((Object)pinTypeBefore) + ", pinTypeAfter: " + String.valueOf((Object)pinTypeAfter));
            }
        }
        finally {
            if (!releasedSpinLock) {
                this.releaseSpinLock();
            }
        }
    }

    @Override
    public void unpin(LogicalAddressSource logicalAddressSource, PinType pinType, BiConsumer<PinType, PinType> newPagePinTypeCallback) {
        this.unpin(logicalAddressSource.getLogicalAddress(), pinType, newPagePinTypeCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLogicalAddressPinned(long logicalAddress) {
        this.spinLock();
        try {
            boolean bl = this.pagePins(logicalAddress).isOffsetPinned(this.pager.offsetOf(logicalAddress));
            return bl;
        }
        finally {
            this.releaseSpinLock();
        }
    }

    @Override
    public void close() throws Exception {
        this.spinLock();
        try {
            this.closeInternal();
        }
        finally {
            this.releaseSpinLock();
        }
    }

    boolean isPagePinned(int page) {
        this.spinLock();
        try {
            boolean bl = this.pagePins(page).isAnyOffsetPinned();
            return bl;
        }
        finally {
            this.releaseSpinLock();
        }
    }

    private void closeInternal() {
        this.open = false;
    }

    private PagePinnedOffsets pagePins(long logicalAddress) {
        return this.pagePins(this.pager.pageOf(logicalAddress));
    }

    private PagePinnedOffsets pagePins(int page) {
        return this.pager.pageMetadata(page).pinnedOffsets();
    }

    private void spinLock() {
        while (this.open && !this.spinLock.compareAndSet(false, true)) {
            Thread.yield();
        }
        if (!this.open) {
            throw new IllegalStateException("The working set is closed");
        }
    }

    private void releaseSpinLock() {
        this.spinLock.set(false);
    }
}

