/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.NativeMemoryPool;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class PagePool
extends NativeMemoryPool {
    private final String allocatorSimpleName;

    public PagePool(MemoryAllocator allocator, int pageSize, int preAllocatedPages) {
        super(new MemoryAllocatorWrapper(allocator), pageSize, preAllocatedPages);
        this.allocatorSimpleName = allocator.getClass().getSimpleName();
    }

    @Override
    public void close() {
        super.close();
        Invariants.equals(0L, this.nativeMemoryConsumptionBytes(), "PagePool has been disposed, native memory consumption by this PagePool instance should be zero. Is there a memory leak?");
    }

    public long nativeMemoryConsumptionBytes() {
        return ((MemoryAllocatorWrapper)this.getAllocator()).nativeMemoryConsumptionBytes();
    }

    public String debugInfo() {
        return "PagePool\n" + "\t\t - Memory allocator: " + this.allocatorSimpleName + '\n' + "\t\t - Page size: " + this.getBlockSize() + " bytes" + '\n' + "\t\t - Pool size: " + this.getSize() + '\n' + "\t\t - Native memory consumption: " + this.nativeMemoryConsumptionBytes() + " bytes" + '\n';
    }

    private static class MemoryAllocatorWrapper
    implements MemoryAllocator {
        private static final AtomicLongFieldUpdater<MemoryAllocatorWrapper> MEMORY_CONSUMPTION_BYTES = AtomicLongFieldUpdater.newUpdater(MemoryAllocatorWrapper.class, "memoryConsumptionBytes");
        private final MemoryAllocator allocator;
        private volatile long memoryConsumptionBytes;

        MemoryAllocatorWrapper(MemoryAllocator delegate) {
            this.allocator = delegate;
        }

        @Override
        public long allocate(long size) {
            long address = this.allocator.allocate(size);
            MEMORY_CONSUMPTION_BYTES.addAndGet(this, size);
            return address;
        }

        @Override
        public long reallocate(long address, long currentSize, long newSize) {
            long newAddress = this.allocator.reallocate(address, currentSize, newSize);
            MEMORY_CONSUMPTION_BYTES.addAndGet(this, newSize - currentSize);
            return newAddress;
        }

        @Override
        public void free(long address, long size) {
            this.allocator.free(address, size);
            MEMORY_CONSUMPTION_BYTES.addAndGet(this, -size);
        }

        @Override
        public void dispose() {
            throw new UnsupportedOperationException("allocator is a dependency for the pool, it should be disposed externally");
        }

        long nativeMemoryConsumptionBytes() {
            return MEMORY_CONSUMPTION_BYTES.get(this);
        }
    }
}

