/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.tstore.hybridlog.impl.PageMetadata;
import com.hazelcast.internal.tstore.hybridlog.impl.PageState;
import com.hazelcast.internal.tstore.hybridlog.impl.TStoreUtil;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.MutableInteger;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

class PageMetadataStore {
    private final AtomicReferenceArray<PageMetadata> pageMetadata;
    private final Queue<PageMetadata> metadataQueue = new ConcurrentLinkedDeque<PageMetadata>();
    private final int capacity;
    private final ConcurrentHashMap<Integer, PageMetadata> detachedPageMetadata = new ConcurrentHashMap();
    private final ILogger logger = Logger.getLogger(PageMetadataStore.class);
    private final boolean finestEnabled;

    PageMetadataStore(int capacity) {
        this.pageMetadata = new AtomicReferenceArray(capacity);
        this.capacity = capacity;
        for (int i = 0; i < capacity; ++i) {
            this.pageMetadata.set(i, this.newBlankPageMetadata());
        }
        this.finestEnabled = this.logger.isFinestEnabled();
    }

    PageMetadata pageMetadata(int page) {
        PageMetadata metadata = this.pageMetadataNoDetached(page);
        if (metadata.page() == page) {
            return metadata;
        }
        PageMetadata detachedMetadata = this.detachedPageMetadata.get(page);
        return detachedMetadata != null ? detachedMetadata : metadata;
    }

    PageMetadata pageMetadataNoDetached(int page) {
        return this.pageMetadata.get(this.pageIndex(page));
    }

    void prepareForRetiring(PageMetadata pageMetadata) {
        if (this.finestEnabled) {
            this.logger.finest("Preparing " + String.valueOf(pageMetadata) + " for retiring");
        }
        int page = pageMetadata.page();
        PageMetadata blankPageMetadata = this.newBlankPageMetadata();
        boolean replaced = this.pageMetadata.compareAndSet(this.pageIndex(page), pageMetadata, blankPageMetadata);
        if (this.finestEnabled) {
            this.logger.finest((replaced ? "Replaced slot " : "Didn't replace slot ") + this.pageIndex(page) + " " + String.valueOf(pageMetadata) + " -> " + String.valueOf(blankPageMetadata));
        }
    }

    void finishUpRetiring(PageMetadata pageMetadata) {
        int page = pageMetadata.page();
        PageState state = pageMetadata.state();
        if (state != PageState.NOT_BACKED) {
            return;
        }
        assert (page != -1) : TStoreUtil.loggingAssertMessage(this.logger, "The provided %s is in unexpected state", pageMetadata);
        assert (state == PageState.NOT_BACKED) : TStoreUtil.loggingAssertMessage(this.logger, "The provided %s is in unexpected state", pageMetadata);
        if (pageMetadata.release()) {
            this.metadataQueue.offer(pageMetadata);
        }
    }

    boolean detachPage(PageMetadata pageMetadata) {
        int page = pageMetadata.page();
        PageMetadata metadata = this.pageMetadata(page);
        if (metadata.page() != page) {
            return false;
        }
        if (this.finestEnabled) {
            this.logger.finest("Detaching " + String.valueOf(pageMetadata));
        }
        if (this.detachedPageMetadata.putIfAbsent(page, metadata) == null) {
            PageMetadata blankPageMetadata = this.newBlankPageMetadata();
            int pageIndex = this.pageIndex(page);
            boolean replaced = this.pageMetadata.compareAndSet(pageIndex, pageMetadata, blankPageMetadata);
            if (replaced) {
                if (this.finestEnabled) {
                    this.logger.finest("Replaced slot " + pageIndex + " " + String.valueOf(pageMetadata) + " -> " + String.valueOf(blankPageMetadata));
                }
            } else {
                throw new IllegalStateException("Couldn't replace slot " + pageIndex + " " + String.valueOf(pageMetadata) + " -> " + String.valueOf(blankPageMetadata));
            }
            return true;
        }
        return false;
    }

    boolean removeDetachedPage(PageMetadata pageMetadata) {
        if (this.finestEnabled) {
            this.logger.finest("Removing detached " + String.valueOf(pageMetadata));
        }
        return this.detachedPageMetadata.remove(pageMetadata.page()) != null;
    }

    void foreach(Consumer<PageMetadata> pageMetadataConsumer) {
        for (int pageIndex = 0; pageIndex < this.capacity; ++pageIndex) {
            pageMetadataConsumer.accept(this.pageMetadata.get(pageIndex));
        }
    }

    void foreach(BiConsumer<PageMetadata, Integer> pageMetadataConsumer) {
        for (int pageIndex = 0; pageIndex < this.capacity; ++pageIndex) {
            pageMetadataConsumer.accept(this.pageMetadata.get(pageIndex), pageIndex);
        }
    }

    void foreachDetached(BiConsumer<PageMetadata, Boolean> pageMetadataConsumer) {
        MutableInteger count = new MutableInteger();
        this.detachedPageMetadata.values().stream().map(metadata -> BiTuple.of(metadata, count.value++ == 0)).forEach(tuple -> pageMetadataConsumer.accept((PageMetadata)tuple.element1(), (Boolean)tuple.element2()));
    }

    String prettyFormatPage(PageMetadata pageMetadata, int page) {
        return "page " + page + " with " + String.valueOf(pageMetadata != null ? pageMetadata : "'null'");
    }

    @Nonnull
    private PageMetadata newBlankPageMetadata() {
        PageMetadata metadataFromQueue = this.metadataQueue.poll();
        if (metadataFromQueue != null) {
            if (this.finestEnabled) {
                this.logger.finest("Taken " + String.valueOf(metadataFromQueue) + " from metadata queue");
            }
            metadataFromQueue.reset();
            return metadataFromQueue;
        }
        return new PageMetadata();
    }

    int pageIndex(int page) {
        return page % this.capacity;
    }
}

