/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.tstore.Epoch;
import java.util.function.LongConsumer;

class MultiStageEpochAction
implements Epoch.Action {
    private volatile Node node;
    private volatile boolean complete;

    MultiStageEpochAction() {
    }

    MultiStageEpochAction(LongConsumer firstStage) {
        this.node = new Node(firstStage, null);
    }

    void addStage(LongConsumer stage) {
        if (this.complete) {
            throw new IllegalStateException("The instance is already complete, no more stages can be added");
        }
        this.node = new Node(stage, this.node);
    }

    @Override
    public void run(int threadIndex, long actionEpoch) {
        this.complete = true;
        Node n = this.node;
        if (n == null) {
            return;
        }
        this.node = null;
        while (n.next != null) {
            n.next.prev = n;
            n = n.next;
        }
        while (n != null) {
            n.stage.accept(actionEpoch);
            n = n.prev;
        }
    }

    private static class Node {
        final LongConsumer stage;
        final Node next;
        Node prev;

        Node(LongConsumer stage, Node next) {
            this.stage = stage;
            this.next = next;
        }
    }
}

