/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAddressTranslator;
import com.hazelcast.internal.tstore.hybridlog.CloseableIterator;
import com.hazelcast.internal.tstore.hybridlog.HybridLogIteratorType;
import com.hazelcast.internal.tstore.hybridlog.InMemorySlotAccessor;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.PageHeaderSupport;
import com.hazelcast.internal.tstore.hybridlog.impl.Pager;
import com.hazelcast.internal.tstore.hybridlog.impl.TStoreUtil;
import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.internal.util.concurrent.IdleStrategy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.memory.MemoryUnit;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LogBasedHybridLogIterator<P, E>
implements CloseableIterator<E> {
    private static final int UNINITIALIZED = -1;
    private final HybridLogImpl log;
    private final HybridLogAccessor logAccessor;
    private final Pager pager;
    private final InMemorySlotAccessor<P, E> slotAccessor;
    private final HybridLogIteratorType type;
    private final long startLogicalAddress;
    private final long endLogicalAddress;
    private final IdleStrategy idleStrategy = new BackoffIdleStrategy(1000L, 100L, 100L, 10000L);
    private final ILogger logger;
    private final boolean fineEnabled;
    private boolean closed;
    private long nextLogicalAddress;
    private E nextElement;
    private final LogBasedHybridLogIteratorMetrics metrics;

    public LogBasedHybridLogIterator(HybridLogImpl log, long startLogicalAddress, InMemorySlotAccessor<P, E> slotAccessor, HybridLogIteratorType type) {
        this(log, startLogicalAddress, log.lastAllocatedAddress(), slotAccessor, type);
    }

    public LogBasedHybridLogIterator(HybridLogImpl log, long startLogicalAddress, long endLogicalAddress, InMemorySlotAccessor<P, E> slotAccessor, HybridLogIteratorType type) {
        this.log = log;
        this.logAccessor = new HybridLogAccessor(log);
        this.pager = log.pager;
        this.type = type;
        this.slotAccessor = slotAccessor;
        this.startLogicalAddress = startLogicalAddress;
        this.nextLogicalAddress = -1L;
        this.endLogicalAddress = endLogicalAddress;
        this.logger = Logger.getLogger("TStore:HLog:Iterator");
        this.metrics = new LogBasedHybridLogIteratorMetrics(this.pager.pageSize);
        this.fineEnabled = this.logger.isFineEnabled();
        if (this.fineEnabled) {
            this.logger.fine("Created iterator with nextLogicalAddress=" + this.pager.prettyFormat(this.nextLogicalAddress) + " and endLogicalAddress=" + this.pager.prettyFormat(endLogicalAddress));
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextElement == null && this.nextLogicalAddress != 0L) {
            int currentThreadIndex = this.log.epoch.getCurrentThreadIndex();
            this.advanceToNextSlot(currentThreadIndex);
        }
        return this.nextElement != null;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No element at " + this.pager.prettyFormat(this.nextLogicalAddress));
        }
        E returnElement = this.nextElement;
        this.nextElement = null;
        return returnElement;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.nextLogicalAddress = 0L;
        this.logAccessor.release();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void advanceToNextSlot(int threadIndex) {
        boolean isWithinRange;
        boolean isAlive;
        long nextSlotLogicalAddress = this.nextLogicalAddress;
        do {
            boolean bl = isWithinRange = (nextSlotLogicalAddress = this.calculateNextLogicalAddress(nextSlotLogicalAddress, threadIndex)) <= this.endLogicalAddress();
            if (!isWithinRange) break;
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Trying " + this.pager.prettyFormat(nextSlotLogicalAddress));
            }
            P nextPreparedSlot = this.slotAccessor.prepare(nextSlotLogicalAddress, this.logAccessor, threadIndex);
            this.lockEntry(nextPreparedSlot);
            try {
                isAlive = this.slotAccessor.isAlive(nextPreparedSlot);
                if (!isAlive) continue;
                this.nextLogicalAddress = nextSlotLogicalAddress;
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Using " + this.pager.prettyFormat(nextSlotLogicalAddress));
                }
                this.nextElement = this.slotAccessor.asEntry(nextPreparedSlot);
            }
            finally {
                this.slotAccessor.unlock(nextPreparedSlot);
            }
        } while (!isAlive);
        if (!isWithinRange) {
            this.close();
        }
    }

    private long calculateNextLogicalAddress(long nextLogicalAddress, int threadIndex) {
        if (nextLogicalAddress > this.endLogicalAddress()) {
            return nextLogicalAddress;
        }
        if (nextLogicalAddress == -1L) {
            return this.startLogicalAddress;
        }
        long physicalAddress = this.logAccessor.asPhysicalAddress(nextLogicalAddress, threadIndex);
        assert (physicalAddress != 0L);
        int currentPage = this.pager.pageOf(nextLogicalAddress);
        long nextPageHeaderAddress = this.logAccessor.pageAddress(currentPage);
        int lastPageAllocatedOffset = PageHeaderSupport.readLastAllocatedOffset(nextPageHeaderAddress);
        int currentOffset = this.pager.offsetOf(nextLogicalAddress);
        if (currentOffset < lastPageAllocatedOffset) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Taking " + this.pager.prettyFormat(nextLogicalAddress));
            }
            P slot = this.slotAccessor.prepare(nextLogicalAddress, this.logAccessor, threadIndex);
            int slotSize = this.slotAccessor.size(slot);
            return this.log.align(nextLogicalAddress + (long)slotSize);
        }
        if (currentOffset == lastPageAllocatedOffset) {
            this.refreshEpoch();
            int nextPage = currentPage + 1;
            return this.pager.asLogicalAddress(nextPage, 8);
        }
        boolean inMemory = this.log.isInMemory(nextLogicalAddress, threadIndex);
        throw new IllegalStateException(String.format("Trying to iterate over %s. The last offset of the page: %d, endLogicalAddress: %s, safeHeadAddress: %s, inMemory: %b, pagePhysicalAddress: %s, cachedPagePhysicalAddress: %s, cachedPage: %d, pageMetadata: %s", this.pager.prettyFormat(nextLogicalAddress), lastPageAllocatedOffset, this.pager.prettyFormat(this.endLogicalAddress), this.pager.prettyFormat(this.log.safeHeadAddress()), inMemory, TStoreUtil.prettyFormatPhysical(physicalAddress), TStoreUtil.prettyFormatPhysical(this.logAccessor.cachePagePhysicalAddress), this.logAccessor.cachedPage, this.pager.pageMetadata(currentPage)));
    }

    private void refreshEpoch() {
        this.log.epoch.refresh(this.log.epoch.getCurrentThreadIndex());
    }

    private long endLogicalAddress() {
        return this.type == HybridLogIteratorType.BOUNDED ? this.endLogicalAddress : this.log.lastAllocatedAddress();
    }

    private void lockEntry(P preparedSlot) {
        long idleCount = 0L;
        while (!this.slotAccessor.lock(preparedSlot)) {
            this.idleStrategy.idle(idleCount++);
        }
    }

    public String toString() {
        return "LogBasedHybridLogIterator{type=" + String.valueOf((Object)this.type) + ", startLogicalAddress=" + this.pager.prettyFormat(this.startLogicalAddress) + ", nextLogicalAddress=" + this.pager.prettyFormat(this.nextLogicalAddress) + ", endLogicalAddress=" + this.pager.prettyFormat(this.endLogicalAddress()) + ", nextElement=" + String.valueOf(this.nextElement) + ", slotAccessor=" + String.valueOf(this.slotAccessor) + "}";
    }

    public String readableMetrics() {
        return this.metrics.readableMetrics();
    }

    @NotThreadSafe
    private final class HybridLogAccessor
    implements MemoryAddressTranslator {
        private byte[] fetchBuffer;
        private int cachedPage = -1;
        private long cachePagePhysicalAddress;
        private final HybridLogImpl log;

        private HybridLogAccessor(HybridLogImpl log) {
            this.log = log;
        }

        @Override
        public boolean isInMemory(long logicalAddress) {
            return true;
        }

        @Override
        public long asPhysicalAddress(long logicalAddress, int threadIndex) {
            if (this.log.isInMemory(logicalAddress, threadIndex)) {
                return this.log.asPhysicalAddress(logicalAddress, threadIndex);
            }
            int page = LogBasedHybridLogIterator.this.pager.pageOf(logicalAddress);
            int offset = LogBasedHybridLogIterator.this.pager.offsetOf(logicalAddress);
            long cachedAddress = this.cachePagePhysicalAddress();
            if (page == this.cachedPage) {
                return cachedAddress + (long)offset;
            }
            this.cachedPage = page;
            byte[] buffer = this.fetchBuffer();
            long now = LogBasedHybridLogIterator.this.fineEnabled ? System.nanoTime() : 0L;
            this.log.fetchPage(page, buffer);
            if (LogBasedHybridLogIterator.this.fineEnabled) {
                LogBasedHybridLogIterator.this.metrics.onReadPageFromDisk();
                LogBasedHybridLogIterator.this.metrics.onIOTimeReadPageFromDisk(System.nanoTime() - now);
            }
            GlobalMemoryAccessorRegistry.AMEM.copyFromByteArray(buffer, 0, cachedAddress, buffer.length);
            if (LogBasedHybridLogIterator.this.fineEnabled) {
                long pageAddress = LogBasedHybridLogIterator.this.pager.asLogicalAddress(page, 0);
                String msg = "Cached page " + page + " with logical address " + LogBasedHybridLogIterator.this.pager.prettyFormat(pageAddress) + " and last allocated address " + LogBasedHybridLogIterator.this.pager.prettyFormat(LogBasedHybridLogIterator.this.pager.asLogicalAddress(page, PageHeaderSupport.readLastAllocatedOffset(this.cachePagePhysicalAddress))) + " at " + TStoreUtil.prettyFormatPhysical(cachedAddress);
                LogBasedHybridLogIterator.this.logger.fine(msg);
            }
            return cachedAddress + (long)offset;
        }

        private byte[] fetchBuffer() {
            if (this.fetchBuffer == null) {
                this.fetchBuffer = new byte[LogBasedHybridLogIterator.this.pager.pageSize];
            }
            return this.fetchBuffer;
        }

        private long cachePagePhysicalAddress() {
            if (this.cachePagePhysicalAddress == 0L) {
                this.cachePagePhysicalAddress = this.log.pagePool.acquire();
                if (LogBasedHybridLogIterator.this.fineEnabled) {
                    LogBasedHybridLogIterator.this.logger.fine("Allocated iterator page cache at " + TStoreUtil.prettyFormatPhysical(this.cachePagePhysicalAddress));
                }
            }
            return this.cachePagePhysicalAddress;
        }

        private void release() {
            if (this.cachePagePhysicalAddress != 0L) {
                this.log.pagePool.release(this.cachePagePhysicalAddress);
                if (LogBasedHybridLogIterator.this.fineEnabled) {
                    LogBasedHybridLogIterator.this.logger.fine("Freed iterator page cache at " + TStoreUtil.prettyFormatPhysical(this.cachePagePhysicalAddress));
                }
                this.cachePagePhysicalAddress = 0L;
                this.cachedPage = -1;
            }
        }

        public long pageAddress(int page) {
            return page == this.cachedPage ? this.cachePagePhysicalAddress : LogBasedHybridLogIterator.this.pager.pageAddress(page);
        }
    }

    private static class LogBasedHybridLogIteratorMetrics {
        long ioTimeNanos;
        int pagesReadFromDiskCnt;
        private final int pageSizeBytes;

        LogBasedHybridLogIteratorMetrics(int pageSizeBytes) {
            this.pageSizeBytes = pageSizeBytes;
        }

        void onReadPageFromDisk() {
            ++this.pagesReadFromDiskCnt;
        }

        void onIOTimeReadPageFromDisk(long nanos) {
            this.ioTimeNanos += nanos;
        }

        String readableMetrics() {
            String newLine = System.lineSeparator() + "\t";
            return System.lineSeparator() + "LogBasedHybridLogIteratorMetrics:" + newLine + "pagesReadFromDiskCnt=" + this.pagesReadFromDiskCnt + newLine + "pageSize=" + MemoryUnit.BYTES.toMegaBytes(this.pageSizeBytes) + " MB" + newLine + "totalDataIteratedOver=" + MemoryUnit.BYTES.toMegaBytes((long)this.pageSizeBytes * (long)this.pagesReadFromDiskCnt) + " MB" + newLine + "pageReadsIOTime=" + String.format("%.3f", (double)this.ioTimeNanos / 1000000.0) + " millis.";
        }
    }
}

