/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.tstore.hybridlog.impl.BaseHybridLogDirectAccessor;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.Pager;
import com.hazelcast.internal.tstore.hybridlog.impl.TStoreUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;

public class GuardedHybridLogDirectAccessor
extends BaseHybridLogDirectAccessor {
    protected final ILogger logger = Logger.getLogger(GuardedHybridLogDirectAccessor.class);
    private final HybridLogImpl hybridLog;
    private final Pager pager;

    public GuardedHybridLogDirectAccessor(HybridLogImpl hybridLog) {
        this.hybridLog = hybridLog;
        this.pager = hybridLog.pager;
    }

    @Override
    protected boolean verifyAccessInternal(long slotLogicalAddress, long physicalAddress, int bytesAccessed, int slotSize) {
        int page = this.pager.pageOf(slotLogicalAddress);
        this.pager.verifyPage(page);
        if (!this.hybridLog.isInMemory(slotLogicalAddress)) {
            throw new IllegalArgumentException(this.hybridLog.debugPrologue() + " - Illegal attempt to access " + this.pager.prettyFormat(slotLogicalAddress) + " @ " + TStoreUtil.prettyFormatPhysical(physicalAddress) + ". The slot is not in the memory.");
        }
        long slotAccessStartPhysicalAddress = this.pager.asPhysicalAddress(slotLogicalAddress);
        long slotAccessEndPhysicalAddress = slotAccessStartPhysicalAddress + (long)bytesAccessed;
        long allowedMaxAccessedPhysicalAddress = slotSize == -1 ? this.pager.asPhysicalAddress(this.pager.pageEndLogicalAddress(page)) : slotAccessStartPhysicalAddress + (long)slotSize;
        if (physicalAddress < 0L + (long)this.pager.pageSize) {
            String msg = this.hybridLog.debugPrologue() + " - Illegal attempt to access " + this.pager.prettyFormat(slotLogicalAddress) + " @ " + TStoreUtil.prettyFormatPhysical(physicalAddress) + ". Metadata of the page: " + String.valueOf(this.pager.pageMetadata(page));
            this.logger.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (physicalAddress < slotAccessStartPhysicalAddress || physicalAddress > allowedMaxAccessedPhysicalAddress || slotAccessEndPhysicalAddress > allowedMaxAccessedPhysicalAddress) {
            String msg = String.format("%s - Illegal attempt to access %s. The slot access must stay between [%s-%s], but tried to access [%s-%s].", this.hybridLog.debugPrologue(), this.pager.prettyFormat(slotLogicalAddress), TStoreUtil.prettyFormatPhysical(slotAccessStartPhysicalAddress), TStoreUtil.prettyFormatPhysical(allowedMaxAccessedPhysicalAddress), TStoreUtil.prettyFormatPhysical(physicalAddress), TStoreUtil.prettyFormatPhysical(slotAccessEndPhysicalAddress));
            this.logger.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        return true;
    }
}

