/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.util.function.LongLongConsumer;
import com.hazelcast.logging.Logger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongConsumer;

class FutureSafeHeadAddressesList {
    static final long WONT_ADVANCE = -1L;
    private final AtomicBoolean spinLock = new AtomicBoolean();
    private final AtomicBoolean prepSpinLock = new AtomicBoolean();
    private final HybridLogImpl log;
    private PrepNode preparationHead;
    private volatile PrepNode preparationTail;
    private Node head;

    FutureSafeHeadAddressesList(HybridLogImpl log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepare(long futureSafeHeadAddress) {
        PrepNode newNode = new PrepNode(futureSafeHeadAddress);
        this.prepSpinLock();
        try {
            if (this.preparationHead == null || this.preparationHead.futureSafeHeadAddress > futureSafeHeadAddress) {
                newNode.next = this.preparationHead;
                this.preparationHead = newNode;
                if (newNode.next == null) {
                    this.preparationTail = newNode;
                }
                return;
            }
            PrepNode parentNode = this.preparationHead;
            PrepNode currentNode = this.preparationHead.next;
            while (currentNode != null && currentNode.futureSafeHeadAddress < newNode.futureSafeHeadAddress) {
                parentNode = currentNode;
                currentNode = currentNode.next;
            }
            parentNode.next = newNode;
            newNode.next = currentNode;
            newNode.prev = parentNode;
            if (currentNode != null) {
                currentNode.prev = newNode;
            }
            if (newNode.next == null) {
                this.preparationTail = newNode;
            }
        }
        finally {
            this.releasePrepSpinLock();
        }
    }

    boolean waitUntilPreparationsDrainedFor(long thresholdLogicalAddress) {
        boolean waited = false;
        PrepNode preparationTailCopy = this.preparationTail;
        if (preparationTailCopy != null && preparationTailCopy.futureSafeHeadAddress > thresholdLogicalAddress) {
            waited = true;
            while (!preparationTailCopy.finalized) {
                Thread.yield();
            }
        }
        return waited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeWithEpoch(long futureSafeEpoch, long futureSafeHeadAddress) {
        this.prepSpinLock();
        this.spinLock();
        try {
            PrepNode finalizedPrepNode = this.removePrepFutureSafeHeadAddress(futureSafeHeadAddress);
            this.addFutureSafeHeadAddressWithEpoch(futureSafeEpoch, futureSafeHeadAddress);
            finalizedPrepNode.finalized = true;
        }
        finally {
            this.releasePrepSpinLock();
            this.releaseSpinLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getSafeHeadAddressForEpoch(long epoch) {
        this.spinLock();
        try {
            if (this.head == null || this.head.futureEpoch >= epoch) {
                long l = -1L;
                return l;
            }
            Node currentNode = this.head;
            Node nextNode = this.head.next;
            while (nextNode != null && nextNode.futureEpoch < epoch) {
                currentNode = nextNode;
                nextNode = nextNode.next;
            }
            long l = currentNode.futureSafeHeadAddress;
            return l;
        }
        finally {
            this.releaseSpinLock();
        }
    }

    void cleanUpToEpoch(long epoch) {
        this.spinLock();
        try {
            if (this.head == null || this.head.futureEpoch > epoch) {
                return;
            }
            Node nextNode = this.head.next;
            while (nextNode != null && nextNode.futureEpoch <= epoch) {
                nextNode = nextNode.next;
            }
            this.head = nextNode;
        }
        catch (Exception ex) {
            Logger.getLogger(FutureSafeHeadAddressesList.class).severe(this.log.debugPrologue() + " - Exception occurred while cleaning future safe head addresses up to epoch " + epoch);
            throw ex;
        }
        finally {
            this.releaseSpinLock();
        }
    }

    private void addFutureSafeHeadAddressWithEpoch(long futureSafeEpoch, long futureSafeHeadAddress) {
        Node newNode = new Node(futureSafeEpoch, futureSafeHeadAddress);
        if (this.head == null || this.head.futureEpoch > futureSafeEpoch) {
            newNode.next = this.head;
            this.head = newNode;
            return;
        }
        Node parentNode = this.head;
        Node currentNode = this.head.next;
        while (currentNode != null && currentNode.futureEpoch < newNode.futureEpoch) {
            parentNode = currentNode;
            currentNode = currentNode.next;
        }
        parentNode.next = newNode;
        newNode.next = currentNode;
    }

    private PrepNode removePrepFutureSafeHeadAddress(long futureSafeHeadAddress) {
        PrepNode currentNode = this.preparationHead;
        while (currentNode != null && currentNode.futureSafeHeadAddress != futureSafeHeadAddress) {
            currentNode = currentNode.next;
        }
        if (currentNode == null) {
            throw new IllegalArgumentException(this.log.debugPrologue() + " - Can't remove future safe head address " + this.log.pager.prettyFormat(futureSafeHeadAddress) + " from the preparation list, because it's not in the list. It is expected that this method is called with an address that is in the list.");
        }
        if (currentNode.prev != null) {
            currentNode.prev.next = currentNode.next;
        }
        if (currentNode.next != null) {
            currentNode.next.prev = currentNode.prev;
        }
        if (this.preparationHead == currentNode) {
            this.preparationHead = currentNode.next;
        }
        if (this.preparationTail == currentNode) {
            this.preparationTail = currentNode.prev;
        }
        return currentNode;
    }

    void traverse(LongLongConsumer consumer) {
        this.spinLock();
        try {
            Node currentNode = this.head;
            while (currentNode != null) {
                consumer.accept(currentNode.futureEpoch, currentNode.futureSafeHeadAddress);
                currentNode = currentNode.next;
            }
        }
        finally {
            this.releaseSpinLock();
        }
    }

    void traversePrepared(LongConsumer consumer) {
        this.prepSpinLock();
        try {
            PrepNode currentNode = this.preparationHead;
            while (currentNode != null) {
                consumer.accept(currentNode.futureSafeHeadAddress);
                currentNode = currentNode.next;
            }
        }
        finally {
            this.releasePrepSpinLock();
        }
    }

    long preparationHeadAddress() {
        return this.preparationHead.futureSafeHeadAddress;
    }

    long preparationTailAddress() {
        return this.preparationTail.futureSafeHeadAddress;
    }

    private void spinLock() {
        this.spinLock(this.spinLock);
    }

    private void releaseSpinLock() {
        this.releaseSpinLock(this.spinLock);
    }

    private void prepSpinLock() {
        this.spinLock(this.prepSpinLock);
    }

    private void releasePrepSpinLock() {
        this.releaseSpinLock(this.prepSpinLock);
    }

    private void spinLock(AtomicBoolean lock) {
        while (!lock.compareAndSet(false, true)) {
            Thread.yield();
        }
    }

    private void releaseSpinLock(AtomicBoolean lock) {
        lock.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String debugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("prepared: ");
        this.prepSpinLock();
        try {
            PrepNode prepHead = this.preparationHead;
            if (prepHead != null) {
                sb.append(prepHead);
            } else {
                sb.append("null");
            }
        }
        finally {
            this.releasePrepSpinLock();
        }
        sb.append(", ");
        sb.append("finalized: ");
        this.spinLock();
        try {
            Node head = this.head;
            if (head != null) {
                sb.append(head);
            } else {
                sb.append("null");
            }
        }
        finally {
            this.releaseSpinLock();
        }
        return sb.toString();
    }

    private static final class PrepNode {
        private final long futureSafeHeadAddress;
        private PrepNode prev;
        private PrepNode next;
        private volatile boolean finalized;

        private PrepNode(long futureSafeHeadAddress) {
            this.futureSafeHeadAddress = futureSafeHeadAddress;
        }

        public String toString() {
            return "PrepNode{futureSafeHeadAddress=" + this.futureSafeHeadAddress + ", next=" + String.valueOf(this.next) + "}";
        }
    }

    private static final class Node {
        private final long futureEpoch;
        private final long futureSafeHeadAddress;
        private Node next;

        private Node(long futureEpoch, long futureSafeHeadAddress) {
            this.futureEpoch = futureEpoch;
            this.futureSafeHeadAddress = futureSafeHeadAddress;
        }

        public String toString() {
            return "Node{futureEpoch=" + this.futureEpoch + ", futureSafeHeadAddress=" + this.futureSafeHeadAddress + ", next=" + String.valueOf(this.next) + "}";
        }
    }
}

