/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImplMetrics;
import java.util.List;

public class AggregatedHybridLogImplMetrics {
    @Probe(name="tstore.hlog.aggregated.count", unit=ProbeUnit.COUNT)
    private long hybridLogsAggregated;
    @Probe(name="tstore.hlog.pageWriteDuration.total", unit=ProbeUnit.NS)
    private long pageWriteDurationTotalNs;
    @Probe(name="tstore.hlog.readRecordDuration.total", unit=ProbeUnit.NS)
    private long readRecordDurationTotalNs;
    @Probe(name="tstore.hlog.readRecord.hits", unit=ProbeUnit.COUNT)
    private long readRecordHits;
    @Probe(name="tstore.hlog.readRecord.misses", unit=ProbeUnit.COUNT)
    private long readRecordMisses;
    @Probe(name="tstore.hlog.allocation.stall.total", unit=ProbeUnit.NS)
    private long allocationStallTotalNs;
    @Probe(name="tstore.hlog.allocation.size.total", unit=ProbeUnit.BYTES)
    private long allocationSizeTotal;
    @Probe(name="tstore.hlog.waste.alignment.total", unit=ProbeUnit.BYTES)
    private long wasteAlignmentTotal;
    @Probe(name="tstore.hlog.waste.paging.total", unit=ProbeUnit.BYTES)
    private long wastePagingTotal;
    @Probe(name="tstore.hlog.compaction.queueTime.total", unit=ProbeUnit.NS)
    private long compactionQueueTimeTotalNs;
    @Probe(name="tstore.hlog.compaction.queue.count", unit=ProbeUnit.COUNT)
    private long compactionsQueued;
    @Probe(name="tstore.hlog.compaction.time.total", unit=ProbeUnit.NS)
    private long compactionTimeTotalNs;
    @Probe(name="tstore.hlog.compaction.ioTime.total", unit=ProbeUnit.NS)
    private long compactionIoTimeTotalNs;
    @Probe(name="tstore.hlog.compaction.count", unit=ProbeUnit.COUNT)
    private long compactionCount;
    @Probe(name="tstore.hlog.compaction.inProgress.count", unit=ProbeUnit.COUNT)
    private long compactionInProgressCount;
    @Probe(name="tstore.hlog.compaction.dummyRecords.count", unit=ProbeUnit.COUNT)
    private long dummyRecordsCnt;
    @Probe(name="tstore.hlog.compaction.dummyRecords.size", unit=ProbeUnit.BYTES)
    private long dummyRecordsSize;
    @Probe(name="tstore.hlog.compaction.nonDummyRecords.count", unit=ProbeUnit.COUNT)
    private long nonDummyRecordsCnt;
    @Probe(name="tstore.hlog.compaction.nonDummyRecords.size", unit=ProbeUnit.BYTES)
    private long nonDummyRecordsSize;
    @Probe(name="tstore.hlog.compaction.aliveRecords.count", unit=ProbeUnit.COUNT)
    private long aliveRecordsCnt;
    @Probe(name="tstore.hlog.compaction.aliveRecords.size", unit=ProbeUnit.BYTES)
    private long aliveRecordsSize;
    @Probe(name="tstore.hlog.compaction.deadRecords.count", unit=ProbeUnit.COUNT)
    private long deadRecordsCnt;
    @Probe(name="tstore.hlog.compaction.deadRecords.size", unit=ProbeUnit.BYTES)
    private long deadRecordsSize;
    @Probe(name="tstore.hlog.compaction.visitedRecords.count", unit=ProbeUnit.COUNT)
    private long visitedRecordsCnt;
    @Probe(name="tstore.hlog.compaction.visitedRecords.size", unit=ProbeUnit.BYTES)
    private long visitedRecordsSize;

    public static AggregatedHybridLogImplMetrics aggregate(List<HybridLogImplMetrics> sourceMetrics) {
        AggregatedHybridLogImplMetrics target = new AggregatedHybridLogImplMetrics();
        target.hybridLogsAggregated = sourceMetrics.size();
        for (HybridLogImplMetrics source : sourceMetrics) {
            target.pageWriteDurationTotalNs += AggregatedHybridLogImplMetrics.zeroIfNegative(source.getPageWriteDurationTotalNs());
            target.readRecordDurationTotalNs += AggregatedHybridLogImplMetrics.zeroIfNegative(source.getReadRecordDurationTotalNs());
            target.readRecordHits += source.getReadRecordHits();
            target.readRecordMisses += source.getReadRecordMisses();
            target.allocationStallTotalNs += AggregatedHybridLogImplMetrics.zeroIfNegative(source.getAllocationStallTotalNs());
            target.allocationSizeTotal += source.getAllocationSizeTotal();
            target.wasteAlignmentTotal += source.getWasteAlignmentTotal();
            target.wastePagingTotal += source.getWastePagingTotal();
            target.compactionQueueTimeTotalNs += AggregatedHybridLogImplMetrics.zeroIfNegative(source.getCompactionQueueTimeAvgNs());
            target.compactionsQueued += source.getCompactionsQueued();
            target.compactionTimeTotalNs += source.getCompactionTimeTotalNs();
            target.compactionIoTimeTotalNs += source.getCompactionIoTimeTotalNs();
            target.compactionCount += source.getCompactionsFinished();
            target.compactionInProgressCount += source.getCompactionsInProgress();
            target.dummyRecordsCnt += source.getDummyRecordsCnt();
            target.dummyRecordsSize += source.getDummyRecordsSize();
            target.nonDummyRecordsCnt += source.getNonDummyRecordsCnt();
            target.nonDummyRecordsSize += source.getNonDummyRecordsSize();
            target.aliveRecordsCnt += source.getAliveRecordsCnt();
            target.aliveRecordsSize += source.getAliveRecordsSize();
            target.deadRecordsCnt += source.getDeadRecordsCnt();
            target.deadRecordsSize += source.getDeadRecordsSize();
            target.visitedRecordsCnt += source.getVisitedRecordsCnt();
            target.visitedRecordsSize += source.getVisitedRecordsSize();
            ++target.hybridLogsAggregated;
        }
        return target;
    }

    private static long zeroIfNegative(long value) {
        return Math.max(0L, value);
    }
}

