/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device.local;

import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.device.HybridLogFileHandlePool;
import com.hazelcast.internal.tstore.device.MutableOperation;
import com.hazelcast.internal.tstore.device.local.LocalStorageDevice;

final class TruncateOperation
extends MutableOperation {
    private final int fromSegmentNo;
    private final int toSegmentNoInclusive;

    TruncateOperation(int storeId, Device device, int fromSegmentNo, int toSegmentNoInclusive) {
        super(storeId, device);
        this.fromSegmentNo = fromSegmentNo;
        this.toSegmentNoInclusive = toSegmentNoInclusive;
        Invariants.lessThanOrEqual(fromSegmentNo, toSegmentNoInclusive);
    }

    @Override
    public Void run(byte[] context) {
        HybridLogFileHandlePool handlePool = this.getDevice().getHandlePool();
        int storeId = this.getDevice().getStoreId();
        handlePool.clearHandles(storeId, this.fromSegmentNo, this.toSegmentNoInclusive);
        this.getDevice().deleteLogFiles(this.fromSegmentNo, this.toSegmentNoInclusive);
        return null;
    }

    private LocalStorageDevice getDevice() {
        return (LocalStorageDevice)this.device;
    }

    @Override
    public String toString() {
        return "TruncateOperation(" + this.storeId + ", " + this.device.deviceName() + ", " + this.fromSegmentNo + ", " + this.toSegmentNoInclusive + ")";
    }
}

