/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device.local;

import com.hazelcast.internal.tstore.compaction.CompactionStats;
import com.hazelcast.internal.tstore.device.DeviceMetrics;
import java.util.concurrent.atomic.AtomicLong;

class LocalStorageDeviceMetrics
implements DeviceMetrics {
    private final CompactionStats compactionStats;
    private final AtomicLong deviceUsageInBytes = new AtomicLong();
    private final AtomicLong deletedSizeTotalInBytes = new AtomicLong();

    LocalStorageDeviceMetrics(CompactionStats compactionStats) {
        this.compactionStats = compactionStats;
    }

    void onWrite(int writeLength) {
        this.compactionStats.updateUsedDeviceCapacityInBytes(writeLength);
        this.deviceUsageInBytes.addAndGet(writeLength);
    }

    void onTruncate(long fileSize) {
        this.compactionStats.updateUsedDeviceCapacityInBytes(-fileSize);
        this.deviceUsageInBytes.addAndGet(-fileSize);
        this.deletedSizeTotalInBytes.addAndGet(fileSize);
    }

    @Override
    public long getDeviceUsageInBytes() {
        return this.deviceUsageInBytes.get();
    }

    @Override
    public long getDeletedSizeTotalInBytes() {
        return this.deletedSizeTotalInBytes.get();
    }

    public String toString() {
        return "LocalStorageDeviceMetrics{deviceUsageInBytes=" + String.valueOf(this.deviceUsageInBytes) + ", deletedSizeTotalInBytes=" + String.valueOf(this.deletedSizeTotalInBytes) + "}";
    }
}

