/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device.local;

import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.PaddingUtil;
import com.hazelcast.internal.tstore.compaction.CompactionStats;
import com.hazelcast.internal.tstore.compaction.Compactor;
import com.hazelcast.internal.tstore.device.ChunkAccessor;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.device.DeviceException;
import com.hazelcast.internal.tstore.device.DeviceMetrics;
import com.hazelcast.internal.tstore.device.DeviceOperationExecutor;
import com.hazelcast.internal.tstore.device.HybridLogFileHandle;
import com.hazelcast.internal.tstore.device.HybridLogFileHandlePool;
import com.hazelcast.internal.tstore.device.HybridLogFileHandleProvider;
import com.hazelcast.internal.tstore.device.RecordAccessor;
import com.hazelcast.internal.tstore.device.local.CompactorFileQueue;
import com.hazelcast.internal.tstore.device.local.LocalStorageDeviceMetrics;
import com.hazelcast.internal.tstore.device.local.ReadChunkOperation;
import com.hazelcast.internal.tstore.device.local.ReadOperation;
import com.hazelcast.internal.tstore.device.local.ReadRecordOperation;
import com.hazelcast.internal.tstore.device.local.SegmentLock;
import com.hazelcast.internal.tstore.device.local.TruncateOperation;
import com.hazelcast.internal.tstore.device.local.WriteOperation;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.memory.Capacity;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class LocalStorageDevice
implements Device {
    private static final ILogger LOGGER = Logger.getLogger(LocalStorageDevice.class);
    final CompactorFileQueue compactorFileQueue;
    private final ConcurrentMap<Integer, SegmentLock> segmentLockByFileNo = new ConcurrentHashMap<Integer, SegmentLock>();
    private final HybridLogFileHandlePool handlePool;
    private final DeviceOperationExecutor operationExecutor;
    private final int storeId;
    private final int partitionId;
    private final LocalDeviceConfig deviceConfig;
    private final File storeDirPath;
    private final HybridLogFileHandleProvider handleProvider;
    private final TStoreUserId uid;
    private final CompactionStats compactionStats;
    private final int readPageSize;
    private final int writePageSize;
    private final LocalStorageDeviceMetrics metrics;
    private final Map<Long, Compactor> inProgressCompactors = new ConcurrentHashMap<Long, Compactor>();
    private final AtomicLong compactorIdGenerator = new AtomicLong();
    private final long maxLogFileSizeInBytes;
    private HybridLogImpl hybridLog;

    public LocalStorageDevice(int storeId, TStoreUserId uid, LocalDeviceConfig deviceConfig, int writePageSize, File storeDirPath, HybridLogFileHandlePool handlePool, DeviceOperationExecutor operationExecutor, CompactionStats compactionStats, int partitionId, boolean cleanupFiles, HazelcastProperties properties) {
        this.metrics = new LocalStorageDeviceMetrics(compactionStats);
        this.handlePool = handlePool;
        this.operationExecutor = operationExecutor;
        this.deviceConfig = deviceConfig;
        this.storeDirPath = storeDirPath;
        this.storeId = storeId;
        this.partitionId = partitionId;
        this.handleProvider = this::getLogHandleFromFileNo;
        this.uid = uid;
        this.compactionStats = compactionStats;
        this.maxLogFileSizeInBytes = compactionStats.getMaxLogFileSizeInBytes();
        this.readPageSize = deviceConfig.getBlockSize();
        this.writePageSize = writePageSize;
        if (cleanupFiles) {
            LocalStorageDevice.cleanupLogFiles(storeDirPath);
        }
        compactionStats.registerDevice(this);
        this.compactorFileQueue = new CompactorFileQueue(this.maxLogFileSizeInBytes, this::isSegmentOnDevice, compactionStats.getCompactorFlags(), properties, LOGGER);
    }

    public long getPartitionGarbageInBytes() {
        return this.compactorFileQueue.getPartitionGarbageInBytes();
    }

    public boolean hasNoGarbageInPartition() {
        return this.compactorFileQueue.getPartitionGarbageInBytes() == 0L;
    }

    public File getStoreDirPath() {
        return this.storeDirPath;
    }

    public CompactionStats getCompactionStats() {
        return this.compactionStats;
    }

    @Override
    public String deviceName() {
        return this.deviceConfig.getName();
    }

    public int getStoreId() {
        return this.storeId;
    }

    @Override
    public String debugInfo() {
        return this.getClass().getSimpleName() + "\n\t- Device name: " + this.deviceName() + "\n\t- Store id: " + this.storeId + "\n\t- Directory: " + this.storeDirPath.getAbsolutePath() + "\n\t- Device page size: " + this.readPageSize;
    }

    @Override
    public String segmentsInfo() {
        return this.segmentLockByFileNo.toString();
    }

    @Override
    public CompletableFuture<Void> writeAsync(long logicalAddress, long physicalAddress, int writeLength) {
        assert (writeLength == this.writePageSize);
        assert (logicalAddress % (long)this.writePageSize == 0L);
        WriteOperation op = new WriteOperation(this.storeId, this, logicalAddress, physicalAddress, writeLength);
        return this.operationExecutor.submit(op);
    }

    @Override
    public CompletableFuture<byte[]> readAsync(long logicalAddress, int readLength) {
        ReadOperation op = new ReadOperation(this.storeId, this, logicalAddress, readLength);
        return this.operationExecutor.submit(op);
    }

    @Override
    public CompletableFuture<byte[]> readRecordAsync(long logicalAddress, RecordAccessor recordAccessor) {
        ReadRecordOperation op = new ReadRecordOperation(this.storeId, this, logicalAddress, recordAccessor);
        return this.operationExecutor.submit(op);
    }

    @Override
    public byte[] read(long logicalAddress, int readLength) {
        byte[] data = new byte[readLength];
        return ReadOperation.run0(this, data, logicalAddress, readLength);
    }

    @Override
    public void read(long logicalAddress, byte[] buf) {
        ReadOperation.run0(this, buf, logicalAddress, buf.length);
    }

    @Override
    public byte[] readRecord(long logicalAddress, RecordAccessor recordAccessor) {
        byte[] data = new byte[this.readPageSize];
        return ReadRecordOperation.run0(this, data, logicalAddress, recordAccessor);
    }

    @Override
    public byte[] readRecord(long logicalAddress, byte[] buf, RecordAccessor recordAccessor) {
        return ReadRecordOperation.run0(this, buf, logicalAddress, recordAccessor);
    }

    @Override
    public byte[] readChunk(long logicalAddress, byte[] buf, ChunkAccessor chunkAccessor) {
        return ReadChunkOperation.run0(this, buf, logicalAddress, chunkAccessor);
    }

    @Override
    public CompletableFuture<Void> truncateAsync(long oldestLogicalAddress) {
        int oldestFileNo = this.segmentNoOf(oldestLogicalAddress);
        if (oldestFileNo == 0) {
            return CompletableFuture.completedFuture(null);
        }
        TruncateOperation op = new TruncateOperation(this.storeId, this, 0, oldestFileNo - 1);
        return this.operationExecutor.submit(op);
    }

    @Override
    public CompletableFuture<Void> truncateAsync(int segmentNo) {
        return this.truncateAsync(segmentNo, segmentNo);
    }

    private CompletableFuture<Void> truncateAsync(int fromSegmentNo, int toSegmentNoInclusive) {
        Invariants.lessThanOrEqual(fromSegmentNo, toSegmentNoInclusive);
        TruncateOperation op = new TruncateOperation(this.storeId, this, fromSegmentNo, toSegmentNoInclusive);
        return this.operationExecutor.submit(op);
    }

    @Override
    public void truncate(int segmentNo) {
        new TruncateOperation(this.storeId, this, segmentNo, segmentNo).run(null);
    }

    @Override
    public void dispose() {
        this.compactionStats.deregisterDevice(this);
        this.clearThisDeviceFromHybridLogFileHandlePool();
        this.deleteThisDeviceDirAndItsContents();
        long thisDevicesUsageInBytes = this.getMetrics().getDeviceUsageInBytes();
        this.compactionStats.updateUsedDeviceCapacityInBytes(-thisDevicesUsageInBytes);
    }

    private void clearThisDeviceFromHybridLogFileHandlePool() {
        this.handlePool.clearHandles(this.storeId, Integer.MAX_VALUE);
    }

    private void deleteThisDeviceDirAndItsContents() {
        try {
            IOUtil.delete(this.storeDirPath);
        }
        catch (Exception e) {
            String msg = String.format("Failed to cleanup directory %s.", this.storeDirPath.getAbsolutePath());
            LOGGER.warning(msg, e);
            throw new DeviceException(msg, e);
        }
    }

    @Override
    public long segmentFirstLogicalAddress(int segmentNo) {
        Invariants.nonNegative(segmentNo);
        return this.maxLogFileSizeInBytes * (long)segmentNo;
    }

    public long segmentLowLogicalAddress(int segmentNo) {
        Invariants.nonNegative(segmentNo);
        return this.maxLogFileSizeInBytes * (long)segmentNo;
    }

    @Override
    public long segmentLastLogicalAddress(int segmentNo) {
        Invariants.nonNegative(segmentNo);
        return this.maxLogFileSizeInBytes * (long)(segmentNo + 1) - 1L;
    }

    @Override
    public boolean containsLogicalAddress(long logicalAddress) {
        Invariants.nonNegative(logicalAddress);
        int fileNo = this.segmentNoOf(logicalAddress);
        return this.segmentLockByFileNo.containsKey(fileNo);
    }

    @Override
    public TStoreUserId userId() {
        return this.uid;
    }

    @Override
    public int partitionId() {
        return this.partitionId;
    }

    HybridLogFileHandlePool getHandlePool() {
        return this.handlePool;
    }

    HybridLogFileHandleProvider getHandleProvider() {
        return this.handleProvider;
    }

    long getLogFileOffsetFromLogicalAddress(long logicalAddress) {
        return logicalAddress % this.maxLogFileSizeInBytes;
    }

    @Override
    public int segmentNoOf(long logicalAddress) {
        if (logicalAddress == Long.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)(logicalAddress / this.maxLogFileSizeInBytes);
    }

    HybridLogFileHandle getLogHandleFromFileNo(int fileNo) {
        try {
            File file = this.getHybridLogFileFromFileNo(fileNo);
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            if (this.tryLockSegmentForFileNo(fileNo)) {
                this.queueFileNoForCompaction(fileNo);
            }
            return new HybridLogFileHandle(file, raf, this.storeId, fileNo);
        }
        catch (FileNotFoundException ioe) {
            throw new DeviceException(ioe);
        }
    }

    private void queueFileNoForCompaction(int fileNo) {
        this.compactorFileQueue.add(fileNo);
        if (fileNo > 0) {
            this.compactionStats.onNewSegment();
        }
    }

    private boolean tryLockSegmentForFileNo(int fileNo) {
        if (this.segmentLockByFileNo.containsKey(fileNo)) {
            return false;
        }
        return this.segmentLockByFileNo.putIfAbsent(fileNo, new SegmentLock()) == null;
    }

    File getHybridLogFileFromFileNo(int fileNo) {
        return LocalStorageDevice.getFileFromFileNo(this.storeDirPath, fileNo);
    }

    static File getFileFromFileNo(File dir, int fileNo) {
        String name = LocalStorageDevice.getFileName(fileNo);
        return new File(dir, name);
    }

    private static String getFileName(int fileNo) {
        return "hz_" + PaddingUtil.leftPadUpToTenWithZero(fileNo) + ".hl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLogFiles(int fromFileNo, int toFileNoInclusive) {
        for (int fileNo = fromFileNo; fileNo <= toFileNoInclusive && !this.segmentLockByFileNo.isEmpty(); ++fileNo) {
            File file = this.getHybridLogFileFromFileNo(fileNo);
            SegmentLock segmentLock = (SegmentLock)this.segmentLockByFileNo.get(fileNo);
            if (segmentLock == null) continue;
            segmentLock.pinForUpdate();
            try {
                if (file.exists()) {
                    long fileSize = file.length();
                    assert (fileSize <= this.maxLogFileSizeInBytes);
                    if (!file.delete()) {
                        LOGGER.warning(String.format("Unable to delete hybrid log file %s", file.getAbsoluteFile()));
                    }
                    if (!file.exists()) {
                        this.metrics.onTruncate(fileSize);
                    }
                }
            }
            finally {
                this.segmentLockByFileNo.remove(fileNo);
                segmentLock.unpin();
            }
            if (!LOGGER.isFineEnabled()) continue;
            LOGGER.fine(String.format("Deleted log file %s", file.getAbsoluteFile()));
        }
    }

    private static void cleanupLogFiles(File dirFile) {
        assert (dirFile.isDirectory());
        File[] files = dirFile.listFiles((dir, name) -> name.endsWith(".hl"));
        if (files == null) {
            throw new DeviceException("Cannot read from device by path: " + dirFile.getAbsolutePath());
        }
        for (File hlFile : files) {
            try {
                IOUtil.delete(hlFile);
            }
            catch (Exception e) {
                String msg = String.format("Failed to cleanup directory %s. Cannot delete hybrid log file %s.", dirFile.getAbsolutePath(), hlFile.getName());
                LOGGER.warning(msg, e);
                throw new DeviceException(msg, e);
            }
        }
    }

    @Override
    public DeviceMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    @Nullable
    public Integer pollFileNoToCompact() {
        return this.compactorFileQueue.poll();
    }

    public boolean isOverNodeSoftDeviceCapacity() {
        return this.compactionStats.isOverNodeSoftDeviceCapacity();
    }

    @Override
    public boolean isOverPartitionsCompactionFreeThreshold() {
        return this.compactorFileQueue.isOverPartitionsCompactionFreeThreshold();
    }

    @Override
    public void onGarbage(long logicalAddress, int recordLengthBytes) {
        Invariants.nonNegative(logicalAddress);
        Invariants.greaterThan(recordLengthBytes, 0);
        recordLengthBytes = LocalStorageDevice.padTo8Bytes(recordLengthBytes);
        int fileNo = this.segmentNoOf(logicalAddress);
        boolean tooMuchGarbage = this.compactorFileQueue.increaseFilesGarbage(fileNo, recordLengthBytes);
        if (tooMuchGarbage) {
            this.tryIncrementalCompaction();
        }
    }

    @Override
    public void onSegmentCompacted(int segmentNo) {
        this.compactorFileQueue.onSegmentCompacted(segmentNo);
    }

    private static int padTo8Bytes(int size) {
        return size + (8 - (size & 7) & 7);
    }

    private void tryIncrementalCompaction() {
        if (!this.compactionStats.canTryIncrementalCompaction()) {
            return;
        }
        Integer fileNoToCompact = this.compactorFileQueue.poll();
        if (fileNoToCompact == null) {
            return;
        }
        this.compactionStats.doIncrementalCompaction(this.userId(), this.partitionId(), fileNoToCompact);
    }

    @Override
    public long registerCompactor(Compactor compactor) {
        long id = this.compactorIdGenerator.incrementAndGet();
        this.inProgressCompactors.put(id, compactor);
        return id;
    }

    @Override
    public synchronized void deregisterCompactor(long id) {
        Compactor compactor = this.inProgressCompactors.remove(id);
        assert (compactor != null);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateCompactors() {
        for (Compactor compactor : this.inProgressCompactors.values()) {
            compactor.interrupt();
        }
        boolean interrupted = false;
        LocalStorageDevice localStorageDevice = this;
        synchronized (localStorageDevice) {
            while (!this.inProgressCompactors.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void pinSegment(int segmentNo) {
        SegmentLock lock = (SegmentLock)this.segmentLockByFileNo.get(segmentNo);
        lock.pinForRead();
    }

    @Override
    public void unpinSegment(int segmentNo) {
        SegmentLock lock = (SegmentLock)this.segmentLockByFileNo.get(segmentNo);
        lock.unpin();
    }

    @Override
    public void init(HybridLog hlog) {
        this.hybridLog = (HybridLogImpl)hlog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSegmentOnDevice(int segmentNo) {
        Epoch epoch = this.hybridLog.getEpoch();
        boolean wasRegisteredToEpoch = epoch.isCurrentThreadRegistered();
        int threadIndex = wasRegisteredToEpoch ? epoch.getCurrentThreadIndex() : epoch.register();
        try {
            long lowSegmentAddress = this.segmentLowLogicalAddress(segmentNo);
            long highSegmentAddress = this.segmentLastLogicalAddress(segmentNo);
            boolean bl = !this.hybridLog.isRangeInMemoryOnAnyThread(lowSegmentAddress, highSegmentAddress);
            return bl;
        }
        finally {
            if (!wasRegisteredToEpoch) {
                epoch.unregister(threadIndex);
            }
        }
    }

    public int getSegmentCount() {
        return this.segmentLockByFileNo.size();
    }

    public void increaseCapacity(Capacity newCapacity) {
        this.compactionStats.increaseDeviceCapacity(newCapacity);
    }

    public Set<Integer> getFileNoSet() {
        return new HashSet<Integer>(this.segmentLockByFileNo.keySet());
    }

    public long getMaxLogFileSizeInBytes() {
        return this.compactionStats.getMaxLogFileSizeInBytes();
    }
}

