/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device;

import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.device.DeviceException;
import com.hazelcast.internal.tstore.device.HybridLogFileHandle;
import com.hazelcast.internal.tstore.device.HybridLogFileHandlePool;
import com.hazelcast.internal.tstore.device.HybridLogFileHandleProvider;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;

public class HybridLogFileHandlePoolImpl
implements HybridLogFileHandlePool {
    private static final int DEFAULT_MAX_DESIRED_OPEN_LOG_HANDLES = 128;
    private static final HazelcastProperty MAX_LOG_FILE_OPEN_HANDLES_COUNT = new HazelcastProperty("hazelcast.tiered.store.log.file.max.open.handles.count", 128);
    private final TreeMap<Long, HybridLogFileHandleList> poolMap = new TreeMap();
    private final Map<Long, Long> lruMap;
    private int openHandlesCount;
    private final ReentrantLock poolLock = new ReentrantLock();
    private final int maxLogFileOpenHandlesCount;
    private boolean closed;

    public HybridLogFileHandlePoolImpl(HazelcastProperties properties) {
        this.maxLogFileOpenHandlesCount = properties.getInteger(MAX_LOG_FILE_OPEN_HANDLES_COUNT);
        this.lruMap = new LinkedHashMap<Long, Long>(this.maxLogFileOpenHandlesCount, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HybridLogFileHandle getHandle(int deviceId, int fileNo, HybridLogFileHandleProvider handleProvider) {
        assert (fileNo >= 0);
        HybridLogFileHandle handle = null;
        this.poolLock.lock();
        this.checkClosed();
        try {
            long poolKey = HybridLogFileHandlePoolImpl.toPoolKey(deviceId, fileNo);
            HybridLogFileHandleList handleList = this.poolMap.get(poolKey);
            if (handleList != null) {
                assert (handleList.validateSize());
                handle = handleList.poll();
                if (handle != null) {
                    this.updateLruMap(poolKey);
                    HybridLogFileHandle hybridLogFileHandle = handle;
                    return hybridLogFileHandle;
                }
                handleList.increaseTotal();
                this.updateLruMap(poolKey);
            } else {
                handleList = new HybridLogFileHandleList();
                this.poolMap.put(poolKey, handleList);
                this.addToLruMap(poolKey);
            }
            ++this.openHandlesCount;
            assert (handleList.getAvailable() == 0);
        }
        finally {
            this.poolLock.unlock();
        }
        assert (handle == null);
        return handleProvider.createHybridLogFileHandle(fileNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseHandle(HybridLogFileHandle handle) {
        this.poolLock.lock();
        int deviceId = handle.getDeviceId();
        int fileNo = handle.getFileNo();
        long poolKey = HybridLogFileHandlePoolImpl.toPoolKey(deviceId, fileNo);
        HybridLogFileHandle coldHandle = null;
        try {
            if (this.closeHandleIfPoolIsClosed(handle)) {
                return;
            }
            HybridLogFileHandleList handleList = this.poolMap.get(poolKey);
            assert (handleList != null && handleList.validateSize());
            if (this.openHandlesCount <= this.maxLogFileOpenHandlesCount) {
                handleList.put(handle);
                assert (handleList.validateSize());
            } else {
                HybridLogFileHandleList coldHandleList = null;
                long coldPoolKey2 = -1L;
                for (long coldPoolKey2 : this.lruMap.keySet()) {
                    if (coldPoolKey2 == poolKey) continue;
                    coldHandleList = this.poolMap.get(coldPoolKey2);
                    assert (coldHandleList != null && coldHandleList.validateSize());
                    if (coldHandleList.getAvailable() == 0) continue;
                    coldHandle = coldHandleList.remove();
                    break;
                }
                if (coldHandle == null) {
                    handleList.decreaseTotal();
                    coldPoolKey2 = poolKey;
                    coldHandleList = handleList;
                    coldHandle = handle;
                } else {
                    handleList.put(handle);
                }
                assert (HybridLogFileHandlePoolImpl.toFileNoFromPoolKey(coldPoolKey2) >= 0);
                assert (coldHandleList != null);
                assert (coldHandle != null);
                if (coldHandleList.getTotal() == 0) {
                    this.poolMap.remove(coldPoolKey2);
                    this.removeFromLruList(coldPoolKey2);
                }
                --this.openHandlesCount;
                assert (this.openHandlesCount > 0);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (coldHandle != null) {
            coldHandle.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearHandles(int deviceId, int fromFileNo, int toFileNoInclusive) {
        Invariants.nonNegative(fromFileNo);
        Invariants.lessThanOrEqual(fromFileNo, toFileNoInclusive);
        LinkedList toRemove = new LinkedList();
        long poolKeyFrom = HybridLogFileHandlePoolImpl.toPoolKey(deviceId, fromFileNo);
        long poolKeyUpTo = HybridLogFileHandlePoolImpl.toPoolKey(deviceId, toFileNoInclusive);
        this.poolLock.lock();
        this.checkClosed();
        try {
            SortedMap<Long, HybridLogFileHandleList> range = toFileNoInclusive == Integer.MAX_VALUE ? this.poolMap.tailMap(poolKeyFrom) : this.poolMap.subMap(poolKeyFrom, poolKeyUpTo + 1L);
            range.forEach((poolKey, handleList) -> {
                int fileNo = HybridLogFileHandlePoolImpl.toFileNoFromPoolKey(poolKey);
                Invariants.inRange(fromFileNo, fileNo, toFileNoInclusive);
                assert (handleList.getTotal() == handleList.getAvailable());
                int total = handleList.getTotal();
                if (total == 0) {
                    assert (!this.lruMap.containsKey(poolKeyFrom));
                    assert (handleList.getAvailable() == 0);
                } else {
                    toRemove.addAll(handleList.removeAll());
                    this.removeFromLruList((long)poolKey);
                    this.openHandlesCount -= total;
                    Invariants.nonNegative(this.openHandlesCount);
                }
            });
            range.clear();
        }
        finally {
            this.poolLock.unlock();
            for (HybridLogFileHandle handle : toRemove) {
                handle.close();
            }
        }
    }

    @Override
    public void clearHandles(int deviceId, int upToFileNo) {
        this.clearHandles(deviceId, 0, upToFileNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.poolLock.lock();
        if (this.closed) {
            this.poolLock.unlock();
            return;
        }
        try {
            for (HybridLogFileHandleList handleList : this.poolMap.values()) {
                while (handleList.getAvailable() > 0) {
                    HybridLogFileHandle handle = handleList.remove();
                    handle.close();
                }
            }
            this.closed = true;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    int getMaxDesiredOpenLogHandles() {
        return this.maxLogFileOpenHandlesCount;
    }

    private boolean closeHandleIfPoolIsClosed(HybridLogFileHandle handle) {
        assert (this.poolLock.isHeldByCurrentThread());
        if (this.closed) {
            handle.close();
            return true;
        }
        return false;
    }

    int getOpenHandlesCount() {
        this.poolLock.lock();
        try {
            int n = this.openHandlesCount;
            return n;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCachedFreeHandlesCount() {
        int count = 0;
        this.poolLock.lock();
        try {
            for (HybridLogFileHandleList handleList : this.poolMap.values()) {
                count += handleList.getAvailable();
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return count;
    }

    private void updateLruMap(long poolKey) {
        Long value = this.lruMap.get(poolKey);
        assert (value != null);
    }

    private void addToLruMap(long poolKey) {
        assert (!this.lruMap.containsKey(poolKey));
        this.lruMap.put(poolKey, poolKey);
    }

    private void removeFromLruList(long poolKey) {
        Long value = this.lruMap.remove(poolKey);
        assert (value != null);
    }

    private void checkClosed() {
        assert (this.poolLock.isHeldByCurrentThread());
        if (this.closed) {
            this.poolLock.unlock();
            throw new DeviceException("HybridLog handles pool is closed");
        }
    }

    private static long toPoolKey(int deviceId, int fileNo) {
        return (long)deviceId << 32 | (long)fileNo & 0xFFFFFFFFL;
    }

    private static int toFileNoFromPoolKey(long poolKey) {
        return (int)poolKey;
    }

    private class HybridLogFileHandleList {
        private int total = 1;
        private final LinkedList<HybridLogFileHandle> handleList = new LinkedList();

        private HybridLogFileHandleList() {
        }

        boolean validateSize() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            assert (this.total > 0 && this.total >= this.handleList.size() && HybridLogFileHandlePoolImpl.this.openHandlesCount >= this.total) : "total=" + this.total + ", handleList.size()=" + this.handleList.size() + ", openHandlesCount=" + HybridLogFileHandlePoolImpl.this.openHandlesCount;
            return true;
        }

        int getAvailable() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            return this.handleList.size();
        }

        int getTotal() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            return this.total;
        }

        HybridLogFileHandle poll() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            return !this.handleList.isEmpty() ? this.handleList.poll() : null;
        }

        HybridLogFileHandle remove() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            assert (this.total > 0 && !this.handleList.isEmpty()) : "total=" + this.total + ", handleList.size()=" + this.handleList.size();
            HybridLogFileHandle handle = this.handleList.poll();
            --this.total;
            return handle;
        }

        Collection<HybridLogFileHandle> removeAll() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            assert (this.total > 0 && this.total == this.handleList.size()) : "total=" + this.total + ", handleList.size()=" + this.handleList.size();
            this.total = 0;
            return this.handleList;
        }

        void increaseTotal() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            ++this.total;
        }

        void decreaseTotal() {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            assert (this.total > 0);
            --this.total;
        }

        void put(HybridLogFileHandle handle) {
            assert (HybridLogFileHandlePoolImpl.this.poolLock.isHeldByCurrentThread());
            this.handleList.add(handle);
        }
    }
}

