/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.memory.MemoryUnit;
import java.util.concurrent.TimeUnit;

public final class ToHumanReadable {
    private ToHumanReadable() {
    }

    public static String bytesToString(long bytes) {
        long capacity = MemoryUnit.BYTES.toGigaBytes(bytes);
        String abbreviation = MemoryUnit.GIGABYTES.abbreviation();
        if (capacity == 0L) {
            capacity = MemoryUnit.BYTES.toMegaBytes(bytes);
            abbreviation = MemoryUnit.MEGABYTES.abbreviation();
            if (capacity == 0L) {
                capacity = MemoryUnit.BYTES.toKiloBytes(bytes);
                abbreviation = MemoryUnit.KILOBYTES.abbreviation();
                if (capacity == 0L) {
                    capacity = bytes;
                    abbreviation = MemoryUnit.BYTES.abbreviation();
                }
            }
        }
        return capacity + abbreviation;
    }

    public static String nanosToString(long nanos) {
        long elapsed = TimeUnit.NANOSECONDS.toSeconds(nanos);
        String abbreviation = "s";
        if (elapsed == 0L) {
            elapsed = TimeUnit.NANOSECONDS.toMillis(nanos);
            abbreviation = "ms";
            if (elapsed == 0L) {
                elapsed = TimeUnit.NANOSECONDS.toMicros(nanos);
                abbreviation = "\u00b5s";
                if (elapsed == 0L) {
                    elapsed = nanos;
                    abbreviation = "ns";
                }
            }
        }
        return elapsed + abbreviation;
    }
}

