/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

public class PartitionCompactorStateManager {
    private final AtomicReference<CompactorState> compactorState = new AtomicReference<CompactorState>(CompactorState.INITIAL);
    private volatile CompletableFuture compactorStateFuture;

    public CompletableFuture requestCompactorToStop() {
        this.compactorStateFuture = new CompletableFuture();
        if (this.compactorState.compareAndSet(CompactorState.INITIAL, CompactorState.STOPPED)) {
            this.compactorStateFuture.complete(CompactorState.STOPPED);
            return this.compactorStateFuture;
        }
        if (this.compactorState.compareAndSet(CompactorState.RUNNING, CompactorState.STOP_REQUESTED)) {
            return this.compactorStateFuture;
        }
        if (this.compactorState.get() == CompactorState.STOP_REQUESTED) {
            return this.compactorStateFuture;
        }
        if (this.compactorState.get() == CompactorState.STOPPED) {
            this.compactorStateFuture.complete(CompactorState.STOPPED);
            return this.compactorStateFuture;
        }
        throw new IllegalStateException(String.format("Execution should never reach here [currentState=%s", new Object[]{this.compactorState.get()}));
    }

    public boolean isInStateRunning() {
        return this.compactorState.get() == CompactorState.RUNNING;
    }

    public void trySetCompactorStateToStopped() {
        this.compactorState.compareAndSet(CompactorState.RUNNING, CompactorState.INITIAL);
        if (this.compactorState.compareAndSet(CompactorState.STOP_REQUESTED, CompactorState.STOPPED)) {
            this.compactorStateFuture.complete(CompactorState.STOPPED);
        }
    }

    public void trySetCompactorStateBackToInitial() {
        this.compactorState.compareAndSet(CompactorState.STOPPED, CompactorState.INITIAL);
    }

    public void trySetToStateRunning() {
        this.compactorState.compareAndSet(CompactorState.INITIAL, CompactorState.RUNNING);
    }

    public CompactorState getCurrentCompactorState() {
        return this.compactorState.get();
    }

    public CompletableFuture getCompactorStateFuture() {
        return this.compactorStateFuture;
    }

    static enum CompactorState {
        INITIAL,
        RUNNING,
        STOP_REQUESTED,
        STOPPED;

    }
}

