/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.compaction.AbstractLogBasedCompactor;
import com.hazelcast.internal.tstore.device.local.LocalStorageDevice;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;
import com.hazelcast.spi.properties.HazelcastProperties;

public final class PartitionCompactor
extends AbstractLogBasedCompactor {
    private boolean hasNext = true;
    private boolean firstCompaction = true;

    public PartitionCompactor(TieredStoreRecordAccessor recordAccessor, HybridLogImpl hybridLog, Index index, int segmentNo, HazelcastProperties properties) {
        super(recordAccessor, hybridLog, index, segmentNo, properties);
        this.onCompactionQueued();
    }

    @Override
    public void compact(boolean withTimeout) {
        assert (!this.logIterator.isClosed());
        Throwable throwable = null;
        long startCompactionNanos = System.nanoTime();
        if (this.firstCompaction) {
            this.firstCompaction = false;
            this.onCompactionStart();
        }
        try {
            this.setLastVisitedRecordCount(0);
            this.threadIndex = this.log.getEpoch().getCurrentThreadIndex();
            this.assertCompactionDoesNotHappenInMemoryRegion();
            int visitedRecordCounter = 0;
            long startNanos = System.nanoTime();
            this.trySetToStateRunning();
            if (this.isInStateRunning() && this.index.size() == 0L) {
                this.hasNext = false;
                return;
            }
            while (this.isInStateRunning()) {
                this.failIfInterrupted();
                if (!this.logIterator.hasNext()) {
                    this.hasNext = false;
                    break;
                }
                this.compact((TieredStoreRecord)this.logIterator.next());
                ++visitedRecordCounter;
                if (!this.isTimedOut(startNanos, withTimeout)) continue;
            }
            this.setLastVisitedRecordCount(visitedRecordCounter);
        }
        catch (Throwable ex) {
            throwable = ex;
            this.logger.warning(this.toReadableStr(ex));
            throw ex;
        }
        finally {
            if (!this.hasNext) {
                this.logIterator.close();
                this.doTriggerSegmentsDeletion();
                this.device.onSegmentCompacted(this.segmentNo);
                ((LocalStorageDevice)this.device).getCompactionStats().decrementCurrentOnDeviceSegmentCount();
            }
            this.trySetCompactorStateToStopped();
            this.metrics.addCompactionDuration(System.nanoTime() - startCompactionNanos);
            if (throwable != null) {
                this.onCompactionFinish(throwable);
            } else if (!this.hasNext) {
                this.onCompactionFinish(null);
            }
        }
    }

    @Override
    protected void doTriggerSegmentsDeletion() {
        this.pauseEpoch(this.threadIndex);
        try {
            this.device.truncate(this.segmentNo);
        }
        finally {
            this.resumeEpoch(this.threadIndex);
        }
    }
}

