/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.State;
import com.hazelcast.internal.tstore.compaction.CompactionManager;
import com.hazelcast.internal.tstore.compaction.Compactor;
import com.hazelcast.internal.tstore.compaction.CompactorConstructorFn;
import com.hazelcast.internal.tstore.compaction.FullCompactor;
import com.hazelcast.internal.tstore.compaction.IncrementalCompactor;
import com.hazelcast.internal.tstore.compaction.LogBasedHLogCompactor;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;
import com.hazelcast.spi.properties.HazelcastProperties;

public class LogBasedHLogCompactorConstructorFn
implements CompactorConstructorFn {
    private final TieredStoreRecordAccessor recordAccessor;
    private final HybridLogImpl hybridLog;
    private final Index index;
    private final State state;
    private final Epoch epoch;
    private final CompactionManager compactionManager;
    private final HazelcastProperties properties;

    public LogBasedHLogCompactorConstructorFn(CompactionManager compactionManager, TieredStoreRecordAccessor recordAccessor, HybridLogImpl hybridLog, Index index, State state, HazelcastProperties properties) {
        this.recordAccessor = recordAccessor;
        this.hybridLog = hybridLog;
        this.index = index;
        this.state = state;
        this.epoch = hybridLog.getEpoch();
        this.compactionManager = compactionManager;
        this.properties = properties;
    }

    @Override
    public Compactor<?> newIncrementalCompactor(int segmentNo) throws UnsupportedOperationException {
        return new LogBasedHLogCompactor(this.compactionManager, this.recordAccessor, this.hybridLog, this.index, this.state, this.epoch, segmentNo, this.properties);
    }

    @Override
    public Compactor<?> newFullCompactor() throws UnsupportedOperationException {
        assert (!this.isFullSupported());
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isIncrementalSupported() {
        return IncrementalCompactor.class.isAssignableFrom(LogBasedHLogCompactor.class);
    }

    @Override
    public boolean isFullSupported() {
        return FullCompactor.class.isAssignableFrom(LogBasedHLogCompactor.class);
    }
}

