/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.State;
import com.hazelcast.internal.tstore.compaction.Compactor;
import com.hazelcast.internal.tstore.compaction.CompactorConstructorFn;
import com.hazelcast.internal.tstore.compaction.FullCompactor;
import com.hazelcast.internal.tstore.compaction.IncrementalCompactor;
import com.hazelcast.internal.tstore.compaction.IndexBasedHLogCompactor;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.index.Index;

public class IndexBasedHLogCompactorConstructorFn
implements CompactorConstructorFn {
    private final Index index;
    private final HybridLogImpl log;
    private final Device device;
    private final State state;
    private final Epoch epoch;

    public IndexBasedHLogCompactorConstructorFn(Index index, State state, HybridLogImpl log) {
        this.index = index;
        this.log = log;
        this.device = log.getDevice();
        this.epoch = log.getEpoch();
        this.state = state;
    }

    @Override
    public Compactor<?> newIncrementalCompactor(int segmentNo) throws UnsupportedOperationException {
        assert (!this.isFullSupported());
        throw new UnsupportedOperationException();
    }

    @Override
    public Compactor<?> newFullCompactor() throws UnsupportedOperationException {
        return new IndexBasedHLogCompactor(this.index, this.state, this.log, this.device, this.epoch);
    }

    @Override
    public boolean isIncrementalSupported() {
        return IncrementalCompactor.class.isAssignableFrom(IndexBasedHLogCompactor.class);
    }

    @Override
    public boolean isFullSupported() {
        return FullCompactor.class.isAssignableFrom(IndexBasedHLogCompactor.class);
    }
}

