/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.compaction.CompactorMetrics;

class HybridLogCompactorMetrics
implements CompactorMetrics {
    private long dummyRecordsCnt;
    private long dummyRecordsSize;
    private long nonDummyRecordsCnt;
    private long nonDummyRecordsSize;
    private long aliveRecordsCnt;
    private long aliveRecordsSize;
    private long deadRecordsCnt;
    private long deadRecordsSize;
    private long compactionDurationNs;
    private long ioTimeToCheckIndexReachabilityNanos;

    HybridLogCompactorMetrics() {
    }

    void addCompactionDuration(long durationNanos) {
        this.compactionDurationNs += durationNanos;
    }

    void onVisitedDummyRecord(int size) {
        ++this.dummyRecordsCnt;
        this.dummyRecordsSize += (long)size;
    }

    void onVisitedNonDummyRecord(int size) {
        ++this.nonDummyRecordsCnt;
        this.nonDummyRecordsSize += (long)size;
    }

    void onVisitedIndexReachableRecord(int size) {
        ++this.aliveRecordsCnt;
        this.aliveRecordsSize += (long)size;
    }

    void onVisitedRecordIsNotIndexReachable(int size) {
        ++this.deadRecordsCnt;
        this.deadRecordsSize += (long)size;
    }

    void onIOTimeToCheckIndexReachability(long nanos) {
        this.ioTimeToCheckIndexReachabilityNanos += nanos;
    }

    String readableMetrics() {
        String newLine = System.lineSeparator() + "\t";
        return System.lineSeparator() + "HybridLogCompactorMetrics:" + newLine + "dummyRecords=" + this.dummyRecordsCnt + newLine + "dummyRecordsSize=" + this.dummyRecordsSize + newLine + "nonDummyRecords=" + this.nonDummyRecordsCnt + newLine + "nonDummyRecordsSize=" + this.nonDummyRecordsSize + newLine + "recordsIteratedOver=" + this.getVisitedRecordsCnt() + newLine + "recordsIteratedOverSize=" + this.getVisitedRecordsSize() + newLine + "aliveRecords=" + this.aliveRecordsCnt + newLine + "aliveRecordsSize=" + this.aliveRecordsSize + newLine + "deadRecords=" + this.deadRecordsCnt + newLine + "deadRecordsSize=" + this.deadRecordsSize + newLine + "indexReachabilityIOTime=" + String.format("%.3f", (double)this.ioTimeToCheckIndexReachabilityNanos / 1000000.0) + " millis." + newLine + "compactionTime=" + String.format("%.3f", (double)this.getCompactionTimeNs() / 1000000.0) + " millis.";
    }

    @Override
    public long getDummyRecordsCnt() {
        return this.dummyRecordsCnt;
    }

    @Override
    public long getNonDummyRecordsCnt() {
        return this.nonDummyRecordsCnt;
    }

    @Override
    public long getAliveRecordsCnt() {
        return this.aliveRecordsCnt;
    }

    @Override
    public long getDeadRecordsCnt() {
        return this.deadRecordsCnt;
    }

    @Override
    public long getVisitedRecordsCnt() {
        return this.dummyRecordsCnt + this.nonDummyRecordsCnt;
    }

    @Override
    public long getVisitedRecordsSize() {
        return this.dummyRecordsSize + this.nonDummyRecordsSize;
    }

    @Override
    public long getCompactionTimeNs() {
        return this.compactionDurationNs;
    }

    @Override
    public long getIoTimeNanos() {
        return this.ioTimeToCheckIndexReachabilityNanos;
    }

    @Override
    public long getDummyRecordsSize() {
        return this.dummyRecordsSize;
    }

    @Override
    public long getNonDummyRecordsSize() {
        return this.nonDummyRecordsSize;
    }

    @Override
    public long getAliveRecordsSize() {
        return this.aliveRecordsSize;
    }

    @Override
    public long getDeadRecordsSize() {
        return this.deadRecordsSize;
    }
}

