/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.compaction.CompactionStats;
import com.hazelcast.internal.tstore.compaction.ToHumanReadable;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.device.DeviceOutOfCapacityException;
import com.hazelcast.internal.tstore.device.local.LocalStorageDevice;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.EntryRemovingProcessor;
import com.hazelcast.map.impl.operation.BaseRemoveOperation;
import com.hazelcast.map.impl.operation.ClearBackupOperation;
import com.hazelcast.map.impl.operation.ClearOperation;
import com.hazelcast.map.impl.operation.EvictAllBackupOperation;
import com.hazelcast.map.impl.operation.EvictAllOperation;
import com.hazelcast.map.impl.operation.EvictBackupOperation;
import com.hazelcast.map.impl.operation.EvictOperation;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.RemoveBackupOperation;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;

final class DeviceCapacityChecker {
    private DeviceCapacityChecker() {
    }

    static void failOrForgetOutOfCapacity(State state, HybridLog hybridLog, long beforeCompactionPartitionGarbageInBytes, long afterCompactionPartitionGarbageInBytes) {
        EntryProcessor entryProcessor;
        CompactionStats compactionStats = DeviceCapacityChecker.getCompactionStats(hybridLog);
        if (!compactionStats.isOverNodeHardDeviceCapacity()) {
            return;
        }
        MapOperation mapOperation = state.getOperation();
        if (DeviceCapacityChecker.isAllowed(mapOperation, entryProcessor = state.getEntryProcessor())) {
            return;
        }
        DeviceCapacityChecker.throwDeviceOutOfCapacityException(mapOperation, hybridLog, beforeCompactionPartitionGarbageInBytes, afterCompactionPartitionGarbageInBytes);
    }

    private static void throwDeviceOutOfCapacityException(MapOperation mapOperation, HybridLog hybridLog, long beforeCompactionPartitionGarbageInBytes, long afterCompactionPartitionGarbageInBytes) {
        long compactionFreedInBytes = beforeCompactionPartitionGarbageInBytes - afterCompactionPartitionGarbageInBytes;
        String msg = "No remaining capacity for map=%s, op=%s, device=[name=%s, max=%s, used=%s], partition=[id=%d, replica=%d, used=%s, " + (compactionFreedInBytes >= 0L ? "freed" : "increased") + "=%s(%s->%s)]";
        Device device = DeviceCapacityChecker.getDevice(hybridLog);
        String deviceName = device.deviceName();
        String mapName = mapOperation.getName();
        String opName = mapOperation.getClass().getSimpleName();
        int partitionId = mapOperation.getPartitionId();
        int replicaIndex = mapOperation.getReplicaIndex();
        CompactionStats compactionStats = DeviceCapacityChecker.getCompactionStats(hybridLog);
        throw new DeviceOutOfCapacityException(String.format(msg, mapName, opName, deviceName, ToHumanReadable.bytesToString(compactionStats.getHardDeviceCapacityInBytes()), ToHumanReadable.bytesToString(compactionStats.getUsedDeviceCapacityInBytes()), partitionId, replicaIndex, ToHumanReadable.bytesToString(device.getMetrics().getDeviceUsageInBytes()), ToHumanReadable.bytesToString(Math.abs(compactionFreedInBytes)), ToHumanReadable.bytesToString(beforeCompactionPartitionGarbageInBytes), ToHumanReadable.bytesToString(afterCompactionPartitionGarbageInBytes)));
    }

    private static boolean isAllowed(MapOperation operation, EntryProcessor<?, ?, ?> processor) {
        if (operation instanceof ClearOperation || operation instanceof ClearBackupOperation) {
            return true;
        }
        if (operation instanceof BaseRemoveOperation || operation instanceof RemoveBackupOperation) {
            return true;
        }
        if (operation instanceof EvictOperation || operation instanceof EvictBackupOperation) {
            return true;
        }
        if (operation instanceof EvictAllOperation || operation instanceof EvictAllBackupOperation) {
            return true;
        }
        if (processor instanceof EntryRemovingProcessor) {
            return true;
        }
        if (operation instanceof BackupOperation) {
            return false;
        }
        return !(operation instanceof MutatingOperation);
    }

    private static CompactionStats getCompactionStats(HybridLog hybridLog) {
        Device device = DeviceCapacityChecker.getDevice(hybridLog);
        return ((LocalStorageDevice)device).getCompactionStats();
    }

    private static Device getDevice(HybridLog hybridLog) {
        return ((HybridLogImpl)hybridLog).getDevice();
    }
}

