/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.compaction.Compactor;
import com.hazelcast.spi.properties.HazelcastProperties;

public class CompactorFlags {
    private final boolean compactorsEnabled;
    private final boolean incrementalCompactorEnabled;
    private final boolean fullCompactorEnabled;
    private final boolean partitionCompactorEnabled;

    public CompactorFlags(HazelcastProperties properties) {
        this.compactorsEnabled = properties.getBoolean(Compactor.COMPACTORS_ENABLED);
        this.incrementalCompactorEnabled = properties.getBoolean(Compactor.INCREMENTAL_COMPACTOR_ENABLED);
        this.fullCompactorEnabled = properties.getBoolean(Compactor.FULL_COMPACTOR_ENABLED);
        this.partitionCompactorEnabled = properties.getBoolean(Compactor.PARTITION_COMPACTOR_ENABLED);
    }

    public boolean isIncrementalCompactorEnabled() {
        return this.compactorsEnabled && this.incrementalCompactorEnabled;
    }

    public boolean isFullCompactorEnabled() {
        return this.compactorsEnabled && this.fullCompactorEnabled;
    }

    public boolean isPartitionCompactorEnabled() {
        return this.compactorsEnabled && this.partitionCompactorEnabled;
    }

    public boolean isCompactorsEnabled() {
        return this.compactorsEnabled;
    }
}

