/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.compaction.CompactionManager;
import com.hazelcast.internal.tstore.compaction.CompactorFlags;
import com.hazelcast.internal.tstore.compaction.CompactorFutureTask;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.memory.Capacity;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class CompactionStats {
    private static final AtomicLongFieldUpdater<CompactionStats> USED_DEVICE_CAPACITY_IN_BYTES = AtomicLongFieldUpdater.newUpdater(CompactionStats.class, "usedDeviceCapacityInBytes");
    private static final long DEFAULT_MAX_LOG_FILE_SIZE_IN_MB = 8L;
    public static final HazelcastProperty MAX_LOG_FILE_SIZE_IN_MB = new HazelcastProperty("hazelcast.tiered.store.log.file.max.size.in.mb", 8L);
    private static final double DEFAULT_SOFT_DEVICE_CAPACITY_PERCENTAGE = 0.9;
    private static final HazelcastProperty SOFT_DEVICE_CAPACITY_PERCENTAGE = new HazelcastProperty("hazelcast.tiered.store.compaction.starting.device.usage.percentage", 0.9);
    private final int maxOnDeviceSegmentCount;
    private final long maxLogFileSizeInBytes;
    private final CompactorFlags compactorFlags;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private final List<Device>[] partitionDevices;
    private final CompactionManager compactionManager;
    private final AtomicBoolean isCompactionOnGoing = new AtomicBoolean();
    private final AtomicInteger currentOnDeviceSegmentCount = new AtomicInteger();
    private final HazelcastProperties properties;
    private volatile long usedDeviceCapacityInBytes;
    private volatile long hardDeviceCapacityInBytes;
    private volatile long sofDeviceCapacityInBytes;

    public CompactionStats(CompactionManager compactionManager, long configuredDeviceCapacityInBytes, int partitionCount, HazelcastProperties properties) {
        this.maxLogFileSizeInBytes = MemoryUnit.MEGABYTES.toBytes(properties.getLong(MAX_LOG_FILE_SIZE_IN_MB));
        Invariants.lessThanOrEqual(this.maxLogFileSizeInBytes, Integer.MAX_VALUE);
        this.maxOnDeviceSegmentCount = (int)(configuredDeviceCapacityInBytes / this.maxLogFileSizeInBytes / 2L);
        List[] devices = new List[partitionCount];
        for (int i = 0; i < partitionCount; ++i) {
            devices[i] = new ArrayList(1);
        }
        this.partitionDevices = devices;
        this.compactorFlags = new CompactorFlags(properties);
        this.compactionManager = compactionManager;
        this.properties = properties;
        this.setHardAndSoftDeviceCapacity(configuredDeviceCapacityInBytes);
    }

    private void setHardAndSoftDeviceCapacity(long configuredDeviceCapacityInBytes) {
        this.hardDeviceCapacityInBytes = configuredDeviceCapacityInBytes;
        double softDeviceCapacityPercentage = this.properties.getDouble(SOFT_DEVICE_CAPACITY_PERCENTAGE);
        Preconditions.checkTrue(softDeviceCapacityPercentage > 0.0 && softDeviceCapacityPercentage <= 1.0, "softDeviceCapacityPercentage can be between 0 and 1(inclusive). Valid examples: 0.1, 0.8 or 1.0");
        this.sofDeviceCapacityInBytes = (long)((double)this.hardDeviceCapacityInBytes * softDeviceCapacityPercentage);
    }

    public void updateUsedDeviceCapacityInBytes(long bytes) {
        USED_DEVICE_CAPACITY_IN_BYTES.addAndGet(this, bytes);
    }

    public long getMaxLogFileSizeInBytes() {
        return this.maxLogFileSizeInBytes;
    }

    public CompactorFlags getCompactorFlags() {
        return this.compactorFlags;
    }

    public void registerDevice(Device device) {
        int partitionId = device.partitionId();
        this.writeLock.lock();
        try {
            this.partitionDevices[partitionId].add(device);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterDevice(Device device) {
        this.writeLock.lock();
        try {
            List<Device> devices = this.partitionDevices[device.partitionId()];
            int idx = devices.indexOf(device);
            if (idx == devices.size() - 1) {
                devices.remove(idx);
                return;
            }
            Collections.swap(devices, idx, devices.size() - 1);
            devices.remove(devices.size() - 1);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void onNewSegment() {
        this.currentOnDeviceSegmentCount.incrementAndGet();
        if (!this.hasMoreSegmentThanDeviceCapacity()) {
            return;
        }
        if (this.compactorFlags.isPartitionCompactorEnabled()) {
            return;
        }
        if (this.compactorFlags.isFullCompactorEnabled()) {
            this.tryFullCompaction();
            return;
        }
        if (this.compactorFlags.isIncrementalCompactorEnabled()) {
            this.tryIncrementalCompaction();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryIncrementalCompaction() {
        if (this.isCompactionOnGoing.getAndSet(true)) {
            return;
        }
        this.readLock.lock();
        try {
            int count = this.currentOnDeviceSegmentCount.get();
            while (count > 0) {
                for (List<Device> devices : this.partitionDevices) {
                    for (Device device : devices) {
                        Integer segmentNo = device.pollFileNoToCompact();
                        if (segmentNo == null) continue;
                        this.doIncrementalCompaction(device.userId(), device.partitionId(), segmentNo);
                        --count;
                    }
                }
            }
        }
        finally {
            this.readLock.unlock();
            boolean oldValue = this.isCompactionOnGoing.getAndSet(false);
            assert (oldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryFullCompaction() {
        if (this.isCompactionOnGoing.getAndSet(true)) {
            return;
        }
        this.readLock.lock();
        try {
            this.currentOnDeviceSegmentCount.set(0);
            for (List<Device> devices : this.partitionDevices) {
                for (Device device : devices) {
                    this.compactionManager.runCompactionFull(device.userId(), device.partitionId());
                }
            }
        }
        finally {
            this.readLock.unlock();
            boolean oldValue = this.isCompactionOnGoing.getAndSet(false);
            assert (oldValue);
        }
    }

    public void decrementCurrentOnDeviceSegmentCount() {
        this.currentOnDeviceSegmentCount.decrementAndGet();
    }

    public boolean hasMoreSegmentThanDeviceCapacity() {
        return this.currentOnDeviceSegmentCount.get() + 1 >= this.maxOnDeviceSegmentCount;
    }

    public boolean isOverNodeHardDeviceCapacity() {
        return this.usedDeviceCapacityInBytes >= this.hardDeviceCapacityInBytes;
    }

    public boolean isOverNodeSoftDeviceCapacity() {
        return this.usedDeviceCapacityInBytes >= this.sofDeviceCapacityInBytes;
    }

    public long getUsedDeviceCapacityInBytes() {
        return this.usedDeviceCapacityInBytes;
    }

    public long getHardDeviceCapacityInBytes() {
        return this.hardDeviceCapacityInBytes;
    }

    public long getSofDeviceCapacityInBytes() {
        return this.sofDeviceCapacityInBytes;
    }

    public void doIncrementalCompaction(TStoreUserId userId, int partitionId, int segmentNo) {
        Invariants.isTrue(this.compactorFlags.isIncrementalCompactorEnabled(), "Enable incrementalCompactionEnabled");
        this.compactionManager.runCompactionIncremental(userId, partitionId, segmentNo);
        this.currentOnDeviceSegmentCount.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<CompactorFutureTask> triggerLogBasedCompaction(int partitionId) {
        this.readLock.lock();
        try {
            ArrayList<CompactorFutureTask> futures = new ArrayList<CompactorFutureTask>();
            List<Device> devices = this.partitionDevices[partitionId];
            for (Device device : devices) {
                Integer segmentNo;
                while ((segmentNo = device.pollFileNoToCompact()) != null) {
                    Invariants.equals(partitionId, device.partitionId());
                    futures.add((CompactorFutureTask)this.compactionManager.runCompactionIncremental(device.userId(), device.partitionId(), segmentNo));
                }
            }
            ArrayList<CompactorFutureTask> arrayList = futures;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<CompactorFutureTask> triggerIndexBasedCompaction(int partitionId) {
        this.readLock.lock();
        try {
            List<Device> devices = this.partitionDevices[partitionId];
            ArrayList<CompactorFutureTask> futures = new ArrayList<CompactorFutureTask>(devices.size());
            for (Device device : devices) {
                Invariants.equals(partitionId, device.partitionId());
                Future<Void> voidFuture = this.compactionManager.runCompactionFull(device.userId(), device.partitionId());
                futures.add((CompactorFutureTask)voidFuture);
            }
            ArrayList<CompactorFutureTask> arrayList = futures;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    List<Device>[] getPartitionDevices() {
        return this.partitionDevices;
    }

    public boolean canTryIncrementalCompaction() {
        if (this.compactorFlags.isPartitionCompactorEnabled()) {
            return false;
        }
        if (this.compactorFlags.isFullCompactorEnabled()) {
            return false;
        }
        return this.compactorFlags.isIncrementalCompactorEnabled();
    }

    public void increaseDeviceCapacity(Capacity newCapacity) {
        long newCapacityInBytes = newCapacity.bytes();
        assert (newCapacityInBytes >= this.hardDeviceCapacityInBytes);
        this.setHardAndSoftDeviceCapacity(newCapacityInBytes);
    }

    public String toString() {
        return "CompactionStats{maxOnDeviceSegmentCount=" + this.maxOnDeviceSegmentCount + ", maxLogFileSizeInBytes=" + this.maxLogFileSizeInBytes + ", hardDeviceCapacityInBytes=" + this.hardDeviceCapacityInBytes + ", sofDeviceCapacityInBytes=" + this.sofDeviceCapacityInBytes + ", usedDeviceCapacityInBytes=" + this.usedDeviceCapacityInBytes + ", currentOnDeviceSegmentCount=" + String.valueOf(this.currentOnDeviceSegmentCount) + ", compactorFlags=" + String.valueOf(this.compactorFlags) + ", isCompactionOnGoing=" + String.valueOf(this.isCompactionOnGoing) + "}";
    }
}

