/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.compaction.Compactor;
import com.hazelcast.internal.tstore.compaction.CompactorConstructorFn;
import com.hazelcast.internal.tstore.compaction.CompactorExecutorImpl;
import com.hazelcast.internal.tstore.compaction.CompactorScheduler;
import com.hazelcast.internal.tstore.compaction.CompactorSchedulerImpl;
import com.hazelcast.internal.tstore.compaction.LogBasedCompactor;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class CompactionManager {
    private final int partitionCount;
    private final CompactorScheduler scheduler;
    private final CompactorExecutorImpl executor;
    private final AtomicLong compactorLastSN = new AtomicLong();
    private final Map<TStoreUserId, CompactorConstructorFns> userIdToCompactorConstructorFns;
    private final NavigableMap<Long, LogBasedCompactor> activeCompactors = new ConcurrentSkipListMap<Long, LogBasedCompactor>();
    private final NavigableMap<Long, LogBasedCompactor> finishedCompactors = new ConcurrentSkipListMap<Long, LogBasedCompactor>();
    private boolean terminated;

    public CompactionManager(int partitionCount, HazelcastProperties properties, String hzName) {
        int threadCount = properties.getInteger(Compactor.COMPACTOR_THREAD_COUNT);
        this.partitionCount = partitionCount;
        this.userIdToCompactorConstructorFns = new ConcurrentHashMap<TStoreUserId, CompactorConstructorFns>(1);
        this.executor = new CompactorExecutorImpl(threadCount, hzName);
        this.scheduler = new CompactorSchedulerImpl(this.executor, hzName);
    }

    public void addCompactorConstructorFn(TStoreUserId userId, int partitionId, CompactorConstructorFn constructorFn) {
        boolean success;
        while (!(success = this.userIdToCompactorConstructorFns.computeIfAbsent(userId, uid -> new CompactorConstructorFns(this.partitionCount)).addConstructorFn(partitionId, constructorFn))) {
        }
    }

    public void removeCompactorConstructorFn(TStoreUserId userId, int partitionId, CompactorConstructorFn constructorFn) {
        CompactorConstructorFns compactorConstructorFns = this.userIdToCompactorConstructorFns.get(userId);
        boolean lastConstructorGotRemoved = compactorConstructorFns.removeConstructorFnAndTryDispose(partitionId, constructorFn);
        if (lastConstructorGotRemoved) {
            this.userIdToCompactorConstructorFns.remove(userId, compactorConstructorFns);
        }
    }

    public synchronized Future<Void> runCompactionIncremental(TStoreUserId userId, int partitionId, int segmentNo) {
        if (this.terminated) {
            throw new IllegalStateException("compaction manager has been terminated");
        }
        CompactorConstructorFn fn = this.userIdToCompactorConstructorFns.get(userId).incrementalCompactorConstructorFnOrNull(partitionId);
        assert (fn != null);
        Compactor<?> compactor = fn.newIncrementalCompactor(segmentNo);
        return this.scheduler.schedule(compactor, CompactorScheduler.Priority.MEDIUM);
    }

    public synchronized Future<Void> runCompactionFull(TStoreUserId userId, int partitionId) {
        if (this.terminated) {
            throw new IllegalStateException("compaction manager has been terminated");
        }
        CompactorConstructorFn fn = this.userIdToCompactorConstructorFns.get(userId).fullCompactorConstructorFnOrNull(partitionId);
        assert (fn != null);
        Compactor<?> compactor = fn.newFullCompactor();
        return this.scheduler.schedule(compactor, CompactorScheduler.Priority.MEDIUM);
    }

    public synchronized void terminate() {
        if (this.terminated) {
            throw new IllegalStateException("compaction manager has been already terminated");
        }
        this.terminated = true;
        this.scheduler.terminate();
        this.executor.terminate();
    }

    long addActiveCompactor(LogBasedCompactor compactor) {
        long startSN = this.compactorLastSN.getAndIncrement();
        this.activeCompactors.put(startSN, compactor);
        return startSN;
    }

    void removeActiveCompactor(long startSN) {
        this.activeCompactors.remove(startSN);
    }

    void addFinishedCompactor(LogBasedCompactor compactor) {
        long finishSN = this.compactorLastSN.getAndIncrement();
        this.finishedCompactors.put(finishSN, compactor);
    }

    void removeFinishedCompactor(long finishSN) {
        this.finishedCompactors.remove(finishSN);
    }

    void truncateSegmentsSafely() {
        long leastActiveSN = Long.MAX_VALUE;
        Map.Entry<Long, LogBasedCompactor> leastActiveEntry = this.activeCompactors.firstEntry();
        if (leastActiveEntry != null) {
            leastActiveSN = leastActiveEntry.getKey();
        }
        SortedMap<Long, LogBasedCompactor> safeCompactors = this.finishedCompactors.headMap(leastActiveSN);
        for (Map.Entry entry : safeCompactors.entrySet()) {
            LogBasedCompactor compactor = (LogBasedCompactor)entry.getValue();
            compactor.triggerSegmentsDeletion();
            this.removeFinishedCompactor((Long)entry.getKey());
        }
    }

    Map<TStoreUserId, CompactorConstructorFns> getConstructorFns() {
        return this.userIdToCompactorConstructorFns;
    }

    static class CompactorConstructorFns {
        private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        private final Lock rLock = this.rwLock.readLock();
        private final Lock wLock = this.rwLock.writeLock();
        private final List<CompactorConstructorFn>[] partitionConstructors;
        private int totalConstructorsCnt;

        CompactorConstructorFns(int partitionCnt) {
            this.partitionConstructors = new List[partitionCnt];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addConstructorFn(int partitionId, CompactorConstructorFn constructorFn) {
            this.wLock.lock();
            try {
                if (this.isDisposed()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.partitionConstructors[partitionId] == null) {
                    this.partitionConstructors[partitionId] = new LinkedList<CompactorConstructorFn>();
                }
                this.partitionConstructors[partitionId].add(constructorFn);
                ++this.totalConstructorsCnt;
                boolean bl = true;
                return bl;
            }
            finally {
                this.wLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeConstructorFnAndTryDispose(int partitionId, CompactorConstructorFn constructorFn) {
            this.wLock.lock();
            try {
                if (this.isDisposed()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.partitionConstructors[partitionId].remove(constructorFn)) {
                    --this.totalConstructorsCnt;
                }
                if (this.totalConstructorsCnt == 0) {
                    this.totalConstructorsCnt = -1;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.wLock.unlock();
            }
        }

        List<CompactorConstructorFn>[] getConstructors() {
            return this.partitionConstructors;
        }

        private boolean isDisposed() {
            return this.totalConstructorsCnt < 0;
        }

        CompactorConstructorFn incrementalCompactorConstructorFnOrNull(int partitionId) {
            return this.getConstructorFn(partitionId, true);
        }

        CompactorConstructorFn fullCompactorConstructorFnOrNull(int partitionId) {
            return this.getConstructorFn(partitionId, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompactorConstructorFn getConstructorFn(int partitionId, boolean incremental) {
            this.rLock.lock();
            try {
                if (this.isDisposed()) {
                    CompactorConstructorFn compactorConstructorFn = null;
                    return compactorConstructorFn;
                }
                for (CompactorConstructorFn fn : this.partitionConstructors[partitionId]) {
                    if (incremental && fn.isIncrementalSupported()) {
                        CompactorConstructorFn compactorConstructorFn = fn;
                        return compactorConstructorFn;
                    }
                    if (incremental || !fn.isFullSupported()) continue;
                    CompactorConstructorFn compactorConstructorFn = fn;
                    return compactorConstructorFn;
                }
                Iterator<CompactorConstructorFn> iterator = null;
                return iterator;
            }
            finally {
                this.rLock.unlock();
            }
        }
    }
}

