/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.compaction.HybridLogCompactorMetrics;
import com.hazelcast.internal.tstore.compaction.LogBasedCompactor;
import com.hazelcast.internal.tstore.hybridlog.AddressRemapper;
import com.hazelcast.internal.tstore.hybridlog.HybridLogIteratorType;
import com.hazelcast.internal.tstore.hybridlog.impl.AddressRemapperImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.LogBasedHybridLogIterator;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.impl.record.GuardedTieredStoreRecordAccessor;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;
import com.hazelcast.map.impl.record.TieredStoreSlotAccessor;
import com.hazelcast.map.impl.record.UnguardedTieredStoreRecordAccessor;
import com.hazelcast.spi.properties.HazelcastProperties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class AbstractLogBasedCompactor
extends LogBasedCompactor<TieredStoreRecord> {
    protected final ILogger logger;
    protected final Index index;
    protected final HybridLogImpl log;
    protected final TieredStoreSlotAccessor slotAccessor;
    protected final TieredStoreRecordAccessor recordAccessor;
    protected final AddressRemapper<TieredStoreRecord> addressRemapper;
    protected final HybridLogCompactorMetrics metrics = new HybridLogCompactorMetrics();
    protected final LogBasedHybridLogIterator<TieredStoreRecord, TieredStoreRecord> logIterator;
    protected int threadIndex;

    protected AbstractLogBasedCompactor(TieredStoreRecordAccessor recordAccessor, HybridLogImpl hybridLog, Index index, int segmentNo, HazelcastProperties properties) {
        super(hybridLog, segmentNo, properties);
        Invariants.nonNegative(segmentNo);
        this.logger = Logger.getLogger(this.getClass());
        this.log = hybridLog;
        long fromLogicalAddress = this.log.firstEntry(segmentNo);
        long toLogicalAddressInclusive = this.device.segmentLastLogicalAddress(segmentNo);
        this.recordAccessor = AbstractLogBasedCompactor.prepareRecordAccessor(recordAccessor);
        this.slotAccessor = new InMemorySlotAccessorImpl(this.recordAccessor);
        this.logIterator = new LogBasedHybridLogIterator<TieredStoreRecord, TieredStoreRecord>(this.log, fromLogicalAddress, toLogicalAddressInclusive, this.slotAccessor, HybridLogIteratorType.BOUNDED);
        this.index = index;
        this.addressRemapper = new AddressRemapperImpl(this.log, index, true);
    }

    protected void compact(TieredStoreRecord entry) {
        String msg;
        TieredStoreRecord r;
        assert (this.threadIndex != -1);
        if (this.recordAccessor.isDummy(entry)) {
            this.metrics.onVisitedDummyRecord(entry.size());
            this.metrics.onVisitedRecordIsNotIndexReachable(entry.size());
            if (this.logger.isFinestEnabled()) {
                String msg2 = "Dummy logical address: " + this.log.prettyFormat(entry.getLogicalAddress()) + " in compactor segmentNo: " + this.segmentNo;
                this.logger.finest(msg2);
            }
            return;
        }
        this.metrics.onVisitedNonDummyRecord(entry.size());
        Data entryKey = entry.getKey();
        long entryLogicalAddress = entry.getLogicalAddress();
        assert (entryKey != null);
        long ioTimeNanos = 0L;
        while (true) {
            long now = System.nanoTime();
            long logicalRecord = this.index.getRaw(this.threadIndex, entryKey, entryLogicalAddress, false);
            ioTimeNanos += System.nanoTime() - now;
            if (logicalRecord == -1L) {
                Thread.yield();
                this.refreshEpochAndState();
                continue;
            }
            assert (logicalRecord >= 0L);
            if (logicalRecord == 0L) {
                this.metrics.onVisitedRecordIsNotIndexReachable(entry.size());
                if (this.logger.isFinestEnabled()) {
                    String msg3 = "Dead logical address: " + this.log.prettyFormat(entryLogicalAddress) + " in compactor segmentNo: " + this.segmentNo;
                    this.logger.finest(msg3);
                }
                return;
            }
            now = System.nanoTime();
            r = this.log.readRecordForUpdate(entryLogicalAddress, this.slotAccessor, this.addressRemapper);
            ioTimeNanos += System.nanoTime() - now;
            assert (r != null);
            if (r != Index.RETRY_RECORD) break;
            Thread.yield();
            this.refreshEpochAndState();
        }
        this.metrics.onVisitedRecordIsNotIndexReachable(entry.size());
        if (this.logger.isFinestEnabled()) {
            msg = "Dead logical address: " + this.log.prettyFormat(entryLogicalAddress) + " in compactor segmentNo: " + this.segmentNo;
            this.logger.finest(msg);
        }
        if (this.logger.isFinestEnabled()) {
            msg = "Remapped logical address: " + this.log.prettyFormat(entryLogicalAddress) + " in compactor segmentNo: " + this.segmentNo + " on address %s" + this.log.prettyFormat(r.getLogicalAddress());
            this.logger.finest(msg);
        }
        this.metrics.onVisitedIndexReachableRecord(entry.size());
        this.metrics.onIOTimeToCheckIndexReachability(ioTimeNanos);
    }

    @Override
    public boolean isDone() {
        return this.logIterator.isClosed();
    }

    protected void refreshEpochAndState() {
    }

    protected void onCompactionQueued() {
        this.log.getMetrics().onCompactionQueued();
    }

    protected void onCompactionStart() {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("starting with compaction on HybridLog with id=" + this.log.getId() + ", segmentNo=" + this.segmentNo);
        }
        this.log.getMetrics().onCompactionStart(this.createdAt);
    }

    protected void onCompactionFinish(@Nullable Throwable ex) {
        this.log.getMetrics().onCompactionFinish(this.metrics, ex != null);
        if (ex != null) {
            this.logger.warning(this.toReadableStr(ex));
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine(this.metrics.readableMetrics());
            this.logger.fine(this.logIterator.readableMetrics());
            this.logger.fine("done with compaction on HybridLog with id=" + this.log.getId() + ", segmentNo=" + this.segmentNo);
        }
    }

    @Nonnull
    private static TieredStoreRecordAccessor prepareRecordAccessor(TieredStoreRecordAccessor recordAccessor) {
        if (recordAccessor instanceof GuardedTieredStoreRecordAccessor) {
            return UnguardedTieredStoreRecordAccessor.unguard((GuardedTieredStoreRecordAccessor)recordAccessor);
        }
        return recordAccessor;
    }

    @Override
    public void init() {
    }

    @Override
    public void after() {
    }

    protected String toReadableStr(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        String ln = System.lineSeparator();
        StringBuilder sb = new StringBuilder().append("Exception during compaction of HybridLog with id=").append(this.log.getId()).append(", and fileNo=").append(this.segmentNo).append(ln).append(throwable.getMessage()).append(ln);
        for (StackTraceElement e : throwable.getStackTrace()) {
            sb.append(e.toString()).append(ln);
        }
        return sb.toString();
    }

    public String toString() {
        return String.format("Log based compactor on segment %d, device %s", this.segmentNo, this.device.deviceName());
    }

    private static class InMemorySlotAccessorImpl
    extends TieredStoreSlotAccessor {
        InMemorySlotAccessorImpl(TieredStoreRecordAccessor recordAccessor) {
            super(recordAccessor);
        }

        @Override
        public boolean isAlive(TieredStoreRecord preparedSlot) {
            return true;
        }

        @Override
        public boolean lock(TieredStoreRecord preparedSlot) {
            return true;
        }

        @Override
        public void unlock(TieredStoreRecord preparedSlot) {
        }
    }
}

