/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore;

import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Supplier;

public final class State {
    public static final int PHASE_REST = 0;
    private static final int PHASE_BITS = 4;
    private static final long PHASE_MASK = 15L;
    private static final int VERSION_SHIFT = 4;
    private static final long INTERMEDIATE_MASK = 8L;
    private static final long DETACHED = State.make(0L, 0L);
    private static final long INITIAL = State.make(0L, 1L);
    private static final AtomicLongFieldUpdater<State> STATE = AtomicLongFieldUpdater.newUpdater(State.class, "state");
    private static final AtomicIntegerFieldUpdater<State> ACTIVE = AtomicIntegerFieldUpdater.newUpdater(State.class, "active");
    private static final int STATE_PASSIVE = 0;
    private static final int STATE_ACTIVE = 1;
    private static final int STATE_CLOSED = 2;
    private final ThreadRecord[] threadRecords;
    private volatile long state = INITIAL;
    private volatile int active;
    private volatile Machine machine;

    public State(int maxThreads) {
        this.threadRecords = new ThreadRecord[maxThreads];
        for (int i = 0; i < maxThreads; ++i) {
            this.threadRecords[i] = new ThreadRecord();
        }
    }

    public static int phase(long state) {
        return (int)(state & 0xFL);
    }

    public static long version(long state) {
        return state >>> 4;
    }

    public static long make(long phase, long version) {
        assert (phase < 8L);
        return phase | version << 4;
    }

    private static long stable(long state) {
        return state & 0xFFFFFFFFFFFFFFF7L;
    }

    private static long intermediate(long state) {
        return state | 8L;
    }

    private static boolean isStable(long state) {
        return (state & 8L) == 0L;
    }

    public long register(int threadIndex) {
        Machine freshMachine;
        HybridLogImpl.assertCurrentThreadHasNoMutablePinsInstalled();
        Machine machine = this.machine;
        long state = this.state;
        while (machine != (freshMachine = this.machine)) {
            machine = freshMachine;
            state = this.state;
        }
        state = State.stable(state);
        ThreadRecord threadRecord = this.threadRecords[threadIndex];
        assert (threadRecord.machine == null && threadRecord.state == DETACHED);
        threadRecord.machine = machine;
        if (State.phase(state) == 0) {
            threadRecord.state = state;
            return state;
        }
        long start = machine.startState(state);
        assert (State.isStable(start) && State.phase(start) == 0);
        State.globalStep(threadIndex, threadRecord, machine, start, state);
        return state;
    }

    public boolean globalStart(int threadIndex, Supplier<Machine> machineSupplier) throws IllegalStateException {
        if (!ACTIVE.compareAndSet(this, 0, 1)) {
            if (ACTIVE.get(this) == 2) {
                throw new IllegalStateException("State has been closed, no more state machines can be submitted to it.");
            }
            return false;
        }
        Machine machine = machineSupplier.get();
        assert (machine != null);
        long oldState = this.state;
        assert (State.phase(oldState) == 0);
        if (!machine.validate()) {
            ACTIVE.set(this, 0);
            return false;
        }
        long newState = machine.nextState(oldState);
        assert (State.isStable(newState) && State.phase(newState) != 0 && State.version(newState) >= State.version(oldState));
        this.machine = machine;
        machine.globalEntering(threadIndex, newState, oldState);
        STATE.set(this, newState);
        machine.globalEntered(threadIndex, newState, oldState);
        return true;
    }

    public boolean globalStep(int threadIndex, long expectedState) {
        assert (State.isStable(expectedState) && expectedState != 0L);
        if (!STATE.compareAndSet(this, expectedState, State.intermediate(expectedState))) {
            return false;
        }
        Machine machine = this.machine;
        long newState = machine.nextState(expectedState);
        machine.globalEntering(threadIndex, newState, expectedState);
        STATE.set(this, newState);
        machine.globalEntered(threadIndex, newState, expectedState);
        if (State.phase(newState) == 0) {
            ACTIVE.set(this, 0);
        }
        return true;
    }

    public long refresh(int threadIndex) {
        Machine freshMachine;
        HybridLogImpl.assertCurrentThreadHasNoMutablePinsInstalled();
        Machine globalMachine = this.machine;
        long globalState = this.state;
        while (globalMachine != (freshMachine = this.machine)) {
            globalMachine = freshMachine;
            globalState = this.state;
        }
        globalState = State.stable(globalState);
        ThreadRecord threadRecord = this.threadRecords[threadIndex];
        Machine threadMachine = threadRecord.machine;
        long threadState = threadRecord.state;
        assert (State.isStable(threadState) && threadState != DETACHED);
        if (threadMachine != globalMachine) {
            if (State.phase(threadState) != 0) {
                long end = threadMachine.endState(threadState);
                assert (State.isStable(end) && State.phase(end) == 0);
                State.globalStep(threadIndex, threadRecord, threadMachine, threadState, end);
            }
            threadRecord.machine = globalMachine;
            if (State.phase(globalState) == 0) {
                threadRecord.state = globalState;
                return globalState;
            }
            threadState = globalMachine.startState(globalState);
        }
        if (threadState != globalState) {
            if (State.phase(threadState) == 0 && State.phase(globalState) == 0) {
                threadRecord.state = globalState;
                return globalState;
            }
            State.globalStep(threadIndex, threadRecord, globalMachine, threadState, globalState);
        }
        return globalState;
    }

    public long threadState(int threadIndex) {
        ThreadRecord threadRecord = this.threadRecords[threadIndex];
        long threadState = threadRecord.state;
        assert (State.isStable(threadState) && threadState != DETACHED);
        return threadState;
    }

    public void unregister(int threadIndex) {
        ThreadRecord threadRecord = this.threadRecords[threadIndex];
        assert (threadRecord.state != DETACHED);
        threadRecord.machine = null;
        threadRecord.state = DETACHED;
    }

    public boolean tryClose() throws IllegalStateException {
        if (ACTIVE.get(this) == 2) {
            throw new IllegalStateException("State has been (already) closed.");
        }
        return ACTIVE.compareAndSet(this, 0, 2);
    }

    long getState() {
        return this.state;
    }

    private static void globalStep(int threadIndex, ThreadRecord threadRecord, Machine machine, long currentState, long goalState) {
        long nextState;
        do {
            nextState = machine.nextState(currentState);
            assert (State.isStable(nextState));
            machine.threadEntering(threadIndex, nextState, currentState);
            threadRecord.state = nextState;
            machine.threadEntered(threadIndex, nextState, currentState);
            currentState = nextState;
        } while (nextState != goalState);
    }

    private static final class ThreadRecord {
        Machine machine;
        long state = DETACHED;

        private ThreadRecord() {
        }
    }

    public static abstract class Machine {
        public boolean validate() {
            return true;
        }

        public abstract long nextState(long var1);

        public abstract long startState(long var1);

        public abstract long endState(long var1);

        public void globalEntering(int threadIndex, long next, long current) {
        }

        public void globalEntered(int threadIndex, long current, long previous) {
        }

        public void threadEntering(int threadIndex, long next, long current) {
        }

        public void threadEntered(int threadIndex, long current, long previous) {
        }
    }
}

