/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore;

import com.hazelcast.internal.util.Preconditions;
import java.util.Arrays;

public final class PaddingUtil {
    private static final char ZERO = '0';

    private PaddingUtil() {
    }

    public static String leftPadUpToTenWithZero(int number) {
        Preconditions.checkNotNegative(number, "number cannot be negative");
        int size = PaddingUtil.stringSize(number);
        int diff = PadLengths.CACHE.length - size;
        if (diff >= 0) {
            return PadLengths.CACHE[diff] + number;
        }
        return String.valueOf(number);
    }

    public static String leftPadWithZero(String str, int maxPad) {
        Preconditions.checkPositive("maxPad", maxPad);
        int size = str.length();
        if (size > maxPad) {
            return str;
        }
        int length = Math.min(PadLengths.CACHE.length, maxPad);
        int diff = length - size;
        if (diff > 0) {
            return PadLengths.CACHE[diff - 1] + str;
        }
        StringBuilder sb = new StringBuilder(size);
        char[] tmp = new char[-diff];
        Arrays.fill(tmp, '0');
        return sb.append(tmp).append(str).toString();
    }

    private static int stringSize(int x) {
        int d = 1;
        if (x >= 0) {
            d = 0;
            x = -x;
        }
        int p = -10;
        for (int i = 1; i < 10; ++i) {
            if (x > p) {
                return i + d;
            }
            p = 10 * p;
        }
        return 10 + d;
    }

    private static final class PadLengths {
        private static final String ONE = "0";
        private static final String TWO = "00";
        private static final String TREE = "000";
        private static final String FOUR = "0000";
        private static final String FIVE = "00000";
        private static final String SIX = "000000";
        private static final String SEVEN = "0000000";
        private static final String EIGHT = "00000000";
        private static final String NINE = "000000000";
        private static final String[] CACHE = new String[]{"0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000"};

        private PadLengths() {
        }
    }
}

