/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.memory.NativeOutOfMemoryError;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class NativeMemoryPool {
    private static final long NULL = 0L;
    private static final long LATCHED = -1L;
    private static final AtomicLongFieldUpdater<NativeMemoryPool> SIZE = AtomicLongFieldUpdater.newUpdater(NativeMemoryPool.class, "size");
    private static final AtomicLongFieldUpdater<NativeMemoryPool> FREE_LIST = AtomicLongFieldUpdater.newUpdater(NativeMemoryPool.class, "freeList");
    private static final AtomicIntegerFieldUpdater<NativeMemoryPool> POOL_USER_COUNT = AtomicIntegerFieldUpdater.newUpdater(NativeMemoryPool.class, "poolUserCount");
    private final MemoryAllocator allocator;
    private final int blockSize;
    private final long arrays;
    private final int preAllocatedBlocks;
    private volatile long size;
    private volatile long freeList = 0L;
    private volatile int poolUserCount;

    public NativeMemoryPool(MemoryAllocator allocator, int blockSize, int preAllocatedBlocks) {
        assert (QuickMath.isPowerOfTwo(preAllocatedBlocks));
        assert (blockSize >= 8);
        this.allocator = allocator;
        this.blockSize = blockSize;
        this.arrays = allocator.allocate(512L);
        GlobalMemoryAccessorRegistry.AMEM.setMemory(this.arrays, 512L, (byte)0);
        this.preAllocatedBlocks = preAllocatedBlocks;
        if (this.preAllocatedBlocks != 0) {
            long array = allocator.allocate((long)preAllocatedBlocks * (long)blockSize);
            int arrayCount = 32 - Integer.numberOfLeadingZeros(preAllocatedBlocks);
            for (int i = 0; i < arrayCount; ++i) {
                NativeMemoryPool.write(this.arrays + (long)i * 8L, array);
                long arraySize = (1L << i) + 1L >>> 1;
                array += arraySize * (long)blockSize;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long acquire() {
        this.enter();
        try {
            long block;
            while ((block = this.freeList) != 0L) {
                if (block == -1L || !FREE_LIST.compareAndSet(this, block, -1L)) continue;
                long next = NativeMemoryPool.read(block) ^ 0xFFFFFFFFFFFFFFFFL;
                FREE_LIST.set(this, next);
                long l = block;
                return l;
            }
            long index = SIZE.getAndIncrement(this);
            int arrayIndex = 64 - Long.numberOfLeadingZeros(index);
            long arrayPointer = this.arrays + (long)(arrayIndex * 8);
            long array = NativeMemoryPool.read(arrayPointer);
            if (array == 0L) {
                if (NativeMemoryPool.cas(arrayPointer, 0L, -1L)) {
                    long arraySize = (1L << arrayIndex) + 1L >>> 1;
                    try {
                        array = this.allocator.allocate(arraySize * (long)this.blockSize);
                    }
                    catch (NativeOutOfMemoryError oom) {
                        NativeMemoryPool.write(arrayPointer, 0L);
                        SIZE.decrementAndGet(this);
                        throw oom;
                    }
                    NativeMemoryPool.write(arrayPointer, array);
                } else {
                    do {
                        Thread.yield();
                    } while ((array = NativeMemoryPool.read(arrayPointer)) == -1L);
                    if (array == 0L) {
                        SIZE.decrementAndGet(this);
                        throw new NativeOutOfMemoryError();
                    }
                }
            } else {
                while (array == -1L) {
                    Thread.yield();
                    array = NativeMemoryPool.read(arrayPointer);
                }
                if (array == 0L) {
                    SIZE.decrementAndGet(this);
                    throw new NativeOutOfMemoryError();
                }
            }
            long indexInArray = index - (1L << arrayIndex >>> 1);
            long l = block = array + indexInArray * (long)this.blockSize;
            return l;
        }
        finally {
            this.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(long block) {
        this.enter();
        try {
            long head;
            do {
                head = this.freeList;
                NativeMemoryPool.write(block, head ^ 0xFFFFFFFFFFFFFFFFL);
            } while (head == -1L || !FREE_LIST.compareAndSet(this, head, block));
        }
        finally {
            this.exit();
        }
    }

    public boolean isAcquired(long block) {
        return NativeMemoryPool.read(block) >= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closeEnter();
        try {
            int preAllocatedArrayCount;
            if (this.preAllocatedBlocks != 0) {
                this.allocator.free(NativeMemoryPool.read(this.arrays), (long)this.preAllocatedBlocks * (long)this.blockSize);
            }
            for (int i = preAllocatedArrayCount = 32 - Integer.numberOfLeadingZeros(this.preAllocatedBlocks); i < 64; ++i) {
                long array = NativeMemoryPool.read(this.arrays + (long)(i * 8));
                if (array == 0L) continue;
                long arraySize = (1L << i) + 1L >>> 1;
                this.allocator.free(array, arraySize * (long)this.blockSize);
            }
            this.allocator.free(this.arrays, 512L);
        }
        finally {
            this.closeExit();
        }
    }

    private void enter() {
        int userCnt;
        while ((userCnt = POOL_USER_COUNT.get(this)) != -1 && !POOL_USER_COUNT.weakCompareAndSet(this, userCnt, userCnt + 1)) {
        }
        if (userCnt == -1) {
            throw new IllegalStateException("native memory pool has been closed");
        }
    }

    private void exit() {
        int userCnt = POOL_USER_COUNT.getAndDecrement(this);
        Invariants.greaterOrEqualThan(userCnt, 0, "Pool had been closed before all threads finished read/write on it.");
    }

    private void closeEnter() {
        while (!POOL_USER_COUNT.weakCompareAndSet(this, 0, -1)) {
            Thread.yield();
            if (POOL_USER_COUNT.get(this) != -1) continue;
            throw new IllegalStateException("native memory pool has been closed");
        }
    }

    private void closeExit() {
    }

    protected MemoryAllocator getAllocator() {
        return this.allocator;
    }

    protected int getBlockSize() {
        return this.blockSize;
    }

    protected long getSize() {
        return this.size;
    }

    private static long read(long address) {
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(address);
    }

    private static void write(long address, long value) {
        GlobalMemoryAccessorRegistry.AMEM.putLongVolatile(address, value);
    }

    private static boolean cas(long address, long expected, long value) {
        return GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(address, expected, value);
    }
}

