/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.LongConsumer;

public final class Epoch {
    private static final long BUMP_STUCK_LOG_THRESHOLD = 1048575L;
    private static final boolean DEBUG = Epoch.class.desiredAssertionStatus();
    private static final boolean TRACK_THREADS = Boolean.getBoolean("hazelcast.tstore.epoch.track.threads");
    private static final ILogger LOGGER = Logger.getLogger(Epoch.class);
    private static final int CACHE_LINE_SCALE = 6;
    private static final long CACHE_LINE = 64L;
    private static final int ACTION_RECORDS_COUNT = 16;
    private static final long FREE = Long.MAX_VALUE;
    private static final long MAX = 0x7FFFFFFFFFFFFFFEL;
    private static final long PAUSED = 0x7FFFFFFFFFFFFFFEL;
    private static final long LOCKED = 0x7FFFFFFFFFFFFFFEL;
    private static final int MAX_STACK_TRACE_DEPTH = 10;
    private static final LongConsumer NOP_LONG_CONSUMER = v -> {};
    private static final AtomicLongFieldUpdater<Epoch> EPOCH = AtomicLongFieldUpdater.newUpdater(Epoch.class, "epoch");
    private static final AtomicLongFieldUpdater<Epoch> PUBLISHED = AtomicLongFieldUpdater.newUpdater(Epoch.class, "published");
    private final int maxThreads;
    private final MemoryAllocator allocator;
    private volatile long epoch = 1L;
    private volatile long published = 1L;
    private final long unalignedThreadEpochs;
    private final long threadEpochs;
    private final ActionRecord[] actionRecords = new ActionRecord[16];
    private final ThreadLocal<ThreadIndexRecord> currentThreadIndex = ThreadLocal.withInitial(ThreadIndexRecord::new);
    private final ConcurrentHashMap<Thread, ThreadIndexRecord> registeredThreads;
    private volatile boolean isClosed;

    public Epoch(int maxThreads, MemoryAllocator allocator) {
        int i;
        this.maxThreads = maxThreads = QuickMath.nextPowerOfTwo(maxThreads);
        this.allocator = allocator;
        this.unalignedThreadEpochs = allocator.allocate((long)maxThreads + 1L << 6);
        this.threadEpochs = this.unalignedThreadEpochs + 64L - 1L & 0xFFFFFFFFFFFFFFC0L;
        for (i = 0; i < maxThreads; ++i) {
            this.setThreadEpoch(i, Long.MAX_VALUE);
        }
        for (i = 0; i < 16; ++i) {
            this.actionRecords[i] = new ActionRecord();
        }
        this.registeredThreads = TRACK_THREADS ? new ConcurrentHashMap() : null;
    }

    public int maxThreads() {
        return this.maxThreads;
    }

    public int register() {
        this.checkClosed();
        ThreadIndexRecord threadIndexRecord = this.currentThreadIndex.get();
        int threadIndex = threadIndexRecord.value;
        assert (threadIndex > 0) : "call from action";
        assert (threadIndex == 0x7FFFFFFE) : Thread.currentThread().getName() + " is already registered";
        int mask = this.maxThreads - 1;
        threadIndex = (int)Thread.currentThread().getId() & mask;
        block0: while (true) {
            long current = this.obtainEpoch();
            for (int i = 0; i < this.maxThreads; ++i) {
                long threadEpoch = this.getThreadEpoch(threadIndex);
                if (threadEpoch == Long.MAX_VALUE && this.casThreadEpoch(threadIndex, Long.MAX_VALUE, current)) break block0;
                threadIndex = threadIndex + 1 & mask;
            }
            Thread.yield();
        }
        threadIndexRecord.value = threadIndex;
        if (TRACK_THREADS) {
            this.registeredThreads.put(Thread.currentThread(), threadIndexRecord);
        }
        return threadIndex;
    }

    public boolean isCurrentThreadRegistered() {
        this.checkClosed();
        int threadIndex = this.currentThreadIndex.get().value;
        return threadIndex != 0x7FFFFFFE;
    }

    public int getCurrentThreadIndex() {
        this.checkClosed();
        int threadIndex = this.currentThreadIndex.get().value;
        if (DEBUG && threadIndex < 0) {
            threadIndex = -threadIndex - 1;
        }
        assert (threadIndex != 0x7FFFFFFE) : "not registered(threadIndex=" + threadIndex + ")";
        return threadIndex;
    }

    public void refresh(int threadIndex) {
        assert (threadIndex >= 0) : "threadIndex=" + threadIndex;
        this.checkClosed();
        long threadEpoch = this.getThreadEpoch(threadIndex);
        assert (threadEpoch > 0L) : "call from action";
        assert (threadEpoch != Long.MAX_VALUE) : "not registered";
        assert (threadEpoch != 0x7FFFFFFFFFFFFFFEL) : "paused";
        long current = this.obtainEpoch();
        this.setThreadEpoch(threadIndex, current);
        long safe = this.computeSafeEpoch(current);
        this.runSafeActions(threadIndex, safe, current);
    }

    public void bump(int threadIndex, Action action) {
        this.bump(threadIndex, action, NOP_LONG_CONSUMER);
    }

    public void bump(int threadIndex, Action action, LongConsumer publish) {
        this.checkClosed();
        long threadEpoch = this.getThreadEpoch(threadIndex);
        assert (threadEpoch > 0L) : "call from action";
        assert (threadEpoch != Long.MAX_VALUE) : "not registered";
        assert (threadEpoch != 0x7FFFFFFFFFFFFFFEL) : "paused";
        long newEpoch = this.advanceEpoch(publish);
        long actionEpoch = newEpoch - 1L;
        long tryCount = 0L;
        long lastLoggedTryCount = 0L;
        while (true) {
            this.setThreadEpoch(threadIndex, newEpoch);
            long safe = this.computeSafeEpoch(newEpoch);
            this.runSafeActions(threadIndex, safe, newEpoch);
            if (actionEpoch <= safe) {
                this.run(action, threadIndex, actionEpoch, newEpoch);
                return;
            }
            for (int i = 0; i < 16; ++i) {
                ActionRecord actionRecord = this.actionRecords[i];
                if (actionRecord.epoch != Long.MAX_VALUE || !ActionRecord.EPOCH.compareAndSet(actionRecord, Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL)) continue;
                actionRecord.action = action;
                ActionRecord.EPOCH.set(actionRecord, actionEpoch);
                if (TRACK_THREADS) {
                    Thread thread;
                    actionRecord.thread = thread = Thread.currentThread();
                    actionRecord.stack = thread.getStackTrace();
                }
                return;
            }
            if (++tryCount - lastLoggedTryCount > 1048575L) {
                lastLoggedTryCount = tryCount;
                this.warnBumpStuck(tryCount);
            }
            Thread.yield();
            newEpoch = this.obtainEpoch();
        }
    }

    private void warnBumpStuck(long tryCount) {
        String msg = "Stuck in bumping epoch, tryCount=" + tryCount + System.lineSeparator() + this.debugInfo();
        LOGGER.warning(msg);
    }

    public void unregister(int threadIndex) {
        this.checkClosed();
        long threadEpoch = this.getThreadEpoch(threadIndex);
        assert (threadEpoch > 0L) : "call from action";
        assert (threadEpoch != Long.MAX_VALUE) : "not registered (threadEpoch=" + threadEpoch + ")";
        assert (threadEpoch != 0x7FFFFFFFFFFFFFFEL) : "paused";
        this.setThreadEpoch(threadIndex, 0x7FFFFFFFFFFFFFFEL);
        long newEpoch = this.advanceEpoch();
        long safe = this.computeSafeEpoch(newEpoch);
        this.runSafeActions(threadIndex, safe, 0x7FFFFFFFFFFFFFFEL);
        this.currentThreadIndex.get().value = 0x7FFFFFFE;
        this.setThreadEpoch(threadIndex, Long.MAX_VALUE);
        if (TRACK_THREADS) {
            this.registeredThreads.remove(Thread.currentThread());
        }
    }

    public void pause(int threadIndex) {
        this.checkClosed();
        long threadEpoch = this.getThreadEpoch(threadIndex);
        assert (threadEpoch > 0L) : "call from action";
        assert (threadEpoch != Long.MAX_VALUE) : "not registered";
        assert (threadEpoch != 0x7FFFFFFFFFFFFFFEL) : "already paused";
        this.setThreadEpoch(threadIndex, 0x7FFFFFFFFFFFFFFEL);
        long newEpoch = this.advanceEpoch();
        long safe = this.computeSafeEpoch(newEpoch);
        this.runSafeActions(threadIndex, safe, 0x7FFFFFFFFFFFFFFEL);
    }

    public void resume(int threadIndex) {
        this.checkClosed();
        long threadEpoch = this.getThreadEpoch(threadIndex);
        assert (threadEpoch > 0L) : "call from action";
        assert (threadEpoch != Long.MAX_VALUE) : "not registered";
        assert (threadEpoch == 0x7FFFFFFFFFFFFFFEL) : "not paused";
        this.setThreadEpoch(threadIndex, this.obtainEpoch());
    }

    public void close() {
        this.checkClosed();
        this.isClosed = true;
        this.allocator.free(this.unalignedThreadEpochs, (long)this.maxThreads + 1L << 6);
    }

    public String debugInfo() {
        this.checkClosed();
        int threadIdx = this.currentThreadIndex.get().value;
        if (threadIdx < 0) {
            threadIdx = -threadIdx - 1;
        }
        long threadEpoch = this.getThreadEpoch(threadIdx);
        StringBuilder sb = new StringBuilder();
        String ln = System.lineSeparator();
        String tab = "\t";
        long epoch = EPOCH.get(this);
        sb.append(Thread.currentThread().getName()).append(" -- Epoch#debugInfo:").append(ln).append("currentThreadIndex=").append(threadIdx).append(", currentThreadEpoch=").append(threadEpoch).append(ln).append("globalEpoch=").append(epoch).append(ln).append("committedEpoch=").append(this.published).append(ln).append("safeEpoch=").append(this.computeSafeEpoch(epoch)).append(ln);
        sb.append("ActionRecords:").append(ln);
        long minPendingEpoch = Long.MAX_VALUE;
        for (ActionRecord r : this.actionRecords) {
            sb.append(ln).append(tab).append("{epoch=");
            if (r.epoch == Long.MAX_VALUE) {
                sb.append("FREE}");
                continue;
            }
            if (r.epoch == 0x7FFFFFFFFFFFFFFEL) {
                sb.append("LOCKED}");
                continue;
            }
            sb.append(r.epoch);
            if (r.thread != null) {
                sb.append(", thread=").append("\"").append(r.thread.getName()).append("\"").append(", stack={");
                Epoch.appendStackTrace(sb, ln, tab + tab, r.stack);
                sb.append("}}").append(ln);
            } else {
                sb.append('}');
            }
            minPendingEpoch = Math.min(minPendingEpoch, Math.abs(r.epoch));
        }
        if (this.registeredThreads != null) {
            sb.append(ln).append("Epoch participating threads:").append(ln);
            boolean foundLaggingThread = false;
            for (Map.Entry<Thread, ThreadIndexRecord> entry : this.registeredThreads.entrySet()) {
                long thatThreadEpoch;
                Thread thread = entry.getKey();
                int thatThreadIdx = entry.getValue().value;
                if (thatThreadIdx == 0x7FFFFFFE) continue;
                if (thatThreadIdx < 0) {
                    thatThreadIdx = -thatThreadIdx - 1;
                }
                boolean lagging = (thatThreadEpoch = this.getThreadEpoch(thatThreadIdx)) <= minPendingEpoch && minPendingEpoch < 0x7FFFFFFFFFFFFFFEL;
                foundLaggingThread |= lagging;
                sb.append(ln).append(lagging ? "LAGGING " : "").append("\"").append(thread.getName()).append("\"").append("[id=").append(thread.getId()).append(", threadIdx=").append(thatThreadIdx).append(", epoch=").append(thatThreadEpoch).append("]");
                Epoch.appendStackTrace(sb, ln, tab, thread.getStackTrace());
                sb.append(ln);
            }
            if (!foundLaggingThread) {
                sb.append(ln).append("No lagging thread is found").append(ln);
            }
        } else {
            sb.append(ln).append(ln).append("Tracking registered threads is off, ").append("hazelcast.tstore.epoch.track.threads").append('=').append(TRACK_THREADS);
        }
        return sb.toString();
    }

    private static void appendStackTrace(StringBuilder sb, String ln, String tab, StackTraceElement[] stackTrace) {
        for (int i = 0; i < Math.min(stackTrace.length, 10); ++i) {
            sb.append(ln).append(tab).append(stackTrace[i]);
        }
        if (stackTrace.length > 10) {
            sb.append(ln).append(tab).append("...");
        }
    }

    public long nativeMemoryConsumptionBytes() {
        return (long)this.maxThreads + 1L << 6;
    }

    public boolean inEpochAction() {
        if (!DEBUG) {
            throw new IllegalStateException("Epoch.inEpochAction() should be called only when assertions are enabled (from assertions)");
        }
        return this.currentThreadIndex.get().value < 0;
    }

    void register(int threadIndex) {
        this.checkClosed();
        long threadEpoch = this.getThreadEpoch(threadIndex);
        assert (threadEpoch > 0L) : "call from action";
        assert (threadEpoch == Long.MAX_VALUE) : "already registered";
        this.setThreadEpoch(threadIndex, this.obtainEpoch());
    }

    private long obtainEpoch() {
        long current = EPOCH.get(this);
        this.syncEpoch(current);
        return current;
    }

    private long advanceEpoch() {
        long newEpoch = EPOCH.incrementAndGet(this);
        this.syncEpoch(newEpoch - 1L);
        PUBLISHED.incrementAndGet(this);
        return newEpoch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long advanceEpoch(LongConsumer publish) {
        long newEpoch = EPOCH.incrementAndGet(this);
        long actionEpoch = newEpoch - 1L;
        this.syncEpoch(actionEpoch);
        try {
            publish.accept(actionEpoch);
        }
        finally {
            PUBLISHED.incrementAndGet(this);
        }
        return newEpoch;
    }

    private void syncEpoch(long epoch) {
        int counter = 0;
        while (PUBLISHED.get(this) < epoch) {
            if ((++counter & 0x1FF) != 0) continue;
            Thread.yield();
        }
    }

    long publishedEpoch() {
        return PUBLISHED.get(this);
    }

    private long computeSafeEpoch(long current) {
        long oldest = current;
        for (int i = 0; i < this.maxThreads; ++i) {
            long threadEpoch = this.getThreadEpoch(i);
            if (DEBUG) {
                threadEpoch = Math.abs(threadEpoch);
            }
            oldest = Math.min(oldest, threadEpoch);
        }
        return oldest - 1L;
    }

    private void runSafeActions(int threadIndex, long safe, long threadEpoch) {
        for (int i = 0; i < 16; ++i) {
            ActionRecord actionRecord = this.actionRecords[i];
            long epoch = actionRecord.epoch;
            if (epoch > safe || !ActionRecord.EPOCH.compareAndSet(actionRecord, epoch, 0x7FFFFFFFFFFFFFFEL)) continue;
            Action action = actionRecord.action;
            actionRecord.action = null;
            ActionRecord.EPOCH.set(actionRecord, Long.MAX_VALUE);
            this.run(action, threadIndex, epoch, threadEpoch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Action action, int threadIndex, long actionEpoch, long threadEpoch) {
        if (DEBUG) {
            this.currentThreadIndex.get().value = -(threadIndex + 1);
            this.setThreadEpoch(threadIndex, -threadEpoch);
        }
        try {
            action.run(threadIndex, actionEpoch);
        }
        finally {
            if (DEBUG) {
                this.setThreadEpoch(threadIndex, threadEpoch);
                this.currentThreadIndex.get().value = threadIndex;
            }
        }
    }

    private void checkClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Epoch has been closed/disposed.");
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public long getThreadEpoch(int threadIndex) {
        assert (threadIndex >= 0);
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(this.threadEpochs + ((long)threadIndex << 6));
    }

    private void setThreadEpoch(int threadIndex, long epoch) {
        assert (threadIndex >= 0);
        GlobalMemoryAccessorRegistry.AMEM.putLongVolatile(this.threadEpochs + ((long)threadIndex << 6), epoch);
    }

    private boolean casThreadEpoch(int threadIndex, long expected, long epoch) {
        assert (threadIndex >= 0);
        return GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(this.threadEpochs + ((long)threadIndex << 6), expected, epoch);
    }

    private static final class ActionRecord {
        static final AtomicLongFieldUpdater<ActionRecord> EPOCH = AtomicLongFieldUpdater.newUpdater(ActionRecord.class, "epoch");
        volatile long epoch = Long.MAX_VALUE;
        Action action;
        Thread thread;
        StackTraceElement[] stack;

        private ActionRecord() {
        }
    }

    private static final class ThreadIndexRecord {
        static final int FREE = 0x7FFFFFFE;
        int value = 0x7FFFFFFE;

        private ThreadIndexRecord() {
        }
    }

    @FunctionalInterface
    public static interface Action {
        public void run(int var1, long var2);
    }
}

