/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.nio;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.internal.nio.ssl.SSLEngineFactorySupport;
import com.hazelcast.nio.ssl.SSLEngineFactory;
import java.util.Properties;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class FinishingSSLEngineFactoryDecorator
implements SSLEngineFactory {
    private final SSLEngineFactory backing;
    private final String mutualAuthentication;
    private final boolean validateIdentity;

    public FinishingSSLEngineFactoryDecorator(SSLEngineFactory backing, SSLConfig sslConfig) {
        this.backing = backing;
        this.mutualAuthentication = SSLEngineFactorySupport.getProperty(sslConfig.getProperties(), "mutualAuthentication");
        this.validateIdentity = Boolean.parseBoolean(SSLEngineFactorySupport.getProperty(sslConfig.getProperties(), "validateIdentity"));
    }

    @Override
    public void init(Properties properties, boolean forClient) throws Exception {
        this.backing.init(properties, forClient);
    }

    @Override
    public SSLEngine create(boolean clientMode, Address peerAddress) {
        SSLEngine sslEngine = this.backing.create(clientMode, peerAddress);
        if (this.validateIdentity && peerAddress != null) {
            SSLParameters sslParams = new SSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParams);
        }
        if ("REQUIRED".equals(this.mutualAuthentication)) {
            sslEngine.setNeedClientAuth(true);
        } else if ("OPTIONAL".equals(this.mutualAuthentication)) {
            sslEngine.setWantClientAuth(true);
        }
        return sslEngine;
    }
}

